/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.row;

import com.streamscape.ds.io.rowio.AbstractRowInputText;
import com.streamscape.ds.io.rowio.RowInputInterface;
import com.streamscape.ds.io.rowio.RowOutputInterface;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.RowStoreAVLDiskData;
import com.streamscape.ds.persist.index.NodeAVL;
import com.streamscape.ds.persist.row.RowAVL;
import com.streamscape.ds.schema.table.TableBase;
import java.io.IOException;

public class RowAVLDiskData
extends RowAVL {
    RowStoreAVLDiskData store;
    int accessCount;
    boolean hasDataChanged;
    int storageSize;
    int blockNumber;
    byte[] lineSeparatorBytes;

    public RowAVLDiskData(RowStoreAVLDiskData store, TableBase t, Object[] o) {
        super(t, o);
        this.setNewNodes(store);
        this.hasDataChanged = true;
        this.store = store;
    }

    public RowAVLDiskData(RowStoreAVLDiskData store, TableBase t, Object[] o, RowInputInterface in) {
        this(store, t, o);
        this.position = in.getPos();
        this.storageSize = in.getSize();
        this.blockNumber = in.getBlock();
        this.initLineSeparator(in);
    }

    public RowAVLDiskData(RowStoreAVLDiskData store, TableBase t, RowInputInterface in) throws IOException {
        super(t, null);
        this.setNewNodes(store);
        this.hasDataChanged = false;
        this.store = store;
        this.position = in.getPos();
        this.storageSize = in.getSize();
        this.rowData = in.readData(this.table.getColumnTypes());
        this.initLineSeparator(in);
    }

    private void initLineSeparator(RowInputInterface in) {
        if (in instanceof AbstractRowInputText) {
            this.lineSeparatorBytes = ((AbstractRowInputText)in).getLineSeparatorBytes();
        }
    }

    public byte[] getLineSeparatorBytes() {
        return this.lineSeparatorBytes;
    }

    public static Object[] getRowData(TableBase t, RowInputInterface in) throws IOException {
        return in.readData(t.getColumnTypes());
    }

    public void setData(Object[] data) {
        this.rowData = data;
    }

    @Override
    public Object[] getData() {
        Object[] data = this.rowData;
        if (data == null) {
            this.store.getData(this, false);
            data = this.rowData;
            this.keepInMemory(false);
        } else {
            ++this.accessCount;
        }
        return data;
    }

    @Override
    public void setNewNodes(PersistentStore store) {
        int index = store.getAccessorKeys().length;
        NodeAVL n = this.nPrimaryNode = new NodeAVL(this);
        for (int i = 1; i < index; ++i) {
            n = n.nNext = new NodeAVL(this);
        }
    }

    @Override
    public NodeAVL insertNode(int index) {
        NodeAVL backnode = this.getNode(index - 1);
        NodeAVL newnode = new NodeAVL(this);
        newnode.nNext = backnode.nNext;
        backnode.nNext = newnode;
        return newnode;
    }

    void setPrimaryNode(NodeAVL primary) {
        this.nPrimaryNode = primary;
    }

    @Override
    public int getRealSize(RowOutputInterface out) {
        return out.getSize(this);
    }

    @Override
    public void write(RowOutputInterface out) {
        out.writeSize(this.storageSize);
        out.writeData(this, this.table.colTypes);
        out.writeEnd();
        this.setChanged(false);
    }

    @Override
    public synchronized void setChanged(boolean changed) {
        this.hasDataChanged = changed;
    }

    @Override
    public boolean hasChanged() {
        return this.hasDataChanged;
    }

    @Override
    public void updateAccessCount(int count) {
        this.accessCount = count;
    }

    @Override
    public int getAccessCount() {
        return this.accessCount;
    }

    @Override
    public int getStorageSize() {
        return this.storageSize;
    }

    @Override
    public void setStorageSize(int size) {
        this.storageSize = size;
    }

    @Override
    public void setPos(int pos) {
        this.position = pos;
    }

    @Override
    public boolean isMemory() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this;
    }

    @Override
    public boolean isInMemory() {
        return this.rowData != null;
    }

    @Override
    public boolean isKeepInMemory() {
        return false;
    }

    @Override
    public boolean keepInMemory(boolean keep) {
        return true;
    }

    @Override
    public void setInMemory(boolean in) {
        if (!in) {
            this.rowData = null;
        }
    }

    @Override
    public int getBlock() {
        return this.blockNumber;
    }

    @Override
    public void setBlock(int block) {
        this.blockNumber = block;
    }
}

