/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.row;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.RowInputInterface;
import com.streamscape.ds.io.rowio.RowOutputInterface;
import com.streamscape.ds.lib.IntLookup;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.index.NodeAVL;
import com.streamscape.ds.persist.index.NodeAVLDisk;
import com.streamscape.ds.persist.row.RowAVL;
import com.streamscape.ds.schema.table.TableBase;
import java.io.IOException;

public class RowAVLDisk
extends RowAVL {
    public static final int NO_POS = -1;
    int storageSize;
    int keepCount;
    volatile boolean isInMemory;
    int accessCount;
    boolean isNew;
    protected boolean hasDataChanged;
    boolean hasNodesChanged;

    public RowAVLDisk(TableBase t, Object[] o, PersistentStore store) {
        super(t, o);
        this.setNewNodes(store);
        this.isNew = true;
        this.hasNodesChanged = true;
        this.hasDataChanged = true;
    }

    public RowAVLDisk(TableBase t, RowInputInterface in) throws IOException {
        super(t, null);
        this.position = in.getPos();
        this.storageSize = in.getSize();
        int indexcount = t.getIndexCount();
        NodeAVL n = this.nPrimaryNode = new NodeAVLDisk(this, in, 0);
        for (int i = 1; i < indexcount; ++i) {
            n = n.nNext = new NodeAVLDisk(this, in, i);
        }
        this.rowData = in.readData(this.table.getColumnTypes());
    }

    @Override
    public NodeAVL insertNode(int index) {
        return null;
    }

    private void readRowInfo(RowInputInterface in) throws IOException {
    }

    public synchronized void setNodesChanged() {
        this.hasNodesChanged = true;
    }

    @Override
    public void updateAccessCount(int count) {
        this.accessCount = count;
    }

    @Override
    public int getAccessCount() {
        return this.accessCount;
    }

    @Override
    public int getStorageSize() {
        return this.storageSize;
    }

    @Override
    public boolean isMemory() {
        return false;
    }

    @Override
    public void setPos(int pos) {
        this.position = pos;
    }

    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public synchronized void setChanged(boolean changed) {
        this.hasDataChanged = changed;
        this.isNew = changed;
    }

    @Override
    public synchronized boolean hasChanged() {
        return this.hasNodesChanged || this.hasDataChanged;
    }

    @Override
    public TableBase getTable() {
        return this.table;
    }

    @Override
    public void setStorageSize(int size) {
        this.storageSize = size;
    }

    @Override
    public synchronized boolean isKeepInMemory() {
        return this.keepCount > 0;
    }

    @Override
    public void delete(PersistentStore store) {
        RowAVLDisk row = this;
        if (!row.keepInMemory(true)) {
            row = (RowAVLDisk)store.get(row, true);
        }
        super.delete(store);
        row.keepInMemory(false);
    }

    @Override
    public void destroy() {
        this.nPrimaryNode = null;
        this.table = null;
    }

    @Override
    public synchronized boolean keepInMemory(boolean keep) {
        if (!this.isInMemory) {
            return false;
        }
        if (keep) {
            ++this.keepCount;
        } else {
            --this.keepCount;
            if (this.keepCount < 0) {
                throw Error.runtimeError(201, "RowAVLDisk - keep count");
            }
        }
        return true;
    }

    @Override
    public synchronized boolean isInMemory() {
        return this.isInMemory;
    }

    @Override
    public synchronized void setInMemory(boolean in) {
        this.isInMemory = in;
        if (in) {
            return;
        }
        NodeAVL n = this.nPrimaryNode;
        while (n != null) {
            n.setInMemory(in);
            n = n.nNext;
        }
    }

    @Override
    public void setNewNodes(PersistentStore store) {
        int indexcount = store.getAccessorKeys().length;
        NodeAVL n = this.nPrimaryNode = new NodeAVLDisk(this, 0);
        for (int i = 1; i < indexcount; ++i) {
            n = n.nNext = new NodeAVLDisk(this, i);
        }
    }

    @Override
    public int getRealSize(RowOutputInterface out) {
        return out.getSize(this);
    }

    @Override
    public void write(RowOutputInterface out) {
        try {
            this.writeNodes(out);
            if (this.hasDataChanged) {
                out.writeData(this, this.table.colTypes);
                out.writeEnd();
                this.setChanged(false);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void write(RowOutputInterface out, IntLookup lookup) {
        out.writeSize(this.storageSize);
        NodeAVL rownode = this.nPrimaryNode;
        while (rownode != null) {
            ((NodeAVLDisk)rownode).write(out, lookup);
            rownode = rownode.nNext;
        }
        out.writeData(this, this.table.colTypes);
        out.writeEnd();
    }

    protected void writeNodes(RowOutputInterface out) throws IOException {
        out.writeSize(this.storageSize);
        NodeAVL n = this.nPrimaryNode;
        while (n != null) {
            n.write(out);
            n = n.nNext;
        }
        this.hasNodesChanged = false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RowAVLDisk) {
            return ((RowAVLDisk)obj).position == this.position;
        }
        return false;
    }
}

