/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.jfq;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.persist.jfq.FileQueueFilesManager;
import com.streamscape.ds.persist.jfq.FileQueueRowTypesKeysHolder;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableBase;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.Type;
import java.io.IOException;

public class IndexJFQ
implements Index {
    private final NameManager.ObjectName name;
    private final long persistenceId;
    private final int[] defaultColMap;
    private final boolean isSimpleOrder;
    private TableBase table;
    private final int[] columns;
    private final boolean[] descending;
    private final boolean[] nullsLast;
    private final Type[] colTypes;
    private final boolean pk;
    private final boolean unique;
    private final boolean constraint;
    private final boolean forward;
    private int position;
    private FileQueueFilesManager manager;
    private FileQueueRowTypesKeysHolder.KeyHolder keyHolder;

    public IndexJFQ(NameManager.ObjectName name, long persistenceId, TableBase table, int[] columns, boolean[] descending, boolean[] nullsLast, Type[] colTypes, boolean pk, boolean unique, boolean constraint, boolean forward) {
        this.name = name;
        this.persistenceId = persistenceId;
        this.table = table;
        this.columns = columns;
        this.descending = descending == null ? new boolean[columns.length] : descending;
        this.nullsLast = nullsLast;
        this.colTypes = colTypes;
        this.pk = pk;
        this.unique = unique;
        this.constraint = constraint;
        this.forward = forward;
        this.isSimpleOrder = true;
        this.defaultColMap = new int[columns.length];
        ArrayUtil.fillSequence(this.defaultColMap);
    }

    public void init(FileQueueFilesManager manager) {
        this.manager = manager;
        this.keyHolder = manager.getTypesKeyHolder().getKeyForColumns(this.columns);
        if (this.keyHolder == null) {
            throw new DataspaceException("Index with specified column not found for index " + this.name.getSchemaQualifiedStatementName() + ".");
        }
    }

    @Override
    public RowIterator emptyIterator() {
        return new EmptyRowIteratorJFQ();
    }

    @Override
    public int size(Session session, PersistentStore store) {
        return (int)store.elementCount(session);
    }

    @Override
    public int sizeUnique(PersistentStore store) {
        return store.elementCountUnique(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty(PersistentStore store) {
        try (FileQueueFilesManager.FileQueueDataReader reader = this.manager.createDataReader();){
            reader.seekToFirst();
            boolean bl = reader.readNext() == null;
            return bl;
        }
    }

    @Override
    public void checkIndex(PersistentStore store) {
    }

    @Override
    public void insert(Session session, PersistentStore store, Row row) {
        throw new DataspaceException("Insert into JFQ is not allowed.");
    }

    @Override
    public void delete(Session session, PersistentStore store, Row row) {
        throw new DataspaceException("Delete from JFQ is not allowed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean existsParent(Session session, PersistentStore store, Object[] rowdata, int[] rowColMap) {
        try (FileQueueFilesManager.FileQueueDataReader reader = this.manager.createDataReader();){
            reader.seekToFirst(row -> {
                int columnIndex = this.keyHolder.getColumnIndexes()[0];
                return this.keyHolder.getKeyTypes()[columnIndex].compare(session, row[columnIndex], rowdata[columnIndex]);
            }, () -> this.keyHolder.getColumnIndexes(), FileQueueFilesManager.SeekType.EQUALS);
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public RowIterator findFirstRow(Session session, PersistentStore store, Object[] rowdata, int matchCount, int distinctCount, int compareType, boolean reversed, boolean[] map) {
        if (compareType == 48) {
            return this.firstRow(session, store);
        }
        FileQueueFilesManager.SeekType seekType = null;
        switch (compareType) {
            case 41: {
                seekType = FileQueueFilesManager.SeekType.EQUALS;
                break;
            }
            case 42: {
                seekType = FileQueueFilesManager.SeekType.LESS_EQUALS;
                break;
            }
            case 43: {
                seekType = FileQueueFilesManager.SeekType.LESS;
                break;
            }
            case 45: {
                seekType = FileQueueFilesManager.SeekType.GREATER_EQUALS;
                break;
            }
            case 44: {
                seekType = FileQueueFilesManager.SeekType.GREATER;
                break;
            }
            case 74: {
                return this.lastRow(session, store);
            }
            case 73: {
                return this.firstRow(session, store);
            }
        }
        return this.findFirstRowInternal(session, store, rowdata, null, reversed, seekType);
    }

    @Override
    public RowIterator findFirstRow(Session session, PersistentStore store, Object[] rowdata) {
        return this.findFirstRow(session, store, rowdata, null);
    }

    @Override
    public RowIterator findFirstRow(Session session, PersistentStore store, Object[] rowdata, int[] rowColMap) {
        return this.findFirstRowInternal(session, store, rowdata, rowColMap, false, FileQueueFilesManager.SeekType.LESS_EQUALS);
    }

    public RowIterator findFirstRowInternal(Session session, PersistentStore store, Object[] rowdata, int[] rowColMap, boolean reversed, FileQueueFilesManager.SeekType seekType) {
        FileQueueFilesManager.FileQueueDataReader reader = this.manager.createDataReader();
        try {
            reader.seekToFirst(row -> {
                int columnIndex = this.keyHolder.getColumnIndexes()[0];
                return this.keyHolder.getKeyTypes()[columnIndex].compare(session, rowdata[rowColMap != null ? rowColMap[columnIndex] : columnIndex], row[columnIndex]);
            }, () -> this.keyHolder.getColumnIndexes(), seekType);
            return new RowIteratorJFQ(this, reader, reversed);
        }
        catch (Exception exception) {
            reader.close();
            return this.emptyIterator();
        }
    }

    @Override
    public RowIterator findFirstRowNotNull(Session session, PersistentStore store) {
        return this.firstRow(session, store);
    }

    @Override
    public RowIterator firstRow(PersistentStore store) {
        return this.firstRow(null, store);
    }

    @Override
    public RowIterator firstRow(Session session, PersistentStore store) {
        FileQueueFilesManager.FileQueueDataReader reader = this.manager.createDataReader();
        try {
            reader.seekToFirst();
            return new RowIteratorJFQ(this, reader, false);
        }
        catch (Exception exception) {
            reader.close();
            return this.emptyIterator();
        }
    }

    @Override
    public RowIterator lastRow(Session session, PersistentStore store) {
        FileQueueFilesManager.FileQueueDataReader reader = this.manager.createDataReader();
        try {
            reader.seekToLast();
            return new RowIteratorJFQ(this, reader, true);
        }
        catch (Exception exception) {
            reader.close();
            return this.emptyIterator();
        }
    }

    public int getNodeCount(Session session, PersistentStore store) {
        return (int)this.manager.getRowsCount();
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(int position) {
        this.position = position;
    }

    @Override
    public long getPersistenceId() {
        return this.persistenceId;
    }

    @Override
    public int getVisibleColumns() {
        return this.columns.length;
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public boolean isConstraint() {
        return false;
    }

    @Override
    public int[] getColumns() {
        return this.columns;
    }

    @Override
    public Type[] getColumnTypes() {
        return this.colTypes;
    }

    @Override
    public boolean[] getColumnDesc() {
        return this.descending;
    }

    @Override
    public int[] getDefaultColumnMap() {
        return this.defaultColMap;
    }

    @Override
    public int getIndexOrderValue() {
        if (this.pk) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean isForward() {
        return this.forward;
    }

    @Override
    public void setTable(TableBase table) {
        this.table = table;
    }

    @Override
    public void setClustered(boolean clustered) {
    }

    @Override
    public boolean isClustered() {
        return false;
    }

    @Override
    public int compareRowNonUnique(Session session, Object[] a, Object[] b, int[] rowColMap) {
        int fieldcount = rowColMap.length;
        for (int j = 0; j < fieldcount; ++j) {
            int i = this.colTypes[j].compare(session, a[this.columns[j]], b[rowColMap[j]]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    @Override
    public int compareRowNonUnique(Session session, Object[] a, Object[] b, int[] rowColMap, int fieldCount) {
        for (int j = 0; j < fieldCount; ++j) {
            int i = this.colTypes[j].compare(session, a[this.columns[j]], b[rowColMap[j]]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    @Override
    public int compareRowNonUnique(Session session, Object[] a, Object[] b, int fieldCount) {
        for (int j = 0; j < fieldCount; ++j) {
            int i = this.colTypes[j].compare(session, a[this.columns[j]], b[this.columns[j]]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    @Override
    public int compareRow(Session session, Object[] a, Object[] b) {
        for (int j = 0; j < this.columns.length; ++j) {
            boolean nulls;
            int i = this.colTypes[j].compare(session, a[this.columns[j]], b[this.columns[j]]);
            if (i == 0) continue;
            if (this.isSimpleOrder) {
                return i;
            }
            boolean bl = nulls = a[this.columns[j]] == null || b[this.columns[j]] == null;
            if (this.descending[j] && !nulls) {
                i = -i;
            }
            if (this.nullsLast[j] && nulls) {
                i = -i;
            }
            return i;
        }
        return 0;
    }

    @Override
    public int getObjectType() {
        return 21;
    }

    @Override
    public NameManager.ObjectName getObjectName() {
        return this.name;
    }

    @Override
    public NameManager.ObjectName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public NameManager.ObjectName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getSQLInSchema(String schemaName) {
        return this.getSQL(this.getObjectName().statementName, schemaName);
    }

    @Override
    public String getSQL() {
        return this.getSQL(this.getObjectName().statementName);
    }

    @Override
    public String getSQL(String name) {
        return this.getSQL(name, ((Table)this.table).getObjectName().schema.getStatementName());
    }

    public String getSQL(String name, String schemaName) {
        StringBuilder builder = new StringBuilder(64);
        builder.append("CREATE").append(' ');
        if (this.isUnique()) {
            builder.append("UNIQUE").append(' ');
        }
        builder.append("INDEX").append(' ');
        builder.append(name);
        builder.append(' ').append("ON").append(' ');
        builder.append(((Table)this.table).getObjectName().getSchemaQualifiedStatementName(schemaName));
        int[] col = this.getColumns();
        int len = this.getVisibleColumns();
        builder.append(((Table)this.table).getColumnListSQL(col, len));
        return builder.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    @Override
    public boolean isBuilt() {
        return true;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    static class EmptyRowIteratorJFQ
    implements RowIterator {
        @Override
        public Row getNextRow() {
            return null;
        }

        @Override
        public Object[] getNext() {
            return null;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public void remove() {
            throw new DataspaceException("Remove is not allowed on JFQ.");
        }

        @Override
        public boolean setRowColumns(boolean[] columns) {
            return false;
        }

        @Override
        public void release() {
        }

        @Override
        public long getRowId() {
            return 0L;
        }
    }

    public static class RowIteratorJFQ
    implements RowIterator {
        private final IndexJFQ index;
        private FileQueueFilesManager.FileQueueDataReader reader;
        private final boolean reversed;
        private Row nextrow = null;
        private boolean skip = false;

        public RowIteratorJFQ(IndexJFQ index, FileQueueFilesManager.FileQueueDataReader reader, boolean reversed) {
            this.index = index;
            this.reader = reader;
            this.reversed = reversed;
            this.getNextRow();
        }

        @Override
        public Row getNextRow() {
            try {
                Row lastrow = this.nextrow;
                Object[] next = this.reversed ? (this.skip ? this.reader.skipPrevious() : this.reader.readPrevious()) : (this.skip ? this.reader.skipNext() : this.reader.readNext());
                this.nextrow = next != null ? new Row(this.index.table, next) : null;
                return lastrow;
            }
            catch (IOException exception) {
                return null;
            }
        }

        @Override
        public Object[] getNext() {
            Row row = this.getNextRow();
            return row == null ? null : row.getData();
        }

        @Override
        public boolean hasNext() {
            return this.nextrow != null;
        }

        @Override
        public void remove() {
            throw new DataspaceException("Remove is not allowed on JFQ.");
        }

        @Override
        public boolean setRowColumns(boolean[] columns) {
            return false;
        }

        @Override
        public void release() {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }

        @Override
        public long getRowId() {
            return this.nextrow.getId();
        }

        public boolean isSkip() {
            return this.skip;
        }

        public void setSkip(boolean skip) {
            this.skip = skip;
        }
    }
}

