/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.jfq;

import com.streamscape.Trace;
import com.streamscape.ds.persist.jfq.FileQueueBinaryReader;
import com.streamscape.ds.persist.jfq.FileQueueBinaryUtils;
import com.streamscape.ds.persist.jfq.FileQueueFile;
import com.streamscape.ds.persist.jfq.FileQueueMinMaxKeysHolder;
import com.streamscape.ds.persist.jfq.FileQueueReaderAccessSimple;
import com.streamscape.ds.persist.jfq.FileQueueTransactionFilePersistent;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class FileQueueTransactionFilePersistentRAF
implements FileQueueTransactionFilePersistent {
    private final FileQueueFile originalFile;
    private Path transactionFilepath;
    private final FileQueueMinMaxKeysHolder minMaxKeysHolder;
    private RandomAccessFile file;
    private long transactionDataLength;

    public FileQueueTransactionFilePersistentRAF(FileQueueFile originalFile) {
        this.originalFile = originalFile;
        this.transactionFilepath = FileQueueTransactionFilePersistent.buildTransactionFilepath(originalFile.getFilepath());
        this.minMaxKeysHolder = new FileQueueMinMaxKeysHolder(originalFile.getQueueFilesManager().getTypesKeyHolder());
    }

    @Override
    public Path getFilePath() {
        return this.transactionFilepath;
    }

    @Override
    public void init() throws IOException {
        boolean newFile;
        if (this.file != null) {
            return;
        }
        boolean bl = newFile = !Files.exists(this.transactionFilepath, new LinkOption[0]);
        if (newFile) {
            Files.createFile(this.transactionFilepath, new FileAttribute[0]);
        }
        this.file = new RandomAccessFile(this.transactionFilepath.toFile(), "rw");
        try (FileQueueBinaryReader reader = new FileQueueBinaryReader(new FileQueueReaderAccessSimple(this.transactionFilepath), this.originalFile.getQueueFilesManager().getTypesKeyHolder());){
            this.minMaxKeysHolder.setMinKeys(reader.getMinKeys());
            this.minMaxKeysHolder.setMaxKeys(reader.getMaxKeys());
            this.minMaxKeysHolder.setRowsCount(reader.getRowsCount());
        }
        this.transactionDataLength = this.file.length();
    }

    @Override
    public void close() {
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException exception) {
                Trace.logException(this, exception, true);
            }
            this.file = null;
        }
    }

    @Override
    public long lengthOfData() throws IOException {
        return this.transactionDataLength;
    }

    @Override
    public void persistTransaction(FileQueueMinMaxKeysHolder minMaxKeysHolder, byte[] buffer, int offset, int size) throws IOException {
        int count = FileQueueBinaryUtils.initRowCountersInBuffer(buffer, offset, size, minMaxKeysHolder.getRowsCount() + 1);
        this.file.seek(0L);
        this.file.write(buffer, offset, size);
        this.file.setLength(size);
        this.transactionDataLength = size;
        this.minMaxKeysHolder.incrementRowsCount(count);
        this.minMaxKeysHolder.reassignKeysFrom(minMaxKeysHolder);
    }

    @Override
    public void clear() throws IOException {
        this.file.setLength(0L);
        this.transactionDataLength = 0L;
        this.minMaxKeysHolder.reset();
    }

    @Override
    public void reassignTo(FileQueueFile toFile) throws IOException {
        this.close();
        Path newFilepath = FileQueueTransactionFilePersistent.buildTransactionFilepath(toFile.getFilepath());
        if (!this.transactionFilepath.toFile().renameTo(newFilepath.toFile())) {
            throw new IOException("Failed to rename file '" + String.valueOf(this.transactionFilepath) + "' to '" + String.valueOf(newFilepath) + "'.");
        }
        this.transactionFilepath = newFilepath;
        this.file = new RandomAccessFile(this.transactionFilepath.toFile(), "rw");
    }

    @Override
    public void mergeTo(FileQueueFile toFile) throws IOException {
        if (this.transactionDataLength > 0L) {
            this.file.seek(0L);
            byte[] buffer = new byte[(int)this.transactionDataLength];
            this.file.read(buffer, 0, (int)this.transactionDataLength);
            toFile.append(this.minMaxKeysHolder, buffer, 0, (int)this.transactionDataLength);
        }
    }
}

