/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.jfq;

import com.streamscape.Trace;
import com.streamscape.ds.io.rowio.RowOutputBinary;
import com.streamscape.ds.persist.jfq.FileQueueBinaryReader;
import com.streamscape.ds.persist.jfq.FileQueueBinaryUtils;
import com.streamscape.ds.persist.jfq.FileQueueFile;
import com.streamscape.ds.persist.jfq.FileQueueMinMaxKeysHolder;
import com.streamscape.ds.persist.jfq.FileQueueReaderAccess;
import com.streamscape.ds.persist.jfq.FileQueueTransactionFilePersistent;
import com.streamscape.lib.utils.FileIOUtils;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class FileQueueTransactionFilePersistentNio
implements FileQueueTransactionFilePersistent {
    private Path transactionFilepath;
    private FileQueueFile originalFile;
    private int transactionDataLength;
    private final FileQueueMinMaxKeysHolder minMaxKeysHolder;
    private RandomAccessFile file;
    private FileChannel channel;
    private FileDescriptor fileDescriptor;
    private MappedByteBuffer[] buffers = new MappedByteBuffer[0];
    private MappedByteBuffer buffer;
    private int bufferLength;
    private int bufferPosition;
    private long currentPosition;
    private boolean buffersModified = false;
    private long fileLength;
    private static final int BUFFER_SIZE = 4096;
    private static final int HEADER_SIZE = 4;

    public FileQueueTransactionFilePersistentNio(FileQueueFile originalFile) {
        this.originalFile = originalFile;
        this.transactionFilepath = FileQueueTransactionFilePersistent.buildTransactionFilepath(originalFile.getFilepath());
        this.minMaxKeysHolder = new FileQueueMinMaxKeysHolder(originalFile.getQueueFilesManager().getTypesKeyHolder());
    }

    @Override
    public Path getFilePath() {
        return this.transactionFilepath;
    }

    @Override
    public void init() throws IOException {
        this.initWithoutRead();
        this.readTransactionHeader();
        try (FileQueueBinaryReader reader = new FileQueueBinaryReader(new FileQueueReaderAccessTransactionNio(), this.originalFile.getQueueFilesManager().getTypesKeyHolder());){
            this.minMaxKeysHolder.setMinKeys(reader.getMinKeys());
            this.minMaxKeysHolder.setMaxKeys(reader.getMaxKeys());
            this.minMaxKeysHolder.setRowsCount(reader.getRowsCount());
        }
    }

    private void initWithoutRead() throws IOException {
        boolean newFile;
        boolean bl = newFile = !Files.exists(this.transactionFilepath, new LinkOption[0]);
        if (newFile) {
            Files.createFile(this.transactionFilepath, new FileAttribute[0]);
        }
        this.file = new RandomAccessFile(this.transactionFilepath.toFile(), "rw");
        this.channel = this.file.getChannel();
        this.fileDescriptor = this.file.getFD();
        this.enlargeFile(Math.max(this.file.length(), 4096L));
        this.buffer = this.buffers[0];
        this.bufferLength = this.buffer.limit();
        this.bufferPosition = 0;
        this.currentPosition = 0L;
        if (newFile) {
            this.writeTransactionHeader(0);
            this.sync();
        }
    }

    @Override
    public void close() {
        try {
            this.sync();
            this.channel.close();
            this.channel = null;
            for (int i = 0; i < this.buffers.length; ++i) {
                this.unmap(this.buffers[i]);
                this.buffers[i] = null;
            }
            this.buffers = new MappedByteBuffer[0];
            this.buffer = null;
            this.bufferLength = 0;
            this.bufferPosition = 0;
            this.currentPosition = 0L;
            this.buffersModified = false;
            this.fileLength = 0L;
            this.file.close();
            this.file = null;
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    private void unmap(MappedByteBuffer buffer) throws IOException {
        if (buffer == null) {
            return;
        }
        try {
            FileIOUtils.unmap(buffer);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    private void enlargeFile(long newBufferLength) throws IOException {
        FileChannel.MapMode mapMode = FileChannel.MapMode.READ_WRITE;
        if (this.file.length() < this.fileLength + newBufferLength) {
            this.file.seek(this.fileLength + newBufferLength - 1L);
            this.file.writeByte(0);
        }
        MappedByteBuffer[] newBuffers = new MappedByteBuffer[this.buffers.length + 1];
        MappedByteBuffer newBuffer = this.channel.map(mapMode, this.fileLength, newBufferLength);
        System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
        newBuffers[this.buffers.length] = newBuffer;
        this.buffers = newBuffers;
        this.fileLength += newBufferLength;
    }

    private void sync() {
    }

    private void positionBufferSeek(long offset) throws IOException {
        if (offset < (long)this.bufferPosition || offset >= (long)(this.bufferPosition + this.bufferLength)) {
            this.setCurrentBuffer(offset);
        }
        this.buffer.position((int)(offset - (long)this.bufferPosition));
        this.currentPosition = offset;
    }

    private void positionBufferMove(int relOffset) throws IOException {
        long offset = this.currentPosition + (long)relOffset;
        if (offset >= (long)(this.bufferPosition + this.bufferLength)) {
            this.setCurrentBuffer(offset);
        }
        this.buffer.position((int)(offset - (long)this.bufferPosition));
        this.currentPosition = offset;
    }

    private void setCurrentBuffer(long offset) throws IOException {
        int totalOffset = 0;
        for (int i = 0; i < this.buffers.length; ++i) {
            if ((long)totalOffset <= offset && offset < (long)(totalOffset + this.buffers[i].limit())) {
                this.buffer = this.buffers[i];
                this.bufferPosition = totalOffset;
                this.bufferLength = this.buffers[i].limit();
                return;
            }
            totalOffset += this.buffers[i].limit();
        }
        this.enlargeFile(Math.max(offset - (long)totalOffset, 4096L));
        this.setCurrentBuffer(offset);
    }

    private void writeInt(int i) throws IOException {
        this.buffersModified = true;
        this.buffer.putInt(i);
        this.positionBufferMove(4);
    }

    private int readInt() throws IOException {
        int value = this.buffer.getInt();
        this.positionBufferMove(4);
        return value;
    }

    private int read(byte[] b, int offset, int length) throws IOException {
        int totalRead = 0;
        do {
            long transferLength;
            if ((transferLength = (long)(this.bufferPosition + this.bufferLength) - this.currentPosition) > (long)length) {
                transferLength = length;
            }
            this.buffer.get(b, offset, (int)transferLength);
            totalRead = (int)((long)totalRead + transferLength);
            if (this.currentPosition + transferLength >= this.fileLength) break;
            this.positionBufferMove((int)transferLength);
            length = (int)((long)length - transferLength);
            offset = (int)((long)offset + transferLength);
        } while (length != 0);
        return totalRead;
    }

    private void writeTransactionHeader(int size) throws IOException {
        this.positionBufferSeek(0L);
        this.writeInt(size);
        this.transactionDataLength = size;
    }

    private void readTransactionHeader() throws IOException {
        this.positionBufferSeek(0L);
        this.transactionDataLength = this.readInt();
    }

    private void write(byte[] b, int offset, int length) throws IOException {
        this.buffersModified = true;
        do {
            long transferLength;
            if ((transferLength = (long)(this.bufferPosition + this.bufferLength) - this.currentPosition) > (long)length) {
                transferLength = length;
            }
            this.buffer.put(b, offset, (int)transferLength);
            this.positionBufferMove((int)transferLength);
            length = (int)((long)length - transferLength);
            offset = (int)((long)offset + transferLength);
        } while (length != 0);
    }

    @Override
    public long lengthOfData() throws IOException {
        return this.transactionDataLength;
    }

    @Override
    public void persistTransaction(FileQueueMinMaxKeysHolder minMaxKeysHolder, byte[] buffer, int offset, int size) throws IOException {
        int count = FileQueueBinaryUtils.initRowCountersInBuffer(buffer, offset, size, minMaxKeysHolder.getRowsCount() + 1);
        if (offset >= 4 + this.originalFile.getHeaderLength()) {
            RowOutputBinary rowOutputBinary = new RowOutputBinary(buffer);
            rowOutputBinary.setPosition(offset - (4 + this.originalFile.getHeaderLength()));
            rowOutputBinary.writeInt(size + this.originalFile.getHeaderLength());
            this.positionBufferSeek(0L);
            this.write(buffer, offset - (4 + this.originalFile.getHeaderLength()), size + (4 + this.originalFile.getHeaderLength()));
            this.transactionDataLength = size + this.originalFile.getHeaderLength();
        } else {
            this.writeTransactionHeader(0);
            this.positionBufferSeek(4 + this.originalFile.getHeaderLength());
            this.write(buffer, offset, size);
            this.writeTransactionHeader(size + this.originalFile.getHeaderLength());
        }
        this.sync();
        this.minMaxKeysHolder.incrementRowsCount(count);
        this.minMaxKeysHolder.reassignKeysFrom(minMaxKeysHolder);
    }

    @Override
    public void clear() throws IOException {
        this.minMaxKeysHolder.reset();
        this.writeTransactionHeader(0);
        this.sync();
    }

    @Override
    public void reassignTo(FileQueueFile toFile) throws IOException {
        this.close();
        Path newFilepath = FileQueueTransactionFilePersistent.buildTransactionFilepath(toFile.getFilepath());
        if (!this.transactionFilepath.toFile().renameTo(newFilepath.toFile())) {
            throw new IOException("Failed to rename file '" + String.valueOf(this.transactionFilepath) + "' to '" + String.valueOf(newFilepath) + "'.");
        }
        this.transactionFilepath = newFilepath;
        this.initWithoutRead();
    }

    @Override
    public void mergeTo(FileQueueFile toFile) throws IOException {
        if (this.transactionDataLength > 0) {
            this.positionBufferSeek(4096 + this.originalFile.getHeaderLength());
            byte[] transactionBytes = new byte[this.transactionDataLength];
            int read = this.read(transactionBytes, 0, this.transactionDataLength);
            if (read != this.transactionDataLength) {
                throw new IOException("Failed to read all transaction bytes. Only read " + read + " instead of " + this.transactionDataLength);
            }
            toFile.append(this.minMaxKeysHolder, transactionBytes, 0, this.transactionDataLength);
        }
    }

    public class FileQueueReaderAccessTransactionNio
    implements FileQueueReaderAccess {
        private final Path filepath;

        public FileQueueReaderAccessTransactionNio() throws FileNotFoundException {
            this.filepath = FileQueueTransactionFilePersistentNio.this.originalFile.getFilepath();
        }

        @Override
        public int read(byte[] b, int offset, int length) throws IOException {
            return FileQueueTransactionFilePersistentNio.this.read(b, offset, length);
        }

        @Override
        public Path getFilepath() {
            return this.filepath;
        }

        @Override
        public void close() {
        }

        @Override
        public long length() throws IOException {
            return FileQueueTransactionFilePersistentNio.this.transactionDataLength;
        }

        @Override
        public void seek(long position) throws IOException {
            FileQueueTransactionFilePersistentNio.this.positionBufferSeek((long)FileQueueTransactionFilePersistentNio.this.transactionDataLength + position);
        }
    }
}

