/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.jfq;

import com.streamscape.ds.io.rowio.RowOutputBinary;
import com.streamscape.ds.types.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FileQueueRowTypesKeysHolder {
    private final Type[] rowTypes;
    private List<KeyHolderSingle> keys = new ArrayList<KeyHolderSingle>();
    private KeyHolderCompound compoundKey;
    private int maxKeyIndex = 0;

    public FileQueueRowTypesKeysHolder(Type[] rowTypes) {
        this.rowTypes = rowTypes;
    }

    public Type[] getRowTypes() {
        return this.rowTypes;
    }

    public void addKey(int[] columnIndexes, boolean unique) {
        if (columnIndexes == null || columnIndexes.length == 0) {
            return;
        }
        KeyHolderSingle index = new KeyHolderSingle(this.rowTypes, columnIndexes, unique);
        if (this.keys.contains(index)) {
            return;
        }
        index.init();
        this.keys.add(index);
        if (this.compoundKey == null) {
            this.compoundKey = new KeyHolderCompound(this.rowTypes);
            this.compoundKey.addIndex(index);
        }
        for (int i : index.getColumnIndexesSorted()) {
            this.maxKeyIndex = Math.max(i, this.maxKeyIndex);
        }
    }

    public int getMaxKeyIndex() {
        return this.maxKeyIndex;
    }

    public KeyHolder getCompoundKey() {
        return this.compoundKey;
    }

    public KeyHolder getKeyForColumns(int[] columnIndexes) {
        if (columnIndexes == null || columnIndexes.length == 0) {
            return this.getCompoundKey();
        }
        KeyHolderSingle result = null;
        for (KeyHolderSingle index : this.keys) {
            if (!index.containsColumns(columnIndexes)) continue;
            result = index;
        }
        return result;
    }

    public List<KeyHolderSingle> getKeys() {
        return this.keys;
    }

    public static class KeyHolderSingle
    extends AbstractKeyHolder {
        public KeyHolderSingle(Type[] rowTypes, int[] columnIndexes, boolean unique) {
            super(rowTypes);
            this.columnIndexes = Arrays.copyOf(columnIndexes, columnIndexes.length);
            this.unique = unique;
            this.init();
        }
    }

    public static class KeyHolderCompound
    extends AbstractKeyHolder {
        public KeyHolderCompound(Type[] rowTypes) {
            super(rowTypes);
        }

        public void addIndex(KeyHolder index) {
            this.unique &= index.isUnique();
            for (int i : index.getColumnIndexes()) {
                boolean found = false;
                for (int j : this.columnIndexes) {
                    if (i != j) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.columnIndexes = Arrays.copyOf(this.columnIndexes, this.columnIndexes.length + 1);
                this.columnIndexes[this.columnIndexes.length - 1] = i;
            }
            this.init();
        }
    }

    public static interface KeyHolder {
        public Type[] getRowTypes();

        public boolean isUnique();

        public int[] getColumnIndexes();

        public int[] getColumnIndexesSorted();

        public int getLengthInBytes();

        public boolean containsColumns(int[] var1);

        public Type[] getKeyTypes();
    }

    static abstract class AbstractKeyHolder
    implements KeyHolder {
        protected Type[] rowTypes;
        protected boolean unique;
        protected int[] columnIndexes = new int[0];
        protected int[] columnIndexesSorted = new int[0];
        protected int lengthInBytes;
        protected Type[] keyTypes;

        public AbstractKeyHolder(Type[] rowTypes) {
            this.rowTypes = rowTypes;
        }

        protected void init() {
            this.lengthInBytes = 0;
            int lastIndex = -1;
            for (int i : this.columnIndexes) {
                lastIndex = Math.max(i, lastIndex);
            }
            if (lastIndex >= 0) {
                for (int i = 0; i <= lastIndex; ++i) {
                    try {
                        this.lengthInBytes += new RowOutputBinary(null).getSize(1, this.rowTypes[i]);
                        continue;
                    }
                    catch (Exception exception) {
                        this.lengthInBytes = 0;
                    }
                }
            }
            this.keyTypes = new Type[lastIndex + 1];
            for (int i = 0; i <= lastIndex; ++i) {
                this.keyTypes[i] = this.rowTypes[i];
            }
            this.columnIndexesSorted = Arrays.copyOf(this.columnIndexes, this.columnIndexes.length);
            Arrays.sort(this.columnIndexesSorted);
        }

        @Override
        public Type[] getRowTypes() {
            return this.rowTypes;
        }

        @Override
        public boolean isUnique() {
            return this.unique;
        }

        @Override
        public int[] getColumnIndexes() {
            return this.columnIndexes;
        }

        @Override
        public int[] getColumnIndexesSorted() {
            return this.columnIndexesSorted;
        }

        @Override
        public int getLengthInBytes() {
            return this.lengthInBytes;
        }

        @Override
        public boolean containsColumns(int[] columnIndexes) {
            for (int i : columnIndexes) {
                boolean found = false;
                for (int j : this.columnIndexes) {
                    if (j != i) continue;
                    found = true;
                }
                if (found) continue;
                return false;
            }
            return true;
        }

        @Override
        public Type[] getKeyTypes() {
            return this.keyTypes;
        }

        public boolean equals(Object obj) {
            return obj instanceof KeyHolderSingle && Arrays.equals(((KeyHolderSingle)obj).columnIndexesSorted, this.columnIndexesSorted);
        }
    }
}

