/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.jfq;

import com.streamscape.Trace;
import com.streamscape.ds.persist.jfq.FileQueueReaderAccess;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Path;

public class FileQueueReaderAccessSimple
implements FileQueueReaderAccess {
    private RandomAccessFile readFile;
    private Path filepath;

    public FileQueueReaderAccessSimple(Path filepath) throws FileNotFoundException {
        this.readFile = new RandomAccessFile(filepath.toFile(), "r");
        this.filepath = filepath;
    }

    @Override
    public int read(byte[] buffer, int offset, int size) throws IOException {
        return this.readFile.read(buffer, offset, size);
    }

    @Override
    public Path getFilepath() {
        return this.filepath;
    }

    @Override
    public void close() {
        if (this.readFile != null) {
            try {
                this.readFile.close();
            }
            catch (IOException exception) {
                Trace.logError(this, "File {} close error.", this.filepath);
                Trace.logException(this, exception, false);
            }
            this.readFile = null;
        }
    }

    @Override
    public long length() throws IOException {
        return this.readFile.length();
    }

    @Override
    public void seek(long position) throws IOException {
        this.readFile.seek(position);
    }
}

