/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.jfq;

import com.streamscape.Trace;
import com.streamscape.ds.persist.jfq.FileQueueBinaryDataConverter;
import com.streamscape.ds.persist.jfq.FileQueueDataConverter;
import com.streamscape.ds.persist.jfq.FileQueueFile;
import com.streamscape.ds.persist.jfq.FileQueueFilenameProvider;
import com.streamscape.ds.persist.jfq.FileQueueFilesDirectoryProvider;
import com.streamscape.ds.persist.jfq.FileQueueKeyColumnIndexes;
import com.streamscape.ds.persist.jfq.FileQueueKeyComparator;
import com.streamscape.ds.persist.jfq.FileQueueMinMaxKeysHolder;
import com.streamscape.ds.persist.jfq.FileQueueReader;
import com.streamscape.ds.persist.jfq.FileQueueRowTypesKeysHolder;
import com.streamscape.ds.persist.jfq.FileQueueTransactionFilePersistent;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileQueueFilesManager {
    private final FileQueueFilesDirectoryProvider filesDirectoryProvider;
    private final FileQueueFilenameProvider queueFilenameProvider;
    private FileQueueDataWriter dataWriter;
    private FileQueueRowTypesKeysHolder typesKeyHolder;
    private volatile long maxFileSizeBytes = 314572800L;
    private long flushTimeout = 1000L;
    private long writeBufferSizeBytes = 16384L;
    private FileQueueTransactionFilePersistent.TransactionPersistentType transactionPersistentType = FileQueueTransactionFilePersistent.TransactionPersistentType.NONE;
    private final ReentrantLock lock = new ReentrantLock();
    private final List<FileQueueFile> files = new ArrayList<FileQueueFile>();

    public FileQueueFilesManager(FileQueueFilesDirectoryProvider filesDirectoryProvider, FileQueueFilenameProvider queueFilenameProvider, FileQueueRowTypesKeysHolder typesKeyHolder) {
        this.filesDirectoryProvider = filesDirectoryProvider;
        this.queueFilenameProvider = queueFilenameProvider;
        this.typesKeyHolder = typesKeyHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws IOException {
        this.lock.lock();
        try {
            List<Path> filepaths = this.listFilePaths();
            for (int i = 0; i < filepaths.size(); ++i) {
                Path filepath = filepaths.get(i);
                FileQueueFile file = new FileQueueFile(this, filepath);
                try {
                    file.checkFileVersion();
                }
                catch (IOException exception) {
                    Path newFilepath = filepath.getParent().resolve(filepath.getFileName().toString() + ".oldversion");
                    Trace.logError(this, "Validation failed for file {}. Cause: {}. Renaming it to {} and skipping.", file.getFilepath(), exception.getMessage(), newFilepath);
                    file.close();
                    Files.move(filepath, newFilepath, new CopyOption[0]);
                    continue;
                }
                file.init();
                if (i < filepaths.size() - 1 && file.lengthOfData() == 0L) {
                    file.close();
                    Files.deleteIfExists(file.getFilepath());
                    continue;
                }
                if (i == filepaths.size() - 1) {
                    file.setAppendable(true);
                }
                this.files.add(file);
            }
            if (this.files.size() == 0) {
                this.getOrCreateCurrentFile();
            }
            if (this.files.get(this.files.size() - 1).getTransactionFile().lengthOfData() > 0L) {
                Trace.logError(this, "There is unfinished transaction of size {} for file {}.", this.files.get(this.files.size() - 1).getTransactionFile().lengthOfData(), this.files.get(this.files.size() - 1).getFilepath());
            }
            this.dataWriter = new FileQueueDataWriterTransactionalImpl(new FileQueueBinaryDataConverter(this.typesKeyHolder));
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getFlushTimeout() {
        return this.flushTimeout;
    }

    public void setFlushTimeout(long flushTimeout) {
        this.flushTimeout = flushTimeout;
        this.onUpdateWriteBufferSizeAndFlushTimeout();
    }

    public long getWriteBufferSizeBytes() {
        return this.writeBufferSizeBytes;
    }

    public void setWriteBufferSizeBytes(long writeBufferSizeBytes) {
        this.writeBufferSizeBytes = writeBufferSizeBytes;
        this.onUpdateWriteBufferSizeAndFlushTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUpdateWriteBufferSizeAndFlushTimeout() {
        this.lock.lock();
        try {
            for (FileQueueFile file : this.files) {
                try {
                    file.updateAppendableWriter();
                }
                catch (Exception exception) {
                    Trace.logError(this, "Failed to update ru persistent type for file {}", file.getFilepath());
                    Trace.logException(this, exception, true);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public FileQueueTransactionFilePersistent.TransactionPersistentType getTransactionPersistentType() {
        return this.transactionPersistentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactionPersistentType(FileQueueTransactionFilePersistent.TransactionPersistentType transactionPersistentType) {
        this.transactionPersistentType = transactionPersistentType;
        this.lock.lock();
        try {
            for (FileQueueFile file : this.files) {
                try {
                    file.updateTransactionFileToNewType();
                }
                catch (IOException exception) {
                    Trace.logError(this, "Failed to update ru persistent type for file {}", file.getFilepath());
                    Trace.logException(this, exception, true);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<String> listFileNames() {
        return this.listFilePaths().stream().map(path -> path.getFileName().toString()).sorted().collect(Collectors.toList());
    }

    public List<Path> listFilePaths() {
        List<Path> list;
        block8: {
            Stream<Path> stream = Files.list(this.filesDirectoryProvider.getFilesDirectoryAbsolutePath());
            try {
                list = stream.filter(path -> path.getFileName().toString().matches(this.queueFilenameProvider.getFilenamePattern())).sorted().collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    Trace.logException(this, exception, true);
                    return new ArrayList<Path>();
                }
            }
            stream.close();
        }
        return list;
    }

    public FileQueueDataWriter createDataWriter() {
        return this.dataWriter;
    }

    public FileQueueDataReader createDataReader() {
        return new FileQueueDataReaderImpl();
    }

    public void close() {
        this.lock.lock();
        try {
            for (FileQueueFile file : this.files) {
                file.close();
            }
            this.files.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp(FileQueueKeyComparator comparator) {
        this.lock.lock();
        try {
            Iterator<FileQueueFile> iterator = this.files.iterator();
            while (iterator.hasNext()) {
                FileQueueFile file = iterator.next();
                if (file.isAppendable()) continue;
                try {
                    if (file.lengthOfData() == 0L) {
                        file.close();
                        Files.deleteIfExists(file.getFilepath());
                        iterator.remove();
                        continue;
                    }
                }
                catch (IOException exception) {
                    Trace.logException(this, exception, true);
                }
                if (file.isThisFor(comparator) <= 0) continue;
                file.close();
                try {
                    Files.deleteIfExists(file.getFilepath());
                    Files.deleteIfExists(file.getTransactionFile().getFilePath());
                    iterator.remove();
                }
                catch (IOException exception) {
                    Trace.logException(this, exception, true);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public FileQueueRowTypesKeysHolder getTypesKeyHolder() {
        return this.typesKeyHolder;
    }

    public long getMaxFileSizeBytes() {
        return this.maxFileSizeBytes;
    }

    public void setMaxFileSizeBytes(long maxFileSizeBytes) {
        this.maxFileSizeBytes = maxFileSizeBytes;
    }

    public long getRowsCount() {
        long rowsCount = 0L;
        for (FileQueueFile file : this.files) {
            rowsCount += (long)file.getRowsCount();
        }
        return rowsCount;
    }

    private Path getOrCreateCurrentFilePath() throws IOException {
        List<Path> paths = this.listFilePaths();
        if (paths.size() > 0) {
            return paths.get(paths.size() - 1);
        }
        return this.createNewFilePath();
    }

    private FileQueueFile getOrCreateCurrentFile() throws IOException {
        this.lock.lock();
        try {
            if (this.files.size() == 0) {
                FileQueueFile file = new FileQueueFile(this, this.getOrCreateCurrentFilePath());
                file.init();
                file.setAppendable(true);
                this.files.add(file);
            }
            FileQueueFile fileQueueFile = this.files.get(this.files.size() - 1);
            return fileQueueFile;
        }
        finally {
            this.lock.unlock();
        }
    }

    private FileQueueFile createNewCurrentFile(FileQueueFile previousFile) throws IOException {
        FileQueueFile file = new FileQueueFile(this, this.createNewFilePath());
        file.setAppendable(true);
        if (previousFile != null) {
            previousFile.getTransactionFile().reassignTo(file);
            file.setTransactionalFile(previousFile.getTransactionFile());
            previousFile.setTransactionalFile(null);
        }
        this.files.add(file);
        return file;
    }

    private Path createNewFilePath() throws IOException {
        Path path = null;
        while (path == null || path.toFile().exists()) {
            path = Paths.get(this.filesDirectoryProvider.getFilesDirectoryAbsolutePath().toString(), this.queueFilenameProvider.getNextFilename());
        }
        Files.createFile(path, new FileAttribute[0]);
        return path;
    }

    public void deleteAll() {
        this.lock.lock();
        try {
            this.close();
            try {
                for (Path path : this.listFilePaths()) {
                    Files.deleteIfExists(path);
                    Files.deleteIfExists(FileQueueTransactionFilePersistent.buildTransactionFilepath(path));
                }
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void truncate() throws IOException {
        this.lock.lock();
        try {
            this.deleteAll();
            this.createNewCurrentFile(null);
        }
        finally {
            this.lock.unlock();
        }
    }

    class FileQueueDataWriterTransactionalImpl
    implements FileQueueDataWriter {
        static final int TRANSACTION_BUFFER_SIZE = 10240;
        private boolean autoCommit = true;
        private boolean inTransaction = false;
        private boolean persisted = false;
        private byte[] transactionBuffer = new byte[10240];
        private int transactionBufferOffset = 0;
        private int transactionBufferSize = 0;
        private boolean bufferFromConverter = false;
        private FileQueueDataConverter dataConverter;
        private FileQueueMinMaxKeysHolder minMaxKeysHolder;

        public FileQueueDataWriterTransactionalImpl(FileQueueBinaryDataConverter dataConverter) {
            this.minMaxKeysHolder = new FileQueueMinMaxKeysHolder(FileQueueFilesManager.this.typesKeyHolder);
            this.dataConverter = dataConverter;
            this.dataConverter.setOffset(16);
            this.transactionBufferOffset = 16;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int append(Object[] data) throws IOException {
            FileQueueFilesManager.this.lock.lock();
            try {
                if (this.persisted) {
                    throw new IOException("Transaction already persisted.");
                }
                if (this.autoCommit && !this.inTransaction) {
                    FileQueueFile currentFile = FileQueueFilesManager.this.getOrCreateCurrentFile();
                    this.checkOldTransaction(currentFile);
                    this.dataConverter.write(data);
                    int n = this.doAppendToFile(new FileQueueMinMaxKeysHolder(FileQueueFilesManager.this.typesKeyHolder, data), this.dataConverter.getBuffer(), this.dataConverter.getOffset(), this.dataConverter.getSize());
                    return n;
                }
                if (!this.autoCommit) {
                    this.startTransaction();
                }
                int n = this.appendToTransaction(data);
                return n;
            }
            finally {
                FileQueueFilesManager.this.lock.unlock();
            }
        }

        @Override
        public void persistTransaction() throws IOException {
            FileQueueFilesManager.this.lock.lock();
            try {
                if (this.inTransaction) {
                    FileQueueFile currentFile = FileQueueFilesManager.this.getOrCreateCurrentFile();
                    FileQueueTransactionFilePersistent transactionFile = currentFile.getTransactionFile();
                    if (this.bufferFromConverter) {
                        transactionFile.persistTransaction(this.minMaxKeysHolder, this.dataConverter.getBuffer(), this.dataConverter.getOffset(), this.dataConverter.getSize());
                    } else if (this.transactionBufferSize > 0) {
                        transactionFile.persistTransaction(this.minMaxKeysHolder, this.transactionBuffer, this.transactionBufferOffset, this.transactionBufferSize);
                    }
                    this.persisted = true;
                }
            }
            finally {
                FileQueueFilesManager.this.lock.unlock();
            }
        }

        @Override
        public void startTransaction() throws IOException {
            FileQueueFilesManager.this.lock.lock();
            try {
                if (!this.inTransaction) {
                    FileQueueFile currentFile = FileQueueFilesManager.this.getOrCreateCurrentFile();
                    currentFile.getTransactionFile();
                    this.checkOldTransaction(currentFile);
                    this.resetTransactionBuffer();
                    this.persisted = false;
                    this.inTransaction = true;
                }
            }
            finally {
                FileQueueFilesManager.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commit() throws IOException {
            block13: {
                FileQueueFilesManager.this.lock.lock();
                try {
                    if (!this.inTransaction) break block13;
                    try {
                        FileQueueFile currentFile = FileQueueFilesManager.this.getOrCreateCurrentFile();
                        FileQueueTransactionFilePersistent transactionFile = currentFile.getTransactionFile();
                        if (this.bufferFromConverter) {
                            this.doAppendToFile(this.minMaxKeysHolder, this.dataConverter.getBuffer(), this.dataConverter.getOffset(), this.dataConverter.getSize());
                        } else if (this.transactionBufferSize > 0) {
                            this.doAppendToFile(this.minMaxKeysHolder, this.transactionBuffer, this.transactionBufferOffset, this.transactionBufferSize);
                        } else {
                            if (currentFile.length() + transactionFile.lengthOfData() > FileQueueFilesManager.this.maxFileSizeBytes) {
                                FileQueueFile previousFile = currentFile;
                                currentFile = FileQueueFilesManager.this.createNewCurrentFile(previousFile);
                                previousFile.closeAppendable();
                            }
                            transactionFile.mergeTo(currentFile);
                        }
                        transactionFile.clear();
                    }
                    catch (IOException exception) {
                        Trace.logError(this, "Failed to commit file {}.", FileQueueFilesManager.this.getOrCreateCurrentFile().getFilepath());
                        throw exception;
                    }
                    finally {
                        this.resetTransactionBuffer();
                        this.persisted = false;
                        this.inTransaction = false;
                    }
                }
                finally {
                    FileQueueFilesManager.this.lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rollback() throws IOException {
            block8: {
                FileQueueFilesManager.this.lock.lock();
                try {
                    if (!this.inTransaction) break block8;
                    try {
                        FileQueueFile currentFile = FileQueueFilesManager.this.getOrCreateCurrentFile();
                        FileQueueTransactionFilePersistent transactionFile = currentFile.getTransactionFile();
                        transactionFile.clear();
                    }
                    catch (IOException exception) {
                        Trace.logError(this, "Failed to rollback file {}.", FileQueueFilesManager.this.getOrCreateCurrentFile().getFilepath());
                        throw exception;
                    }
                    finally {
                        this.resetTransactionBuffer();
                        this.persisted = false;
                        this.inTransaction = false;
                    }
                }
                finally {
                    FileQueueFilesManager.this.lock.unlock();
                }
            }
        }

        @Override
        public void setAutoCommit(boolean autoCommit) {
            this.autoCommit = autoCommit;
        }

        @Override
        public boolean getAutoCommit() {
            return this.autoCommit;
        }

        @Override
        public boolean inTransaction() {
            return this.inTransaction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int doAppendToFile(FileQueueMinMaxKeysHolder minMaxKeysHolder, byte[] buffer, int offset, int size) throws IOException {
            FileQueueFilesManager.this.lock.lock();
            try {
                FileQueueFile currentFile = FileQueueFilesManager.this.getOrCreateCurrentFile();
                if (currentFile.length() + (long)size > FileQueueFilesManager.this.maxFileSizeBytes) {
                    FileQueueFile previousFile = currentFile;
                    currentFile = FileQueueFilesManager.this.createNewCurrentFile(previousFile);
                    previousFile.closeAppendable();
                }
                currentFile.append(minMaxKeysHolder, buffer, offset, size);
                int n = size;
                return n;
            }
            finally {
                FileQueueFilesManager.this.lock.unlock();
            }
        }

        private int appendToTransaction(Object[] data) throws IOException {
            if (!this.bufferFromConverter && this.transactionBufferSize == 0) {
                this.dataConverter.write(data);
                this.bufferFromConverter = true;
            } else {
                if (this.bufferFromConverter) {
                    this.writeFromDataConverterToTransactionBuffer();
                    return this.appendToTransaction(data);
                }
                this.dataConverter.write(data);
                this.writeFromDataConverterToTransactionBuffer();
            }
            this.minMaxKeysHolder.reassignKeysFrom(data);
            return this.dataConverter.getSize();
        }

        private void writeFromDataConverterToTransactionBuffer() {
            if (this.transactionBufferOffset + this.transactionBufferSize + this.dataConverter.getSize() > this.transactionBuffer.length) {
                this.transactionBuffer = Arrays.copyOf(this.transactionBuffer, (int)Math.max((double)(this.transactionBufferOffset + this.transactionBufferSize + this.dataConverter.getSize()), (double)this.transactionBuffer.length * 1.5));
            }
            System.arraycopy(this.dataConverter.getBuffer(), this.dataConverter.getOffset(), this.transactionBuffer, this.transactionBufferOffset + this.transactionBufferSize, this.dataConverter.getSize());
            this.transactionBufferSize += this.dataConverter.getSize();
            this.bufferFromConverter = false;
        }

        private void resetTransactionBuffer() {
            this.bufferFromConverter = false;
            this.transactionBufferSize = 0;
            this.minMaxKeysHolder.reset();
        }

        private void checkOldTransaction(FileQueueFile file) throws IOException {
            if (file.getTransactionFile().lengthOfData() > 0L) {
                throw new IOException("There is still unfinished transaction of size " + file.getTransactionFile().lengthOfData() + " on file '" + String.valueOf(file.getFilepath()) + "'. Finish it first.");
            }
        }
    }

    public static interface FileQueueDataWriter {
        public int append(Object[] var1) throws IOException;

        public void persistTransaction() throws IOException;

        public void setAutoCommit(boolean var1);

        public boolean getAutoCommit();

        public void startTransaction() throws IOException;

        public void commit() throws IOException;

        public void rollback() throws IOException;

        public boolean inTransaction();
    }

    class FileQueueDataReaderImpl
    implements FileQueueDataReader {
        private FileQueueFile file;
        private FileQueueReader reader;
        private long lastReadSizeInBytes;

        FileQueueDataReaderImpl() {
        }

        @Override
        public void reset() {
            if (this.reader != null) {
                this.file.releaseReader(this.reader);
                this.reader = null;
            }
            this.file = null;
        }

        @Override
        public void seekToFirstUnread() throws IOException {
            throw new IOException("seekToFirstUnread() not yet implemented.");
        }

        @Override
        public boolean seekToFirst() throws IOException {
            return this.seekToFirst(keys -> -1, () -> null, SeekType.LESS_EQUALS);
        }

        @Override
        public boolean seekToLast() throws IOException {
            return this.seekToFirst(keys -> 1, () -> null, SeekType.LESS_EQUALS);
        }

        @Override
        public boolean seekToFirst(FileQueueKeyComparator comparator, FileQueueKeyColumnIndexes indexes, SeekType seekType) throws IOException {
            return this.seekTo(comparator, indexes, seekType, true);
        }

        @Override
        public boolean seekToLast(FileQueueKeyComparator comparator, FileQueueKeyColumnIndexes indexes, SeekType seekType) throws IOException {
            return this.seekTo(comparator, indexes, seekType, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean seekTo(FileQueueKeyComparator comparator, FileQueueKeyColumnIndexes indexes, SeekType seekType, boolean first) throws IOException {
            FileQueueFilesManager.this.lock.lock();
            try {
                if (this.file != null && this.file.isClosed()) {
                    this.file = null;
                }
                if (this.reader != null && this.reader.isClosed()) {
                    this.reader = null;
                }
                if (this.file != null) {
                    if (this.file.isThisFor(comparator) == 0) {
                        if ((!first || seekType != SeekType.LESS_EQUALS_OR_NEXT) && (this.file.getMinMaxKeysHolder().getMaxKeys() != null && comparator.compareTo(this.file.getMinMaxKeysHolder().getMaxKeys()) == 0 || this.file.getMinMaxKeysHolder().getMinKeys() != null && comparator.compareTo(this.file.getMinMaxKeysHolder().getMinKeys()) == 0)) {
                            this.file.releaseReader(this.reader);
                            this.reader = null;
                            this.file = null;
                        }
                        if (this.file != null && this.reader == null) {
                            this.reader = this.file.createReader();
                        }
                    } else {
                        this.file.releaseReader(this.reader);
                        this.reader = null;
                        this.file = null;
                    }
                }
                if (this.file == null) {
                    block4 : switch (seekType.ordinal()) {
                        case 0: {
                            if (first) {
                                for (FileQueueFile f : FileQueueFilesManager.this.files) {
                                    if (f.isThisFor(comparator) != 0) continue;
                                    this.file = f;
                                    break block4;
                                }
                            } else {
                                for (int i = FileQueueFilesManager.this.files.size() - 1; i >= 0; --i) {
                                    if (FileQueueFilesManager.this.files.get(i).isThisFor(comparator) != 0) continue;
                                    this.file = FileQueueFilesManager.this.files.get(i);
                                    break block4;
                                }
                            }
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            if (first) {
                                for (FileQueueFile f : FileQueueFilesManager.this.files) {
                                    if (f.isThisFor(comparator) > 0 || seekType == SeekType.LESS && f.getMinMaxKeysHolder().getMaxKeys() != null && comparator.compareTo(f.getMinMaxKeysHolder().getMaxKeys()) == 0) continue;
                                    this.file = f;
                                    break;
                                }
                                if (this.file != null) break;
                                this.file = FileQueueFilesManager.this.files.get(FileQueueFilesManager.this.files.size() - 1);
                                break;
                            }
                            if (this.file != null) break;
                            this.file = FileQueueFilesManager.this.files.get(FileQueueFilesManager.this.files.size() - 1);
                            break;
                        }
                        case 1: 
                        case 2: {
                            if (first) {
                                if (FileQueueFilesManager.this.files.get(0).isThisFor(comparator) < 0) break;
                                this.file = FileQueueFilesManager.this.files.get(0);
                                if (seekType != SeekType.GREATER || this.file.getMinMaxKeysHolder().getMinKeys() == null || comparator.compareTo(this.file.getMinMaxKeysHolder().getMinKeys()) != 0) break;
                                this.file = null;
                                break;
                            }
                            for (int i = FileQueueFilesManager.this.files.size() - 1; i >= 0; --i) {
                                if (FileQueueFilesManager.this.files.get(i).isThisFor(comparator) < 0 || seekType == SeekType.GREATER && FileQueueFilesManager.this.files.get(i).getMinMaxKeysHolder().getMinKeys() != null && comparator.compareTo(FileQueueFilesManager.this.files.get(i).getMinMaxKeysHolder().getMinKeys()) == 0) continue;
                                this.file = FileQueueFilesManager.this.files.get(i);
                                break block4;
                            }
                            break;
                        }
                    }
                }
                if (this.file != null && this.reader == null) {
                    this.reader = this.file.createReader();
                }
            }
            finally {
                FileQueueFilesManager.this.lock.unlock();
            }
            if (this.file != null) {
                this.file.readLock();
                try {
                    if (this.reader != null) {
                        if (this.reader.seekTo(comparator, indexes, seekType, first) == -1L) {
                            this.file.releaseReader(this.reader);
                            this.reader = null;
                            this.file.readUnlock();
                            this.file = null;
                            boolean bl = false;
                            return bl;
                        }
                    } else {
                        this.file.readUnlock();
                        this.file = null;
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (this.file != null) {
                        this.file.readUnlock();
                    }
                }
            }
            return false;
        }

        @Override
        public Object[] readNext() throws IOException {
            return this.readSkipNext(false);
        }

        @Override
        public Object[] skipNext() throws IOException {
            return this.readSkipNext(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object[] readSkipNext(boolean skip) throws IOException {
            this.lastReadSizeInBytes = 0L;
            if (this.file == null) {
                return null;
            }
            if (this.reader == null) {
                return null;
            }
            ReadIOException readSkipNext = () -> {
                try {
                    if (skip) {
                        this.reader.skipNext();
                        Object[] objectArray = new Object[]{};
                        return objectArray;
                    }
                    Object[] objectArray = this.reader.nextRow();
                    return objectArray;
                }
                finally {
                    this.lastReadSizeInBytes = this.reader.getLastReadSizeInBytes();
                }
            };
            this.file.readLock();
            try {
                if (this.reader.hasNext()) {
                    Object[] objectArray = readSkipNext.read();
                    return objectArray;
                }
                if (this.file.isAppendable()) {
                    Object[] objectArray = null;
                    return objectArray;
                }
            }
            finally {
                this.file.readUnlock();
            }
            FileQueueFile newFile = null;
            FileQueueFilesManager.this.lock.lock();
            try {
                if (this.file.isClosed() || this.file.isAppendable()) {
                    Object[] objectArray = null;
                    return objectArray;
                }
                for (int i = 0; i < FileQueueFilesManager.this.files.size(); ++i) {
                    if (this.file != FileQueueFilesManager.this.files.get(i)) continue;
                    if (i < FileQueueFilesManager.this.files.size() - 1) {
                        newFile = FileQueueFilesManager.this.files.get(i + 1);
                    }
                    break;
                }
            }
            finally {
                FileQueueFilesManager.this.lock.unlock();
            }
            if (newFile != null) {
                newFile.readLock();
                try {
                    FileQueueReader newReader = newFile.createReader();
                    if (newReader.seekTo(keys -> -1, () -> null, SeekType.LESS_EQUALS, true) >= 0L) {
                        this.file.releaseReader(this.reader);
                        this.reader = null;
                        this.file = null;
                        this.file = newFile;
                        this.reader = newReader;
                        if (this.reader.hasNext()) {
                            Object[] objectArray = readSkipNext.read();
                            return objectArray;
                        }
                    }
                }
                finally {
                    newFile.readUnlock();
                }
            }
            return null;
        }

        @Override
        public Object[][] readNextBatch(int size) throws IOException {
            this.lastReadSizeInBytes = 0L;
            long currentReadSize = 0L;
            ArrayList<Object[]> array = new ArrayList<Object[]>();
            while (size-- > 0) {
                try {
                    Object[] next = this.readNext();
                    if (next == null) break;
                    currentReadSize += this.lastReadSizeInBytes;
                    array.add(next);
                }
                catch (Exception exception) {
                    if (array.size() == 0) {
                        throw exception;
                    }
                    Trace.logException(this, exception, true);
                }
            }
            this.lastReadSizeInBytes = currentReadSize;
            return (Object[][])array.toArray((T[])new Object[array.size()][]);
        }

        @Override
        public Object[] readNext(FileQueueKeyComparator comparator) throws IOException {
            throw new IOException("readNext(FileQueueKeyComparator comparator) not yet implemented.");
        }

        @Override
        public Object[][] readNextBatch(FileQueueKeyComparator comparator, int size) throws IOException {
            throw new IOException("readNext(FileQueueKeyComparator comparator, int size) not yet implemented.");
        }

        @Override
        public Object[] readPrevious() throws IOException {
            return this.readSkipPrevious(false);
        }

        @Override
        public Object[] skipPrevious() throws IOException {
            return this.readSkipPrevious(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object[] readSkipPrevious(boolean skip) throws IOException {
            this.lastReadSizeInBytes = 0L;
            if (this.file == null) {
                return null;
            }
            if (this.reader == null) {
                return null;
            }
            ReadIOException readSkipPrevious = () -> {
                try {
                    if (skip) {
                        this.reader.skipPrevious();
                        Object[] objectArray = new Object[]{};
                        return objectArray;
                    }
                    Object[] objectArray = this.reader.previousRow();
                    return objectArray;
                }
                finally {
                    this.lastReadSizeInBytes = this.reader.getLastReadSizeInBytes();
                }
            };
            this.file.readLock();
            try {
                if (this.reader.hasPrevious()) {
                    Object[] objectArray = readSkipPrevious.read();
                    return objectArray;
                }
            }
            finally {
                this.file.readUnlock();
            }
            FileQueueFile newFile = null;
            FileQueueFilesManager.this.lock.lock();
            try {
                if (this.file.isClosed()) {
                    Object[] objectArray = null;
                    return objectArray;
                }
                for (int i = 0; i < FileQueueFilesManager.this.files.size(); ++i) {
                    if (this.file != FileQueueFilesManager.this.files.get(i)) continue;
                    if (i > 0) {
                        newFile = FileQueueFilesManager.this.files.get(i - 1);
                    }
                    break;
                }
            }
            finally {
                FileQueueFilesManager.this.lock.unlock();
            }
            if (newFile != null) {
                newFile.readLock();
                try {
                    FileQueueReader newReader = newFile.createReader();
                    if (newReader.seekTo(keys -> 1, () -> null, SeekType.LESS_EQUALS, true) >= 0L) {
                        this.file.releaseReader(this.reader);
                        this.reader = null;
                        this.file = null;
                        this.file = newFile;
                        this.reader = newReader;
                        if (this.reader.hasPrevious()) {
                            Object[] objectArray = readSkipPrevious.read();
                            return objectArray;
                        }
                    }
                }
                finally {
                    newFile.readUnlock();
                }
            }
            return null;
        }

        @Override
        public Object[][] readPreviousBatch(int size) throws IOException {
            this.lastReadSizeInBytes = 0L;
            long currentReadSize = 0L;
            ArrayList<Object[]> array = new ArrayList<Object[]>();
            while (size-- > 0) {
                Object[] next = this.readPrevious();
                currentReadSize += this.lastReadSizeInBytes;
                if (next == null) break;
                array.add(next);
            }
            this.lastReadSizeInBytes = currentReadSize;
            return (Object[][])array.toArray((T[])new Object[array.size()][]);
        }

        @Override
        public Object[] readPrevious(FileQueueKeyComparator comparator) throws IOException {
            throw new IOException("readPrevious(FileQueueKeyComparator comparator) not yet implemented.");
        }

        @Override
        public Object[][] readPreviousBatch(FileQueueKeyComparator comparator, int size) throws IOException {
            throw new IOException("readPreviousBatch(FileQueueKeyComparator comparator, int size) not yet implemented.");
        }

        @Override
        public long getLastReadSizeInBytes() {
            return this.lastReadSizeInBytes;
        }

        @Override
        public void close() {
            if (this.file != null && this.reader != null) {
                this.file.releaseReader(this.reader);
                this.reader = null;
                this.file = null;
            }
        }
    }

    private static interface ReadIOException {
        public Object[] read() throws IOException;
    }

    class FileQueueDataWriterMock
    implements FileQueueDataWriter {
        FileQueueDataWriterMock(FileQueueFilesManager this$0) {
        }

        @Override
        public int append(Object[] data) throws IOException {
            return 0;
        }

        @Override
        public void persistTransaction() throws IOException {
        }

        @Override
        public void setAutoCommit(boolean autoCommit) {
        }

        @Override
        public boolean getAutoCommit() {
            return false;
        }

        @Override
        public void startTransaction() throws IOException {
        }

        @Override
        public void commit() throws IOException {
        }

        @Override
        public void rollback() throws IOException {
        }

        @Override
        public boolean inTransaction() {
            return false;
        }
    }

    class FileQueueDataWriterTransactionalNoWriteToFile
    extends FileQueueDataWriterTransactionalImpl {
        public FileQueueDataWriterTransactionalNoWriteToFile(FileQueueFilesManager this$0, FileQueueBinaryDataConverter dataConverter) {
            super(dataConverter);
        }

        @Override
        protected int doAppendToFile(FileQueueMinMaxKeysHolder minMaxKeysHolder, byte[] buffer, int offset, int size) throws IOException {
            return size;
        }

        @Override
        public void persistTransaction() throws IOException {
        }
    }

    public static interface FileQueueDataReader
    extends AutoCloseable {
        public void reset();

        public void seekToFirstUnread() throws IOException;

        public boolean seekToFirst() throws IOException;

        public boolean seekToLast() throws IOException;

        public boolean seekToFirst(FileQueueKeyComparator var1, FileQueueKeyColumnIndexes var2, SeekType var3) throws IOException;

        public boolean seekToLast(FileQueueKeyComparator var1, FileQueueKeyColumnIndexes var2, SeekType var3) throws IOException;

        public Object[] readNext() throws IOException;

        public Object[][] readNextBatch(int var1) throws IOException;

        public Object[] skipNext() throws IOException;

        public Object[] skipPrevious() throws IOException;

        public Object[] readNext(FileQueueKeyComparator var1) throws IOException;

        public Object[][] readNextBatch(FileQueueKeyComparator var1, int var2) throws IOException;

        public Object[] readPrevious() throws IOException;

        public Object[][] readPreviousBatch(int var1) throws IOException;

        public Object[] readPrevious(FileQueueKeyComparator var1) throws IOException;

        public Object[][] readPreviousBatch(FileQueueKeyComparator var1, int var2) throws IOException;

        public long getLastReadSizeInBytes();

        @Override
        public void close();
    }

    public static enum SeekType {
        EQUALS,
        GREATER,
        GREATER_EQUALS,
        LESS,
        LESS_EQUALS,
        LESS_EQUALS_OR_NEXT;

    }
}

