/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.jfq;

import com.streamscape.ds.DataspaceException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class FileQueueFilesDirectoryProvider {
    private final String dataspaceStoreLocation;
    private final Path filesAbsolutePath;

    public FileQueueFilesDirectoryProvider(String dataspaceStoreLocation, String filesLocation) {
        this.dataspaceStoreLocation = dataspaceStoreLocation;
        this.filesAbsolutePath = Paths.get(dataspaceStoreLocation, filesLocation).normalize().toAbsolutePath();
    }

    public void init() throws IOException {
        if (!Files.exists(this.filesAbsolutePath, new LinkOption[0])) {
            Files.createDirectories(this.filesAbsolutePath, new FileAttribute[0]);
        }
        if (!Files.exists(this.filesAbsolutePath, new LinkOption[0])) {
            throw new DataspaceException("Failed to create directory '" + this.filesAbsolutePath.toString() + "'.");
        }
        if (!Files.isDirectory(this.filesAbsolutePath, new LinkOption[0])) {
            throw new DataspaceException("There is a file instead of directory at path '" + this.filesAbsolutePath.toString() + "'.");
        }
    }

    public Path getFilesDirectoryAbsolutePath() {
        return this.filesAbsolutePath;
    }
}

