/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.jfq;

import java.nio.file.FileSystems;
import java.util.regex.Pattern;

public interface FileQueueFilenameProvider {
    public static final Pattern WHITE_SPACE_PATTERN = Pattern.compile("\\s+");
    public static final Pattern SEPARATOR_PATTERN = Pattern.compile(Pattern.quote(FileSystems.getDefault().getSeparator()));

    public String buildBaseFilename();

    public String getFilenamePattern();

    public String getNextFilename();

    public static String escapeFilename(String name) {
        name = WHITE_SPACE_PATTERN.matcher(name).replaceAll("");
        name = SEPARATOR_PATTERN.matcher(name).replaceAll("_");
        return name;
    }
}

