/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.jfq;

import com.streamscape.Trace;
import com.streamscape.ds.persist.jfq.FileAppendableWriter;
import com.streamscape.ds.persist.jfq.FileAppendableWriterBufferedWithDelay;
import com.streamscape.ds.persist.jfq.FileAppendableWriterRAF;
import com.streamscape.ds.persist.jfq.FileQueueBinaryReader;
import com.streamscape.ds.persist.jfq.FileQueueBinaryUtils;
import com.streamscape.ds.persist.jfq.FileQueueFilesManager;
import com.streamscape.ds.persist.jfq.FileQueueKeyComparator;
import com.streamscape.ds.persist.jfq.FileQueueMinMaxKeysHolder;
import com.streamscape.ds.persist.jfq.FileQueueReader;
import com.streamscape.ds.persist.jfq.FileQueueReaderAccessSimple;
import com.streamscape.ds.persist.jfq.FileQueueTransactionFilePersistent;
import com.streamscape.ds.persist.jfq.FileQueueTransactionFilePersistentNio;
import com.streamscape.ds.persist.jfq.FileQueueTransactionFilePersistentRAF;
import com.streamscape.ds.persist.jfq.FileQueueTransactionFilePersistentStub;
import com.streamscape.sef.FabricException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FileQueueFile {
    private final FileQueueFilesManager queueFilesManager;
    private final Path filepath;
    private final FileQueueMinMaxKeysHolder minMaxKeysHolder;
    private List<FileQueueReader> readers = Collections.synchronizedList(new ArrayList());
    private FileAppendableWriter fileAppendableWriter;
    private FileQueueTransactionFilePersistent transactionalFile;
    private boolean isClosed = false;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();

    public FileQueueFile(FileQueueFilesManager queueFilesManager, Path filepath) throws IOException {
        this.queueFilesManager = queueFilesManager;
        this.filepath = filepath;
        this.transactionalFile = null;
        this.minMaxKeysHolder = new FileQueueMinMaxKeysHolder(queueFilesManager.getTypesKeyHolder());
    }

    public void init() throws IOException {
        try (FileQueueBinaryReader reader = new FileQueueBinaryReader(new FileQueueReaderAccessSimple(this.filepath), this.queueFilesManager.getTypesKeyHolder());){
            this.minMaxKeysHolder.setMinKeys(reader.getMinKeys());
            this.minMaxKeysHolder.setMaxKeys(reader.getMaxKeys());
            this.minMaxKeysHolder.setRowsCount(reader.getRowsCount());
        }
    }

    public FileQueueFilesManager getQueueFilesManager() {
        return this.queueFilesManager;
    }

    public Path getFilepath() {
        return this.filepath;
    }

    public FileQueueTransactionFilePersistent getTransactionFile() throws IOException {
        if (this.transactionalFile == null) {
            switch (this.getQueueFilesManager().getTransactionPersistentType()) {
                case NIO: {
                    this.transactionalFile = new FileQueueTransactionFilePersistentNio(this);
                    break;
                }
                case RAF: {
                    this.transactionalFile = new FileQueueTransactionFilePersistentRAF(this);
                    break;
                }
                case NONE: {
                    this.transactionalFile = new FileQueueTransactionFilePersistentStub(this);
                }
            }
            this.transactionalFile.init();
        }
        return this.transactionalFile;
    }

    public void setTransactionalFile(FileQueueTransactionFilePersistent transactionalFile) {
        this.transactionalFile = transactionalFile;
    }

    public void updateTransactionFileToNewType() throws IOException {
        this.writeLock();
        try {
            if (this.transactionalFile == null) {
                return;
            }
            this.transactionalFile.close();
            this.transactionalFile = null;
            this.getTransactionFile();
        }
        finally {
            this.writeUnlock();
        }
    }

    public int getHeaderLength() {
        return FileQueueBinaryUtils.HEADER_LENGTH;
    }

    public void setAppendable(boolean appendable) throws IOException {
        if (appendable && this.fileAppendableWriter == null) {
            this.fileAppendableWriter = this.getQueueFilesManager().getWriteBufferSizeBytes() == 0L || this.getQueueFilesManager().getFlushTimeout() == 0L ? new FileAppendableWriterRAF(this.filepath) : new FileAppendableWriterBufferedWithDelay(this.filepath, this.getQueueFilesManager().getWriteBufferSizeBytes(), this.getQueueFilesManager().getFlushTimeout());
            if (this.fileAppendableWriter.length() == 0L) {
                FileQueueBinaryUtils.initNewFile(this.fileAppendableWriter);
            }
        } else if (!appendable) {
            this.closeAppendable();
        }
    }

    public void updateAppendableWriter() throws FabricException, IOException {
        this.writeLock();
        try {
            if (!this.isAppendable()) {
                return;
            }
            if ((this.getQueueFilesManager().getWriteBufferSizeBytes() == 0L || this.getQueueFilesManager().getFlushTimeout() == 0L) && this.fileAppendableWriter instanceof FileAppendableWriterBufferedWithDelay || this.getQueueFilesManager().getWriteBufferSizeBytes() > 0L && this.getQueueFilesManager().getFlushTimeout() > 0L && !(this.fileAppendableWriter instanceof FileAppendableWriterBufferedWithDelay)) {
                if (this.fileAppendableWriter != null) {
                    try {
                        this.fileAppendableWriter.close();
                    }
                    catch (IOException exception) {
                        Trace.logError(this, "File {}.", this.filepath);
                        Trace.logException(this, exception, false);
                    }
                    this.fileAppendableWriter = null;
                }
                try {
                    this.setAppendable(true);
                }
                catch (IOException exception) {
                    Trace.logError(this, "File {}.", this.filepath);
                    Trace.logException(this, exception, true);
                }
            }
            if (this.fileAppendableWriter instanceof FileAppendableWriterBufferedWithDelay) {
                FileAppendableWriterBufferedWithDelay fileAppendableWriterBufferedWithDelay = (FileAppendableWriterBufferedWithDelay)this.fileAppendableWriter;
                fileAppendableWriterBufferedWithDelay.updateFlushTimeout(this.getQueueFilesManager().getFlushTimeout());
                fileAppendableWriterBufferedWithDelay.setBufferSize(this.getQueueFilesManager().getWriteBufferSizeBytes());
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public void checkFileVersion() throws IOException {
        try (RandomAccessFile file = new RandomAccessFile(this.filepath.toFile(), "r");){
            byte version = FileQueueBinaryUtils.readVersion(file);
            if (version != 2) {
                throw new IOException("Version mismatch: {" + version + ", but expected {2.");
            }
        }
    }

    public boolean isAppendable() {
        return this.fileAppendableWriter != null;
    }

    public void append(Object[] data, byte[] bytes, int offset, int size) throws IOException {
        if (!this.isAppendable()) {
            throw new IOException("This file is not appendable.");
        }
        int count = FileQueueBinaryUtils.initRowCountersInBuffer(bytes, offset, size, this.minMaxKeysHolder.getRowsCount() + 1);
        this.fileAppendableWriter.append(bytes, offset, size);
        this.minMaxKeysHolder.incrementRowsCount(count);
        this.minMaxKeysHolder.reassignKeysFrom(data);
    }

    public void append(FileQueueMinMaxKeysHolder minMaxKeysHolder, byte[] bytes, int offset, int size) throws IOException {
        if (!this.isAppendable()) {
            throw new IOException("This file is not appendable.");
        }
        int count = FileQueueBinaryUtils.initRowCountersInBuffer(bytes, offset, size, this.minMaxKeysHolder.getRowsCount() + 1);
        this.fileAppendableWriter.append(bytes, offset, size);
        this.minMaxKeysHolder.incrementRowsCount(count);
        this.minMaxKeysHolder.reassignKeysFrom(minMaxKeysHolder);
    }

    public void closeAppendable() {
        if (this.fileAppendableWriter != null) {
            try {
                this.fileAppendableWriter.close();
            }
            catch (IOException exception) {
                Trace.logError(this, "File {}.", this.filepath);
                Trace.logException(this, exception, false);
            }
            this.fileAppendableWriter = null;
        }
        if (this.transactionalFile != null) {
            this.transactionalFile.close();
            this.transactionalFile = null;
        }
    }

    public void close() {
        this.writeLock();
        try {
            this.closeAppendable();
            for (FileQueueReader reader : this.readers) {
                reader.close();
            }
            this.readers.clear();
            this.isClosed = true;
        }
        finally {
            this.writeUnlock();
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public int isThisFor(FileQueueKeyComparator comparator) {
        if (this.minMaxKeysHolder.getMinKeys() == null || comparator.compareTo(this.minMaxKeysHolder.getMinKeys()) < 0) {
            return -1;
        }
        if (comparator.compareTo(this.minMaxKeysHolder.getMaxKeys()) > 0) {
            return 1;
        }
        return 0;
    }

    public FileQueueMinMaxKeysHolder getMinMaxKeysHolder() {
        return this.minMaxKeysHolder;
    }

    public int getRowsCount() {
        return this.minMaxKeysHolder.getRowsCount();
    }

    public long length() throws IOException {
        if (this.fileAppendableWriter == null) {
            return this.filepath.toFile().length();
        }
        return this.fileAppendableWriter.length();
    }

    public long lengthOfData() throws IOException {
        long length = this.length() - (long)this.getHeaderLength();
        if (length < 0L) {
            length = 0L;
        }
        return length;
    }

    public FileQueueReader createReader() throws IOException {
        FileQueueReader reader = this.createReaderInternal();
        this.readers.add(reader);
        return reader;
    }

    public void releaseReader(FileQueueReader reader) {
        if (reader == null) {
            return;
        }
        reader.close();
        this.readers.remove(reader);
    }

    protected FileQueueReader createReaderInternal() throws IOException {
        return new FileQueueBinaryReader(new FileQueueReaderAccessSimple(this.filepath), this.queueFilesManager.getTypesKeyHolder());
    }

    public void readLock() {
        this.readLock.lock();
    }

    public void readUnlock() {
        this.readLock.unlock();
    }

    public void writeLock() {
        this.writeLock.lock();
    }

    public void writeUnlock() {
        this.writeLock.unlock();
    }
}

