/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.jfq;

import com.streamscape.ds.lib.HsqlByteArrayOutputStream;
import com.streamscape.ds.persist.jfq.FileAppendableWriter;
import com.streamscape.ds.persist.jfq.FileQueueMinMaxKeysHolder;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileQueueBinaryUtils {
    public static final byte VERSION = 2;
    public static final byte[] VERSION_SIGNATURE = new byte[]{17, 18, 19, 2};
    public static final byte[] INITIAL_HEADER = new byte[]{0, 0, 0, 0};
    public static final int HEADER_LENGTH = VERSION_SIGNATURE.length + 4;
    public static final byte[] DELIMITER = new byte[]{124, 126, 126, 126};
    public static final byte[] ESCAPE = new byte[]{123, 125, 125, 125};
    public static final int INT_LENGTH = 4;
    public static final int SIZE_LENGTH = 4;
    public static final int COUNT_LENGTH = 4;
    public static final int ROW_META_LENGTH = 12 + DELIMITER.length;

    public static void initNewFile(FileAppendableWriter file) throws IOException {
        file.append(VERSION_SIGNATURE, 0, VERSION_SIGNATURE.length);
        file.append(INITIAL_HEADER, 0, INITIAL_HEADER.length);
        file.flush();
    }

    public static byte readVersion(RandomAccessFile file) throws IOException {
        if (file.length() < (long)INITIAL_HEADER.length) {
            throw new IOException("Invalid file length. Should be at least " + INITIAL_HEADER.length + " bytes.");
        }
        file.seek(0L);
        byte[] signature = new byte[VERSION_SIGNATURE.length];
        file.read(signature, 0, signature.length);
        if (signature[0] != VERSION_SIGNATURE[0] || signature[1] != VERSION_SIGNATURE[1] || signature[2] != VERSION_SIGNATURE[2]) {
            throw new IOException("Invalid file signature.");
        }
        return signature[3];
    }

    public static boolean equals(byte[] delimiter, byte[] buffer, int start) {
        for (int i = 0; i < delimiter.length; ++i) {
            if (buffer[start + i] == delimiter[i]) continue;
            return false;
        }
        return true;
    }

    public static HsqlByteArrayOutputStream escapeBuffer(byte[] buffer1, int offset, int size, byte[] buffer2) {
        HsqlByteArrayOutputStream rowBuffer = null;
        int position = 0;
        while (position < size) {
            int j;
            if (position + DELIMITER.length <= size && FileQueueBinaryUtils.equals(DELIMITER, buffer1, position + offset)) {
                if (rowBuffer == null) {
                    rowBuffer = new HsqlByteArrayOutputStream(buffer2);
                    rowBuffer.ensureRoom(offset);
                    rowBuffer.setPosition(offset);
                    rowBuffer.write(buffer1, offset, position);
                }
                rowBuffer.write(ESCAPE);
                for (j = 0; j < DELIMITER.length; ++j) {
                    rowBuffer.write(ESCAPE[j] ^ DELIMITER[j]);
                }
                position += DELIMITER.length;
                continue;
            }
            if (position + ESCAPE.length <= size && FileQueueBinaryUtils.equals(ESCAPE, buffer1, position + offset)) {
                if (rowBuffer == null) {
                    rowBuffer = new HsqlByteArrayOutputStream(buffer2);
                    rowBuffer.ensureRoom(offset);
                    rowBuffer.setPosition(offset);
                    rowBuffer.write(buffer1, offset, position);
                }
                rowBuffer.write(ESCAPE);
                for (j = 0; j < DELIMITER.length; ++j) {
                    rowBuffer.write(ESCAPE[j] ^ ESCAPE[j]);
                }
                position += ESCAPE.length;
                continue;
            }
            if (rowBuffer != null) {
                rowBuffer.write(buffer1[offset + position]);
            }
            ++position;
        }
        return rowBuffer;
    }

    public static int unescapeBuffer(byte[] buffer, int offset, int length) {
        int j = 0;
        int position = 0;
        while (position < length) {
            if (position + ESCAPE.length <= length && FileQueueBinaryUtils.equals(ESCAPE, buffer, offset + position)) {
                position += ESCAPE.length;
                for (int jj = 0; jj < ESCAPE.length; ++jj) {
                    buffer[offset + j++] = (byte)(buffer[offset + position + jj] ^ ESCAPE[jj]);
                }
                position += ESCAPE.length;
                continue;
            }
            buffer[offset + j] = buffer[offset + position];
            ++position;
            ++j;
        }
        return j;
    }

    public static int initRowCountersInBuffer(byte[] buffer, int offset, int size, FileQueueMinMaxKeysHolder minMaxKeysHolder) throws IOException {
        int count = FileQueueBinaryUtils.initRowCountersInBuffer(buffer, offset, size, minMaxKeysHolder.getRowsCount() + 1);
        minMaxKeysHolder.incrementRowsCount(count);
        return count;
    }

    public static int initRowCountersInBuffer(byte[] buffer, int offset, int size, int startCount) throws IOException {
        int count = 0;
        int position = 0;
        while (position < size) {
            int rowSize = FileQueueBinaryUtils.readInt(buffer, offset + position);
            if (position + rowSize + 8 + 4 + DELIMITER.length > size) {
                throw new IOException("Invalid row of size " + rowSize + " in buffer of size " + size + " at position " + position + ".");
            }
            int rowSizeEnd = FileQueueBinaryUtils.readInt(buffer, offset + (position += rowSize + 4));
            if (rowSize != rowSizeEnd) {
                throw new IOException("Invalid row of size " + rowSize + " in buffer of size " + size + " at position " + (position - (rowSize + 4)) + ". Row size at the end mismatch: " + rowSizeEnd + ".");
            }
            FileQueueBinaryUtils.writeInt(startCount, buffer, offset + (position += 4));
            position += 4 + DELIMITER.length;
            ++startCount;
            ++count;
        }
        return count;
    }

    public static void writeInt(int v, byte[] buffer, int offset) {
        buffer[offset++] = (byte)(v >>> 24);
        buffer[offset++] = (byte)(v >>> 16);
        buffer[offset++] = (byte)(v >>> 8);
        buffer[offset++] = (byte)v;
    }

    public static int readInt(byte[] buffer, int offset) {
        int ch1 = buffer[offset++] & 0xFF;
        int ch2 = buffer[offset++] & 0xFF;
        int ch3 = buffer[offset++] & 0xFF;
        int ch4 = buffer[offset++] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }
}

