/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.jfq;

import com.streamscape.Trace;
import com.streamscape.ds.io.rowio.RowInputBinary;
import com.streamscape.ds.persist.jfq.FileQueueBinaryUtils;
import com.streamscape.ds.persist.jfq.FileQueueFilesManager;
import com.streamscape.ds.persist.jfq.FileQueueKeyColumnIndexes;
import com.streamscape.ds.persist.jfq.FileQueueKeyComparator;
import com.streamscape.ds.persist.jfq.FileQueueReader;
import com.streamscape.ds.persist.jfq.FileQueueReaderAccess;
import com.streamscape.ds.persist.jfq.FileQueueRowTypesKeysHolder;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;

public class FileQueueBinaryReader
extends FileQueueReader {
    private static final int READ_CURRENT_KEY_BUFFER = 1028;
    private static final int READ_PREVIOUS_BUFFER = 4096;
    private static final int READ_NEXT_BUFFER = 16384;
    private final FileQueueRowTypesKeysHolder typesKeysHolder;
    private FileQueueReaderAccess readerAccess;
    private long filePosition;
    private byte[] buffer = new byte[1024];
    private long fileBufferPosition = -1L;
    private int bufferOffset = 0;
    private int bufferSize = 0;
    private int currentRowLength = -1;
    private long currentRowPosition = -1L;
    private KeyValueHolder currentKey;
    private Object[] currentRow;
    private boolean isClosed;

    public FileQueueBinaryReader(FileQueueReaderAccess readerAccess, FileQueueRowTypesKeysHolder typesKeysHolder) throws IOException {
        this.typesKeysHolder = typesKeysHolder;
        this.readerAccess = readerAccess;
        this.isClosed = false;
    }

    private synchronized void seek(long filePosition) throws IOException {
        this.checkNotClosed();
        this.filePosition = filePosition;
        if (this.fileBufferPosition != -1L) {
            if (this.fileBufferPosition + (long)this.bufferOffset <= filePosition && filePosition <= this.fileBufferPosition + (long)this.bufferSize) {
                this.bufferOffset = (int)(filePosition - this.fileBufferPosition);
                this.filePosition = this.fileBufferPosition + (long)this.bufferSize;
            } else {
                this.fileBufferPosition = -1L;
                this.bufferOffset = 0;
                this.bufferSize = 0;
            }
        }
    }

    @Override
    public synchronized void close() {
        if (this.readerAccess != null) {
            this.readerAccess.close();
            this.isClosed = true;
            this.readerAccess = null;
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public synchronized long length() throws IOException {
        if (this.isClosed) {
            return 0L;
        }
        return this.readerAccess.length();
    }

    @Override
    public synchronized Object[] getMinKeys() throws IOException {
        this.checkNotClosed();
        if (this.readerAccess.length() < (long)(FileQueueBinaryUtils.HEADER_LENGTH + FileQueueBinaryUtils.ROW_META_LENGTH)) {
            return null;
        }
        this.seek(FileQueueBinaryUtils.HEADER_LENGTH);
        return this.readKey(this.typesKeysHolder.getCompoundKey(), 0).getKey();
    }

    @Override
    public synchronized Object[] getMaxKeys() throws IOException {
        this.checkNotClosed();
        if (this.readerAccess.length() < (long)(FileQueueBinaryUtils.HEADER_LENGTH + FileQueueBinaryUtils.ROW_META_LENGTH)) {
            return null;
        }
        this.seek(this.readerAccess.length() - (long)(8 + FileQueueBinaryUtils.DELIMITER.length));
        int rowLength = this.readInt();
        this.seek(this.readerAccess.length() - (long)(rowLength + FileQueueBinaryUtils.ROW_META_LENGTH));
        return this.readKey(this.typesKeysHolder.getCompoundKey(), 0).getKey();
    }

    public synchronized int getRowsCount() throws IOException {
        this.checkNotClosed();
        if (this.readerAccess.length() < (long)(FileQueueBinaryUtils.HEADER_LENGTH + FileQueueBinaryUtils.ROW_META_LENGTH)) {
            return 0;
        }
        this.seek(this.readerAccess.length() - (long)(4 + FileQueueBinaryUtils.DELIMITER.length));
        return this.readInt();
    }

    @Override
    public synchronized long seekTo(FileQueueKeyComparator comparator, FileQueueKeyColumnIndexes indexes, FileQueueFilesManager.SeekType seekType, boolean first) throws IOException {
        this.checkNotClosed();
        if (this.readerAccess.length() < (long)(FileQueueBinaryUtils.HEADER_LENGTH + FileQueueBinaryUtils.ROW_META_LENGTH)) {
            if (seekType != FileQueueFilesManager.SeekType.EQUALS && this.readerAccess.length() == (long)FileQueueBinaryUtils.HEADER_LENGTH) {
                this.resetCurrents();
                this.currentRowPosition = FileQueueBinaryUtils.HEADER_LENGTH;
                return FileQueueBinaryUtils.HEADER_LENGTH;
            }
            return -1L;
        }
        switch (seekType) {
            case GREATER: 
            case GREATER_EQUALS: {
                if (!first) break;
                this.resetCurrents();
                this.currentRowPosition = FileQueueBinaryUtils.HEADER_LENGTH;
                return FileQueueBinaryUtils.HEADER_LENGTH;
            }
            case LESS: 
            case LESS_EQUALS: 
            case LESS_EQUALS_OR_NEXT: {
                if (first) break;
                this.resetCurrents();
                this.currentRowPosition = this.length();
                return this.length();
            }
        }
        FileQueueRowTypesKeysHolder.KeyHolder keyHolder = this.typesKeysHolder.getKeyForColumns(indexes.getColumnIndexes());
        if (first && seekType == FileQueueFilesManager.SeekType.LESS_EQUALS_OR_NEXT && keyHolder.isUnique() && this.currentRowPosition != -1L) {
            Object[] key;
            if (this.currentKey != null && this.currentKey.getKey() != null && this.currentKey.getKeyHolder().containsColumns(indexes.getColumnIndexes()) && comparator.compareTo(this.currentKey.getKey()) == 0) {
                return this.currentRowPosition;
            }
            if (this.hasNext() && comparator.compareTo(key = this.nextKey(keyHolder)) == 0) {
                this.resetCurrents();
                return this.currentRowPosition;
            }
        }
        return this.seekTo(FileQueueBinaryUtils.HEADER_LENGTH, this.readerAccess.length(), comparator, keyHolder, seekType, first);
    }

    private long seekTo(long beginPosition, long endPosition, FileQueueKeyComparator comparator, FileQueueRowTypesKeysHolder.KeyHolder keyHolder, FileQueueFilesManager.SeekType seekType, boolean first) throws IOException {
        if (endPosition - beginPosition < (long)FileQueueBinaryUtils.ROW_META_LENGTH) {
            if (this.currentRowPosition == -1L) {
                if (seekType != FileQueueFilesManager.SeekType.EQUALS) {
                    this.seek(FileQueueBinaryUtils.HEADER_LENGTH);
                    this.resetCurrents();
                    this.currentRowPosition = FileQueueBinaryUtils.HEADER_LENGTH;
                    return FileQueueBinaryUtils.HEADER_LENGTH;
                }
                return -1L;
            }
            switch (seekType) {
                case GREATER: 
                case GREATER_EQUALS: {
                    int result;
                    if (first) break;
                    while (((result = comparator.compareTo(this.currentKey.getKey())) > 0 || seekType != FileQueueFilesManager.SeekType.GREATER && result == 0) && this.hasNext()) {
                        this.nextKey(keyHolder);
                    }
                    while ((result = comparator.compareTo(this.currentKey.getKey())) < 0 || seekType == FileQueueFilesManager.SeekType.GREATER && result == 0) {
                        if (!this.hasPrevious()) {
                            if (this.currentRowLength > 0) {
                                this.currentRowPosition += (long)(this.currentRowLength + FileQueueBinaryUtils.ROW_META_LENGTH);
                            }
                            this.resetCurrents();
                            return this.currentRowPosition;
                        }
                        this.previousKey(keyHolder);
                    }
                    break;
                }
                case EQUALS: {
                    if (comparator.compareTo(this.currentKey.getKey()) != 0) {
                        this.currentRowPosition = -1L;
                        break;
                    }
                    if (first) {
                        while (comparator.compareTo(this.currentKey.getKey()) == 0 && this.hasPrevious()) {
                            this.previousKey(keyHolder);
                        }
                        if (comparator.compareTo(this.currentKey.getKey()) == 0) break;
                        if (this.hasNext()) {
                            this.nextKey();
                            if (comparator.compareTo(this.currentKey.getKey()) == 0) break;
                            this.currentRowPosition = -1L;
                            break;
                        }
                        this.currentRowPosition = -1L;
                        break;
                    }
                    while (comparator.compareTo(this.currentKey.getKey()) == 0 && this.hasNext()) {
                        this.nextKey(keyHolder);
                    }
                    if (comparator.compareTo(this.currentKey.getKey()) == 0) break;
                    if (this.hasPrevious()) {
                        this.previousKey();
                        if (comparator.compareTo(this.currentKey.getKey()) == 0) break;
                        this.currentRowPosition = -1L;
                        break;
                    }
                    this.currentRowPosition = -1L;
                    break;
                }
                case LESS: 
                case LESS_EQUALS: 
                case LESS_EQUALS_OR_NEXT: {
                    int result;
                    if (!first) break;
                    while (((result = comparator.compareTo(this.currentKey.getKey())) < 0 || seekType != FileQueueFilesManager.SeekType.LESS && result == 0) && this.hasPrevious()) {
                        this.previousKey(keyHolder);
                    }
                    while ((result = comparator.compareTo(this.currentKey.getKey())) > 0 || seekType == FileQueueFilesManager.SeekType.LESS && result == 0) {
                        if (!this.hasNext()) {
                            if (this.currentRowLength > 0) {
                                this.currentRowPosition += (long)(this.currentRowLength + FileQueueBinaryUtils.ROW_META_LENGTH);
                            }
                            this.resetCurrents();
                            return this.currentRowPosition;
                        }
                        this.nextKey(keyHolder);
                    }
                    break;
                }
            }
            this.resetCurrents();
            return this.currentRowPosition;
        }
        long middlePosition = (endPosition + beginPosition) / 2L;
        this.seek(middlePosition);
        long currentRowPositionOld = this.currentRowPosition;
        KeyValueHolder keyValueHolder = this.readCurrentKey(keyHolder);
        if (this.currentRowPosition == currentRowPositionOld) {
            return this.seekTo(this.currentRowPosition + (long)this.currentRowLength + 8L + 4L, this.currentRowPosition + (long)this.currentRowLength + 8L + 4L, comparator, keyHolder, seekType, first);
        }
        int compareResult = comparator.compareTo(keyValueHolder.getKey());
        if (compareResult == 0) {
            if (seekType == FileQueueFilesManager.SeekType.EQUALS && keyHolder.isUnique()) {
                this.resetCurrents();
                return this.currentRowPosition;
            }
            return this.seekTo(endPosition, endPosition, comparator, keyHolder, seekType, first);
        }
        if (compareResult > 0) {
            return this.seekTo(this.currentRowPosition + (long)this.currentRowLength + (long)FileQueueBinaryUtils.ROW_META_LENGTH, endPosition, comparator, keyHolder, seekType, first);
        }
        return this.seekTo(beginPosition, this.currentRowPosition, comparator, keyHolder, seekType, first);
    }

    @Override
    public synchronized boolean hasNext() throws IOException {
        long fileLength;
        if (this.isClosed) {
            return false;
        }
        if (this.currentRowPosition < 0L) {
            throw new IOException("Reader not yet initialized.");
        }
        long nextPosition = this.currentRowPosition;
        if (this.currentRowLength > 0) {
            nextPosition += (long)(this.currentRowLength + FileQueueBinaryUtils.ROW_META_LENGTH);
        }
        if (nextPosition + 4L >= (fileLength = this.length())) {
            this.currentRowPosition = nextPosition;
            this.currentRowLength = -1;
            return false;
        }
        this.seek(nextPosition);
        int rowLength = this.readInt();
        return nextPosition + (long)rowLength + (long)FileQueueBinaryUtils.ROW_META_LENGTH <= fileLength;
    }

    @Override
    public synchronized boolean hasPrevious() throws IOException {
        if (this.isClosed) {
            return false;
        }
        if (this.currentRowPosition < 0L) {
            throw new IOException("Reader not yet initialized.");
        }
        long previousPosition = this.currentRowPosition - (long)(FileQueueBinaryUtils.DELIMITER.length + 4 + 4);
        if (previousPosition < (long)FileQueueBinaryUtils.HEADER_LENGTH) {
            this.currentRowPosition = FileQueueBinaryUtils.HEADER_LENGTH;
            this.currentRowLength = -1;
            return false;
        }
        return true;
    }

    @Override
    public synchronized Object[] nextKey() throws IOException {
        return this.nextKey(this.typesKeysHolder.getCompoundKey());
    }

    public synchronized Object[] nextKey(FileQueueRowTypesKeysHolder.KeyHolder keyHolder) throws IOException {
        if (this.isClosed) {
            return null;
        }
        if (!this.hasNext()) {
            throw new IOException("No next row.");
        }
        if (this.currentRowLength > 0) {
            this.currentRowPosition += (long)(this.currentRowLength + FileQueueBinaryUtils.ROW_META_LENGTH);
        }
        this.currentRowLength = -1;
        this.seek(this.currentRowPosition);
        this.currentKey = this.readKey(keyHolder, 16384);
        return this.currentKey != null ? this.currentKey.getKey() : null;
    }

    @Override
    public synchronized Object[] previousKey() throws IOException {
        return this.previousKey(this.typesKeysHolder.getCompoundKey());
    }

    public synchronized Object[] previousKey(FileQueueRowTypesKeysHolder.KeyHolder keyHolder) throws IOException {
        if (this.isClosed) {
            return null;
        }
        if (!this.hasPrevious()) {
            throw new IOException("No next row.");
        }
        this.seek(this.currentRowPosition - (long)(FileQueueBinaryUtils.DELIMITER.length + 4 + 4));
        this.currentRowLength = this.readInt();
        this.currentRowPosition -= (long)(FileQueueBinaryUtils.ROW_META_LENGTH + this.currentRowLength);
        this.seek(this.currentRowPosition);
        this.currentKey = this.readKey(keyHolder, 0);
        return this.currentKey != null ? this.currentKey.getKey() : null;
    }

    @Override
    public synchronized Object[] nextRow() throws IOException {
        if (this.isClosed) {
            return null;
        }
        if (!this.hasNext()) {
            throw new IOException("No next row.");
        }
        if (this.currentRowLength > 0) {
            this.currentRowPosition += (long)(this.currentRowLength + FileQueueBinaryUtils.ROW_META_LENGTH);
        }
        this.currentRowLength = -1;
        this.seek(this.currentRowPosition);
        this.currentRow = this.readRow();
        return this.currentRow;
    }

    @Override
    public synchronized void skipNext() throws IOException {
        if (this.isClosed) {
            return;
        }
        if (!this.hasNext()) {
            throw new IOException("No next row.");
        }
        if (this.currentRowLength > 0) {
            this.currentRowPosition += (long)(this.currentRowLength + FileQueueBinaryUtils.ROW_META_LENGTH);
        }
        this.currentRowLength = -1;
        this.seek(this.currentRowPosition);
        this.ensureBuffer(4, 16384);
        this.currentRowPosition = this.fileBufferPosition + (long)this.bufferOffset;
        this.resetCurrents();
        this.currentRowLength = this.readInt();
    }

    @Override
    public synchronized Object[] previousRow() throws IOException {
        if (this.isClosed) {
            return null;
        }
        if (!this.hasPrevious()) {
            throw new IOException("No previous row.");
        }
        this.seek(this.currentRowPosition - (long)(FileQueueBinaryUtils.DELIMITER.length + 4 + 4));
        this.currentRowLength = this.readInt();
        this.currentRowPosition -= (long)(FileQueueBinaryUtils.ROW_META_LENGTH + this.currentRowLength);
        this.currentRowLength = -1;
        this.seek(this.currentRowPosition);
        this.currentRow = this.readRow();
        return this.currentRow;
    }

    @Override
    public synchronized void skipPrevious() throws IOException {
        if (this.isClosed) {
            return;
        }
        if (!this.hasPrevious()) {
            throw new IOException("No previous row.");
        }
        this.seek(this.currentRowPosition - (long)(FileQueueBinaryUtils.DELIMITER.length + 4 + 4));
        this.currentRowLength = this.readInt();
        this.currentRowPosition -= (long)(FileQueueBinaryUtils.ROW_META_LENGTH + this.currentRowLength);
        this.currentRowLength = -1;
        this.seek(this.currentRowPosition);
        this.ensureBuffer(4096);
        this.currentRowPosition = this.fileBufferPosition + (long)this.bufferOffset;
        this.resetCurrents();
        this.currentRowLength = this.readInt();
    }

    @Override
    public synchronized long getLastReadSizeInBytes() {
        return this.currentRowLength >= 0 ? (long)this.currentRowLength : 0L;
    }

    private KeyValueHolder readCurrentKey(FileQueueRowTypesKeysHolder.KeyHolder keyHolder) throws IOException {
        int delimiterIndex = -1;
        while (true) {
            this.ensureBuffer(1028);
            for (int position = this.bufferOffset; position < this.bufferSize; ++position) {
                if (position + FileQueueBinaryUtils.DELIMITER.length > this.bufferSize || !FileQueueBinaryUtils.equals(FileQueueBinaryUtils.DELIMITER, this.buffer, position)) continue;
                delimiterIndex = position;
                break;
            }
            if (delimiterIndex != -1 || this.bufferSize - this.bufferOffset < 1028) break;
            this.seek(this.fileBufferPosition + (long)this.bufferSize);
        }
        if (delimiterIndex == -1) {
            throw new IOException("Invalid file structure. End delimiter not found after filePosition " + (this.fileBufferPosition + (long)this.bufferOffset) + ".");
        }
        this.seek(this.fileBufferPosition + (long)delimiterIndex - 4L - 4L);
        this.currentRowLength = this.readInt();
        this.currentRowPosition = this.fileBufferPosition + (long)this.bufferOffset - 8L - (long)this.currentRowLength;
        this.seek(this.currentRowPosition);
        this.currentKey = this.readKey(keyHolder, 0);
        return this.currentKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyValueHolder readKey(FileQueueRowTypesKeysHolder.KeyHolder keyHolder, int toRead) throws IOException {
        toRead = Math.max(keyHolder.getLengthInBytes(), toRead);
        if (toRead == 0) {
            toRead = 128;
        }
        this.ensureBuffer(toRead);
        this.currentRowPosition = this.fileBufferPosition + (long)this.bufferOffset;
        this.currentRowLength = this.readInt();
        if (keyHolder.getLengthInBytes() > 0) {
            toRead = Math.min(this.currentRowLength, keyHolder.getLengthInBytes() * 2);
            this.ensureBuffer(toRead);
            if (this.bufferSize - this.bufferOffset < toRead) {
                throw new IOException("File queue has invalid format. Failed to read " + toRead + " bytes at filePosition " + (this.fileBufferPosition + (long)this.bufferOffset) + ".");
            }
        } else {
            toRead = this.currentRowLength;
            this.ensureBuffer(this.currentRowLength);
            if (this.bufferSize - this.bufferOffset < this.currentRowLength) {
                throw new IOException("File queue has invalid format. Failed to read " + this.currentRowLength + " bytes at filePosition " + (this.fileBufferPosition + (long)this.bufferOffset) + ".");
            }
        }
        FileQueueBinaryUtils.unescapeBuffer(this.buffer, this.bufferOffset, toRead);
        try {
            KeyValueHolder keyValueHolder = this.readKeyFromBuffer(this.bufferOffset, keyHolder);
            return keyValueHolder;
        }
        finally {
            this.bufferOffset += toRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] readRow() throws IOException {
        this.ensureBuffer(4, 16384);
        this.currentRowPosition = this.fileBufferPosition + (long)this.bufferOffset;
        this.currentRowLength = this.readInt();
        this.ensureBuffer(this.currentRowLength + FileQueueBinaryUtils.ROW_META_LENGTH - 4, 16384);
        if (this.bufferSize - this.bufferOffset < this.currentRowLength) {
            throw new IOException("File queue has invalid format or corrupted. Failed to read row of size " + this.currentRowLength + " bytes at position " + (this.fileBufferPosition + (long)this.bufferOffset) + ".");
        }
        RowInputBinary rowInputBinary = new RowInputBinary(this.buffer);
        rowInputBinary.skip(this.bufferOffset + this.currentRowLength);
        int currentRowLengthFromEnd = rowInputBinary.readInt();
        if (currentRowLengthFromEnd != this.currentRowLength) {
            Trace.logError(this, "WARNING: File {}: Row length in the beginning doesn't match row length in the end. Trying to find next delimiter. Row position: {}, row length in the beginning: {}, row length in the end: {}", this.readerAccess.getFilepath().getFileName(), this.currentRowPosition, this.currentRowLength, currentRowLengthFromEnd);
            int offset = this.bufferOffset + this.currentRowLength + 4 + 4;
            int delimiterIndex = -1;
            do {
                for (int position = offset; position < this.bufferSize; ++position) {
                    if (position + FileQueueBinaryUtils.DELIMITER.length > this.bufferSize || !FileQueueBinaryUtils.equals(FileQueueBinaryUtils.DELIMITER, this.buffer, position)) continue;
                    delimiterIndex = position;
                    break;
                }
                if (delimiterIndex != -1) break;
                this.seek(this.fileBufferPosition + (long)this.bufferSize);
                this.ensureBuffer(16384);
                offset = 0;
            } while (this.bufferSize != 0);
            if (delimiterIndex == -1) {
                throw new IOException("File queue has invalid format or corrupted. Length mismatch for row at position " + this.currentRowPosition + ", length in the beginning: " + this.currentRowLength + ", length at the end: " + currentRowLengthFromEnd + " and next file delimiter not found.");
            }
            long delimiterPosition = this.fileBufferPosition + (long)delimiterIndex;
            this.seek(delimiterPosition - 8L);
            this.ensureBuffer(8);
            currentRowLengthFromEnd = this.readInt();
            if (currentRowLengthFromEnd != this.currentRowLength) {
                throw new IOException("File queue has invalid format or corrupted. Length mismatch for row at position " + this.currentRowPosition + ", length in the beginning: " + this.currentRowLength + ", length at the end: " + currentRowLengthFromEnd + ".");
            }
            int currentRowCount = this.readInt();
            if (this.currentRowPosition - (long)FileQueueBinaryUtils.DELIMITER.length - 4L > (long)FileQueueBinaryUtils.HEADER_LENGTH) {
                this.seek(this.currentRowPosition - (long)FileQueueBinaryUtils.DELIMITER.length - 4L);
                this.ensureBuffer(4);
                int previousRowCount = this.readInt();
                if (currentRowCount != previousRowCount + 1) {
                    throw new IOException("File queue has invalid format or corrupted. Row of size " + this.currentRowLength + " bytes at position " + (this.fileBufferPosition + (long)this.bufferOffset) + " has count " + currentRowCount + " and previous row has count " + previousRowCount + ".");
                }
            }
            this.currentRowLength = (int)(delimiterPosition - this.currentRowPosition - 12L);
            Trace.logError(this, "WARNING: File {}: Row delimiter is found at position {}, new row length: {}.", this.readerAccess.getFilepath(), delimiterPosition, this.currentRowLength);
            this.seek(this.currentRowPosition + 4L);
            this.ensureBuffer(this.currentRowLength + FileQueueBinaryUtils.ROW_META_LENGTH - 4, 16384);
            if (this.bufferSize - this.bufferOffset < this.currentRowLength) {
                throw new IOException("File queue has invalid format or corrupted. Failed to read row of size " + this.currentRowLength + " bytes at filePosition " + (this.fileBufferPosition + (long)this.bufferOffset) + ".");
            }
        } else {
            rowInputBinary.skip(4L);
            byte[] delimiter = new byte[FileQueueBinaryUtils.DELIMITER.length];
            rowInputBinary.read(delimiter, 0, delimiter.length);
            if (!Arrays.equals(delimiter, FileQueueBinaryUtils.DELIMITER)) {
                throw new IOException("File queue has invalid format or corrupted. Invalid delimiter for the row of size " + this.currentRowLength + " at position " + this.currentRowPosition + ".");
            }
        }
        FileQueueBinaryUtils.unescapeBuffer(this.buffer, this.bufferOffset, this.currentRowLength);
        try {
            Object[] objectArray = this.readRowFromBuffer(this.bufferOffset);
            return objectArray;
        }
        finally {
            this.bufferOffset += this.currentRowLength;
        }
    }

    private KeyValueHolder readKeyFromBuffer(int offset, FileQueueRowTypesKeysHolder.KeyHolder keyHolder) throws IOException {
        RowInputBinary rowInputBinary = new RowInputBinary(this.buffer);
        rowInputBinary.skip(offset);
        Object[] keysData = null;
        keysData = keyHolder.getLengthInBytes() > 0 ? rowInputBinary.readData(keyHolder.getKeyTypes()) : rowInputBinary.readData(this.typesKeysHolder.getRowTypes());
        int j = 0;
        for (int i : keyHolder.getColumnIndexesSorted()) {
            while (j < i) {
                keysData[j++] = null;
            }
            j = i + 1;
        }
        return new KeyValueHolder(keysData, keyHolder);
    }

    private Object[] readRowFromBuffer(int offset) throws IOException {
        RowInputBinary rowInputBinary = new RowInputBinary(this.buffer);
        rowInputBinary.skip(offset);
        return rowInputBinary.readData(this.typesKeysHolder.getRowTypes());
    }

    private int ensureBuffer(int toEnsure, int sizeToRead) throws IOException {
        if (sizeToRead < toEnsure) {
            sizeToRead = toEnsure;
        }
        if (this.fileBufferPosition == -1L) {
            if (sizeToRead > this.buffer.length) {
                this.buffer = new byte[sizeToRead];
            }
            this.readerAccess.seek(this.filePosition);
            this.bufferSize = this.readerAccess.read(this.buffer, 0, sizeToRead);
            if (this.bufferSize < 0) {
                this.bufferSize = 0;
            }
            this.bufferOffset = 0;
            this.fileBufferPosition = this.filePosition;
            this.filePosition += (long)this.bufferSize;
            return this.bufferSize;
        }
        if (toEnsure <= this.bufferSize - this.bufferOffset) {
            return 0;
        }
        if (sizeToRead > this.buffer.length - this.bufferOffset) {
            if (sizeToRead <= this.buffer.length) {
                System.arraycopy(this.buffer, this.bufferOffset, this.buffer, 0, this.bufferSize - this.bufferOffset);
                this.fileBufferPosition += (long)this.bufferOffset;
                this.bufferSize -= this.bufferOffset;
                this.bufferOffset = 0;
            } else {
                byte[] newBuffer = new byte[sizeToRead];
                System.arraycopy(this.buffer, this.bufferOffset, newBuffer, 0, this.bufferSize - this.bufferOffset);
                this.fileBufferPosition += (long)this.bufferOffset;
                this.bufferSize -= this.bufferOffset;
                this.bufferOffset = 0;
                this.buffer = newBuffer;
            }
        }
        this.readerAccess.seek(this.filePosition);
        int read = this.readerAccess.read(this.buffer, this.bufferSize, sizeToRead - (this.bufferSize - this.bufferOffset));
        if (read > 0) {
            this.filePosition += (long)read;
            this.bufferSize += read;
        }
        return read;
    }

    private int ensureBuffer(int toEnsure) throws IOException {
        return this.ensureBuffer(toEnsure, 0);
    }

    private int readInt() throws IOException {
        this.ensureBuffer(4);
        if (this.bufferSize < 4) {
            throw new EOFException();
        }
        int ch1 = this.buffer[this.bufferOffset++] & 0xFF;
        int ch2 = this.buffer[this.bufferOffset++] & 0xFF;
        int ch3 = this.buffer[this.bufferOffset++] & 0xFF;
        int ch4 = this.buffer[this.bufferOffset++] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    private void resetCurrents() {
        this.currentRowLength = -1;
        this.currentKey = null;
        this.currentRow = null;
    }

    private void checkNotClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("File reader has been closed.");
        }
    }

    public static class KeyValueHolder {
        Object[] key;
        FileQueueRowTypesKeysHolder.KeyHolder keyHolder;

        public KeyValueHolder(Object[] key, FileQueueRowTypesKeysHolder.KeyHolder keyHolder) {
            this.key = key;
            this.keyHolder = keyHolder;
        }

        public Object[] getKey() {
            return this.key;
        }

        public FileQueueRowTypesKeysHolder.KeyHolder getKeyHolder() {
            return this.keyHolder;
        }
    }
}

