/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.jfq;

import com.streamscape.ds.io.rowio.RowOutputBinary;
import com.streamscape.ds.lib.HsqlByteArrayOutputStream;
import com.streamscape.ds.persist.jfq.FileQueueBinaryUtils;
import com.streamscape.ds.persist.jfq.FileQueueDataConverter;
import com.streamscape.ds.persist.jfq.FileQueueRowTypesKeysHolder;
import java.io.IOException;

public class FileQueueBinaryDataConverter
extends FileQueueDataConverter {
    private final FileQueueRowTypesKeysHolder typesKeyHolder;
    private byte[] buffer1 = new byte[1024];
    private byte[] buffer2 = new byte[1024];
    private byte[] encodedBuffer = null;
    private int size;
    private int offset = 0;

    public FileQueueBinaryDataConverter(FileQueueRowTypesKeysHolder typesKeyHolder) throws IOException {
        this.typesKeyHolder = typesKeyHolder;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void write(Object[] data) {
        this.size = 0;
        RowOutputBinary rowOutputBinary = new RowOutputBinary(this.buffer1);
        rowOutputBinary.setPosition(this.offset + 4);
        rowOutputBinary.writeData(data, this.typesKeyHolder.getRowTypes());
        this.buffer1 = rowOutputBinary.getBuffer();
        this.escapeBufferAndFormatRow(rowOutputBinary.size() - this.offset - 4);
    }

    @Override
    public byte[] getBuffer() {
        return this.encodedBuffer;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    private void escapeBufferAndFormatRow(int size) {
        HsqlByteArrayOutputStream rowBuffer = FileQueueBinaryUtils.escapeBuffer(this.buffer1, this.offset + 4, size, this.buffer2);
        if (rowBuffer == null) {
            rowBuffer = new HsqlByteArrayOutputStream(this.buffer1);
            rowBuffer.setPosition(this.offset + 4 + size);
        }
        size = rowBuffer.size() - 4 - this.offset;
        rowBuffer.writeInt(size);
        rowBuffer.writeInt(0);
        rowBuffer.write(FileQueueBinaryUtils.DELIMITER);
        int fullSize = rowBuffer.size();
        rowBuffer.setPosition(this.offset);
        rowBuffer.writeInt(size);
        rowBuffer.setPosition(fullSize);
        this.encodedBuffer = rowBuffer.getBuffer();
        this.size = fullSize - this.offset;
        if (rowBuffer.getBuffer() != this.buffer1) {
            this.buffer2 = rowBuffer.getBuffer();
        }
    }
}

