/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.jfq;

import com.streamscape.ds.persist.jfq.FileAppendableWriter;
import com.streamscape.ds.persist.jfq.FileAppendableWriterRAF;
import com.streamscape.ds.persist.jfq.FileQueueBinaryUtils;
import com.streamscape.ds.persist.jfq.FileQueueFilesDirectoryProvider;
import com.streamscape.ds.persist.jfq.FileQueueFilesManager;
import com.streamscape.ds.persist.jfq.FileQueueRowTypesKeysHolder;
import com.streamscape.ds.replication.ReplicationDataTransaction;
import com.streamscape.ds.replication.ReplicationQueue;
import com.streamscape.ds.replication.ReplicationQueueFileBased;
import com.streamscape.ds.schema.table.JournalFileQueueTable;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.Type;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Paths;
import java.util.stream.Collectors;

public class FileQueueAnalyzer {
    public static void main(String[] args) {
        try {
            Object[] row;
            String location = null;
            String queueName = null;
            if (args.length >= 2) {
                location = args[0];
                queueName = args[1];
            }
            if (location == null) {
                location = "/Users/nkutuzov/Streamscape/mnodes/tiaa/broken_jfq/";
                queueName = "[rsq.dc$Pershing-asps.Annuities]";
            }
            FileQueueFilesDirectoryProvider fileQueueFilesDirectoryProvider = new FileQueueFilesDirectoryProvider(location, ".");
            fileQueueFilesDirectoryProvider.init();
            FileQueueRowTypesKeysHolder typesKeyHolder = new FileQueueRowTypesKeysHolder(new Type[]{Type.LONG, Type.SQL_TIMESTAMP, new OtherType("ReplicationDataTransaction", ReplicationDataTransaction.class)});
            typesKeyHolder.addKey(new int[]{0}, true);
            FileQueueFilesManager filesManager = new FileQueueFilesManager(fileQueueFilesDirectoryProvider, new JournalFileQueueTable.JournalFileQueueTableFilenameProvider(queueName), typesKeyHolder);
            filesManager.setMaxFileSizeBytes(0x8000000L);
            filesManager.setTransactionPersistentType(ReplicationQueue.ReplicationQueueSettings.DEFAULT_TRANSACTION_PERSISTENCE_TYPE);
            filesManager.setFlushTimeout(500L);
            filesManager.setWriteBufferSizeBytes(16384L);
            filesManager.init();
            System.out.println("Files count: " + filesManager.listFileNames().size());
            System.out.println("Files: " + filesManager.listFilePaths().stream().map(p -> p.toString() + "(" + p.toFile().length() + ")").collect(Collectors.joining("\n")));
            System.out.println("Rows Count: " + filesManager.getRowsCount());
            FileQueueFilesManager.FileQueueDataReader reader = filesManager.createDataReader();
            long minReplicationId = Long.MAX_VALUE;
            long maxReplicationId = Long.MIN_VALUE;
            long count = 0L;
            count = 0L;
            minReplicationId = Long.MAX_VALUE;
            maxReplicationId = Long.MIN_VALUE;
            long minReadSize = Long.MAX_VALUE;
            long maxReadSize = 0L;
            reader.seekToFirst();
            while ((row = reader.readNext()) != null) {
                ++count;
                if (reader.getLastReadSizeInBytes() < minReadSize) {
                    minReadSize = reader.getLastReadSizeInBytes();
                }
                if (reader.getLastReadSizeInBytes() > maxReadSize) {
                    maxReadSize = reader.getLastReadSizeInBytes();
                }
                if (row[0] == null) {
                    System.out.println("Row " + count + " has null ReplicationId.");
                }
                if (row[1] == null) {
                    System.out.println("Row " + count + " has null Timestamp.");
                }
                if (row[2] == null) {
                    System.out.println("Row " + count + " has null data.");
                }
                if (row[0] != null && (Long)row[0] < minReplicationId) {
                    minReplicationId = (Long)row[0];
                }
                if (row[0] == null || (Long)row[0] <= maxReplicationId) continue;
                maxReplicationId = (Long)row[0];
            }
            System.out.println("Read rows: " + count);
            System.out.println("Min ReplicationId: " + minReplicationId);
            System.out.println("Max ReplicationId: " + maxReplicationId);
            System.out.println("Max-Min ReplicationId: " + (maxReplicationId - minReplicationId + 1L));
            System.out.println("MinReadSize: " + minReadSize);
            System.out.println("MaxReadSize: " + maxReadSize);
            count = 0L;
            int batchSize = 100;
            long lastReplicationId = -1L;
            reader.seekToFirst();
            block3: while (true) {
                reader.seekToFirst(new ReplicationQueueFileBased.ReplicationQueueReplicationIdComparator(lastReplicationId + 1L), new ReplicationQueueFileBased.ReplicationQueueReplicationIdIndexes(), FileQueueFilesManager.SeekType.LESS_EQUALS_OR_NEXT);
                Object[][] batch = reader.readNextBatch(batchSize);
                if (batch == null || batch.length == 0) break;
                count += (long)batch.length;
                if (batch[batch.length - 1][0] != null) {
                    lastReplicationId = (Long)batch[batch.length - 1][0];
                }
                Object[][] objectArray = batch;
                int n = objectArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block3;
                    Object[] row2 = objectArray[n2];
                    if (row2[0] == null) {
                        System.out.println("Row " + count + " has null ReplicationId.");
                    }
                    if (row2[1] == null) {
                        System.out.println("Row " + count + " has null Timestamp.");
                    }
                    if (row2[2] == null) {
                        System.out.println("Row " + count + " has null data.");
                    }
                    ++n2;
                }
                break;
            }
            System.out.println("Read rows in batches: " + count);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }

    private static void createNewFile(String location, String queueName, FileQueueFilesManager filesManager) throws IOException {
        long startPosition = 30921549L;
        RandomAccessFile oldFile = new RandomAccessFile(location + "/" + filesManager.listFileNames().get(0), "r");
        try {
            oldFile.seek(startPosition);
            String newFilename = location + "/" + queueName + "-new_1.jfq";
            Object newFile = new FileAppendableWriterRAF(Paths.get(newFilename, new String[0]));
            ((FileAppendableWriterRAF)newFile).setLength(0);
            FileQueueBinaryUtils.initNewFile((FileAppendableWriter)newFile);
            ((FileAppendableWriterRAF)newFile).close();
            newFile = new RandomAccessFile(newFilename, "rw");
            ((RandomAccessFile)newFile).seek(((RandomAccessFile)newFile).length());
            int count = 0;
            byte[] buffer = new byte[16384];
            try {
                while (true) {
                    int rowLength;
                    int read;
                    if ((read = oldFile.read(buffer, 0, rowLength = oldFile.readInt())) != rowLength) {
                        throw new IOException("Failed to read row.");
                    }
                    ((RandomAccessFile)newFile).writeInt(rowLength);
                    ((RandomAccessFile)newFile).write(buffer, 0, rowLength);
                    int endRowLength = oldFile.readInt();
                    if (rowLength != endRowLength) {
                        throw new IOException("Wrong row begin end length");
                    }
                    oldFile.readInt();
                    oldFile.read(buffer, 0, 4);
                    ((RandomAccessFile)newFile).writeInt(rowLength);
                    ((RandomAccessFile)newFile).writeInt(++count);
                    ((RandomAccessFile)newFile).write(FileQueueBinaryUtils.DELIMITER, 0, FileQueueBinaryUtils.DELIMITER.length);
                }
            }
            catch (EOFException exception) {
                ((RandomAccessFile)newFile).close();
                oldFile.close();
            }
        }
        catch (Throwable throwable) {
            try {
                oldFile.close();
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

