/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.jfq;

import com.streamscape.ds.persist.jfq.FileAppendableWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Path;

public class FileAppendableWriterRAF
implements FileAppendableWriter {
    private RandomAccessFile appendFile;
    private long length = 0L;

    public FileAppendableWriterRAF(Path filepath) throws IOException {
        this.appendFile = new RandomAccessFile(filepath.toFile(), "rw");
        this.appendFile.seek(this.appendFile.length());
        this.length = this.appendFile.length();
    }

    @Override
    public synchronized void append(byte[] buffer, int offset, int size) throws IOException {
        this.appendFile.write(buffer, offset, size);
        this.length = this.length == -1L ? this.appendFile.length() : (this.length += (long)size);
    }

    @Override
    public synchronized long length() throws IOException {
        if (this.length == -1L) {
            return this.appendFile.length();
        }
        return this.length;
    }

    @Override
    public synchronized void seek(int position) throws IOException {
        this.appendFile.seek(position);
        if ((long)position > this.length) {
            this.length = -1L;
        }
    }

    @Override
    public synchronized void setLength(int length) throws IOException {
        this.appendFile.setLength(length);
        this.length = length;
    }

    @Override
    public synchronized void flush() {
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.appendFile != null) {
            this.appendFile.close();
            this.appendFile = null;
        }
    }
}

