/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.jfq;

import com.streamscape.Trace;
import com.streamscape.ds.persist.jfq.FileAppendableWriter;
import com.streamscape.lib.concurrent.worker.MonitorWorker;
import com.streamscape.sef.FabricException;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;

public class FileAppendableWriterBufferedWithDelay
implements FileAppendableWriter {
    private FileOutputStream outputStream;
    private BufferedOutputStream bufferedOutputStream;
    private final Path filepath;
    private long length = 0L;
    private MonitorWorker worker;

    public FileAppendableWriterBufferedWithDelay(final Path filepath, long bufferSize, long writeDelay) throws IOException {
        this.filepath = filepath;
        this.outputStream = new FileOutputStream(filepath.toFile(), true);
        this.bufferedOutputStream = new BufferedOutputStream(this.outputStream, (int)bufferSize);
        this.length = filepath.toFile().length();
        if (writeDelay > 0L) {
            try {
                this.worker = new MonitorWorker("DSYS:File.Queue.Write.Delayed", "Flushes journal queue file '" + String.valueOf(filepath) + "'.", writeDelay){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void doExecute() throws FabricException, InterruptedException {
                        FileAppendableWriterBufferedWithDelay fileAppendableWriterBufferedWithDelay = FileAppendableWriterBufferedWithDelay.this;
                        synchronized (fileAppendableWriterBufferedWithDelay) {
                            if (FileAppendableWriterBufferedWithDelay.this.bufferedOutputStream != null) {
                                try {
                                    FileAppendableWriterBufferedWithDelay.this.bufferedOutputStream.flush();
                                }
                                catch (IOException exception) {
                                    Trace.logException(this, exception, true);
                                    try {
                                        FileAppendableWriterBufferedWithDelay.this.length = filepath.toFile().length();
                                    }
                                    catch (Exception exception1) {
                                        Trace.logException(this, exception1, true);
                                    }
                                }
                            }
                        }
                    }
                };
            }
            catch (FabricException exception) {
                Trace.logException(this, exception, true);
                throw new IOException(exception);
            }
            this.worker.start();
        }
    }

    @Override
    public synchronized void append(byte[] buffer, int offset, int size) throws IOException {
        this.bufferedOutputStream.write(buffer, offset, size);
        this.length += (long)size;
    }

    @Override
    public synchronized long length() throws IOException {
        return this.length;
    }

    @Override
    public void seek(int position) throws IOException {
        throw new IOException("Seek is not allowed for buffered output.");
    }

    @Override
    public void setLength(int length) throws IOException {
        throw new IOException("Set length is not allowed for buffered output.");
    }

    @Override
    public synchronized void flush() throws IOException {
        this.bufferedOutputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.worker != null) {
            this.worker.stop(1000L);
            this.worker.join(100L);
        }
        FileAppendableWriterBufferedWithDelay fileAppendableWriterBufferedWithDelay = this;
        synchronized (fileAppendableWriterBufferedWithDelay) {
            if (this.bufferedOutputStream != null) {
                this.bufferedOutputStream.close();
                this.bufferedOutputStream = null;
            }
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
        }
    }

    public synchronized void updateFlushTimeout(long flushTimeout) throws FabricException {
        if (this.worker != null) {
            this.worker.setTimeout(flushTimeout);
        }
    }

    public synchronized void setBufferSize(long bufferSize) throws IOException {
        this.bufferedOutputStream.flush();
        this.bufferedOutputStream = new BufferedOutputStream(this.outputStream, (int)bufferSize);
    }
}

