/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.index;

import com.streamscape.Trace;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.RowInputInterface;
import com.streamscape.ds.io.rowio.RowOutputInterface;
import com.streamscape.ds.lib.IntLookup;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.persist.index.NodeAVL;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.persist.row.RowAVLDisk;
import com.streamscape.ds.schema.table.Table;
import java.io.IOException;

public class NodeAVLDisk
extends NodeAVL {
    private int iLeft = -1;
    private int iRight = -1;
    private int iParent = -1;
    private int iId;
    public static final int SIZE_IN_BYTE = 16;

    public NodeAVLDisk(RowAVLDisk r, RowInputInterface in, int id) throws IOException {
        this(r, id);
        this.iBalance = in.readInt();
        this.iLeft = in.readInt();
        if (this.iLeft <= 0) {
            this.iLeft = -1;
        }
        this.iRight = in.readInt();
        if (this.iRight <= 0) {
            this.iRight = -1;
        }
        this.iParent = in.readInt();
        if (this.iParent <= 0) {
            this.iParent = -1;
        }
    }

    public NodeAVLDisk(RowAVLDisk r, int id) {
        super(r);
        this.iId = id;
    }

    @Override
    public void delete() {
        this.iLeft = -1;
        this.iRight = -1;
        this.iParent = -1;
        this.nLeft = null;
        this.nRight = null;
        this.nParent = null;
        this.iBalance = 0;
        ((RowAVLDisk)this.row).setNodesChanged();
    }

    @Override
    public int getPos() {
        return this.row.getPos();
    }

    @Override
    public Row getRow(PersistentStore store) {
        return (RowAVLDisk)store.get(this.row, false);
    }

    @Override
    public Object[] getData(PersistentStore store) {
        return this.row.getData();
    }

    private NodeAVLDisk findNode(PersistentStore store) {
        if (this.row.isInMemory()) {
            return this;
        }
        RowAVLDisk r = (RowAVLDisk)store.get(this.row.getPos(), false);
        if (r == null) {
            String tableName = "";
            if (this.row.getTable().getTableType() == 6) {
                tableName = ((Table)this.row.getTable()).getObjectName().name;
            }
            Trace.logError(this, tableName + " NodeAVLDisk " + this.row.getPos());
            return this;
        }
        return (NodeAVLDisk)r.getNode(this.iId);
    }

    private NodeAVLDisk findNode(PersistentStore store, int pos) {
        NodeAVLDisk ret = null;
        RowAVLDisk r = (RowAVLDisk)store.get(pos, false);
        if (r != null) {
            ret = (NodeAVLDisk)r.getNode(this.iId);
        }
        return ret;
    }

    @Override
    boolean isLeft(PersistentStore store, NodeAVL n) {
        NodeAVLDisk node = this.findNode(store);
        if (n == null) {
            return node.iLeft == -1;
        }
        return node.iLeft == n.getPos();
    }

    @Override
    boolean isRight(PersistentStore store, NodeAVL n) {
        NodeAVLDisk node = this.findNode(store);
        if (n == null) {
            return node.iRight == -1;
        }
        return node.iRight == n.getPos();
    }

    @Override
    NodeAVL getLeft(PersistentStore store) {
        NodeAVLDisk node = this.findNode(store);
        if (node.iLeft == -1) {
            return null;
        }
        return this.findNode(store, node.iLeft);
    }

    @Override
    NodeAVL getRight(PersistentStore store) {
        NodeAVLDisk node = this.findNode(store);
        if (node.iRight == -1) {
            return null;
        }
        return this.findNode(store, node.iRight);
    }

    @Override
    NodeAVL getParent(PersistentStore store) {
        NodeAVLDisk node = this.findNode(store);
        if (node.iParent == -1) {
            return null;
        }
        return this.findNode(store, node.iParent);
    }

    @Override
    public int getBalance(PersistentStore store) {
        NodeAVLDisk node = this.findNode(store);
        return node.iBalance;
    }

    @Override
    boolean isRoot(PersistentStore store) {
        NodeAVLDisk node = this.findNode(store);
        return node.iParent == -1;
    }

    @Override
    boolean isFromLeft(PersistentStore store) {
        NodeAVLDisk node = this.findNode(store);
        if (node.iParent == -1) {
            return true;
        }
        NodeAVLDisk temp = this.findNode(store, node.iParent);
        return this.getPos() == temp.iLeft;
    }

    @Override
    public NodeAVL child(PersistentStore store, boolean isleft) {
        return isleft ? this.getLeft(store) : this.getRight(store);
    }

    @Override
    NodeAVL setParent(PersistentStore store, NodeAVL n) {
        RowAVLDisk row = (RowAVLDisk)store.get(this.row, true);
        NodeAVLDisk node = (NodeAVLDisk)row.getNode(this.iId);
        if (!row.isInMemory()) {
            row.keepInMemory(false);
            throw Error.runtimeError(201, "NodeAVLDisk");
        }
        row.setNodesChanged();
        node.iParent = n == null ? -1 : n.getPos();
        row.keepInMemory(false);
        return node;
    }

    @Override
    public NodeAVL setBalance(PersistentStore store, int b) {
        RowAVLDisk row = (RowAVLDisk)store.get(this.row, true);
        NodeAVLDisk node = (NodeAVLDisk)row.getNode(this.iId);
        if (!row.isInMemory()) {
            throw Error.runtimeError(201, "NodeAVLDisk");
        }
        row.setNodesChanged();
        node.iBalance = b;
        row.keepInMemory(false);
        return node;
    }

    @Override
    NodeAVL setLeft(PersistentStore store, NodeAVL n) {
        RowAVLDisk row = (RowAVLDisk)store.get(this.row, true);
        NodeAVLDisk node = (NodeAVLDisk)row.getNode(this.iId);
        if (!row.isInMemory()) {
            throw Error.runtimeError(201, "NodeAVLDisk");
        }
        node.iLeft = n == null ? -1 : n.getPos();
        row.setNodesChanged();
        row.keepInMemory(false);
        return node;
    }

    @Override
    NodeAVL setRight(PersistentStore store, NodeAVL n) {
        RowAVLDisk row = (RowAVLDisk)store.get(this.row, true);
        NodeAVLDisk node = (NodeAVLDisk)row.getNode(this.iId);
        if (!row.isInMemory()) {
            throw Error.runtimeError(201, "NodeAVLDisk");
        }
        node.iRight = n == null ? -1 : n.getPos();
        row.setNodesChanged();
        row.keepInMemory(false);
        return node;
    }

    @Override
    public NodeAVL set(PersistentStore store, boolean isLeft, NodeAVL n) {
        NodeAVL x = isLeft ? this.setLeft(store, n) : this.setRight(store, n);
        if (n != null) {
            n.setParent(store, this);
        }
        return x;
    }

    @Override
    public void replace(PersistentStore store, Index index, NodeAVL n) {
        NodeAVLDisk node = this.findNode(store);
        if (node.iParent == -1) {
            if (n != null) {
                n = n.setParent(store, null);
            }
            store.setAccessor(index, n);
        } else {
            boolean isFromLeft = this.isFromLeft(store);
            node.getParent(store).set(store, isFromLeft, n);
        }
    }

    @Override
    boolean equals(NodeAVL n) {
        if (n instanceof NodeAVLDisk) {
            return this == n || this.getPos() == n.getPos();
        }
        return false;
    }

    @Override
    public int getRealSize(RowOutputInterface out) {
        return 16;
    }

    @Override
    public void setInMemory(boolean in) {
    }

    @Override
    public void write(RowOutputInterface out) {
        out.writeInt(this.iBalance);
        out.writeInt(this.iLeft == -1 ? 0 : this.iLeft);
        out.writeInt(this.iRight == -1 ? 0 : this.iRight);
        out.writeInt(this.iParent == -1 ? 0 : this.iParent);
    }

    @Override
    public void write(RowOutputInterface out, IntLookup lookup) {
        out.writeInt(this.iBalance);
        NodeAVLDisk.writeTranslatePointer(this.iLeft, out, lookup);
        NodeAVLDisk.writeTranslatePointer(this.iRight, out, lookup);
        NodeAVLDisk.writeTranslatePointer(this.iParent, out, lookup);
    }

    private static void writeTranslatePointer(int pointer, RowOutputInterface out, IntLookup lookup) {
        int newPointer = 0;
        if (pointer != -1) {
            newPointer = lookup.lookup(pointer);
        }
        out.writeInt(newPointer);
    }

    @Override
    public void restore() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void updateAccessCount(int count) {
    }

    @Override
    public int getAccessCount() {
        return 0;
    }

    @Override
    public void setStorageSize(int size) {
    }

    @Override
    public int getStorageSize() {
        return 0;
    }

    @Override
    public void setPos(int pos) {
    }

    @Override
    public boolean hasChanged() {
        return false;
    }

    @Override
    public boolean isKeepInMemory() {
        return false;
    }

    @Override
    public boolean keepInMemory(boolean keep) {
        return false;
    }

    @Override
    public boolean isInMemory() {
        return this.row.isInMemory();
    }

    @Override
    public boolean isMemory() {
        return false;
    }
}

