/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.index;

import com.streamscape.ds.io.rowio.RowOutputInterface;
import com.streamscape.ds.lib.IntLookup;
import com.streamscape.ds.persist.CachedObject;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.persist.row.Row;

public class NodeAVL
implements CachedObject {
    static final int NO_POS = -1;
    public int iBalance;
    public NodeAVL nNext;
    protected NodeAVL nLeft;
    protected NodeAVL nRight;
    protected NodeAVL nParent;
    protected final Row row;

    NodeAVL() {
        this.row = null;
    }

    public NodeAVL(Row r) {
        this.row = r;
    }

    public void delete() {
        this.iBalance = 0;
        this.nParent = null;
        this.nRight = null;
        this.nLeft = null;
    }

    NodeAVL getLeft(PersistentStore store) {
        return this.nLeft;
    }

    NodeAVL setLeft(PersistentStore persistentStore, NodeAVL n) {
        this.nLeft = n;
        return this;
    }

    public int getBalance(PersistentStore store) {
        return this.iBalance;
    }

    boolean isLeft(PersistentStore store, NodeAVL node) {
        return this.nLeft == node;
    }

    boolean isRight(PersistentStore store, NodeAVL node) {
        return this.nRight == node;
    }

    NodeAVL getRight(PersistentStore persistentStore) {
        return this.nRight;
    }

    NodeAVL setRight(PersistentStore persistentStore, NodeAVL n) {
        this.nRight = n;
        return this;
    }

    NodeAVL getParent(PersistentStore store) {
        return this.nParent;
    }

    boolean isRoot(PersistentStore store) {
        return this.nParent == null;
    }

    NodeAVL setParent(PersistentStore persistentStore, NodeAVL n) {
        this.nParent = n;
        return this;
    }

    public NodeAVL setBalance(PersistentStore store, int b) {
        this.iBalance = b;
        return this;
    }

    boolean isFromLeft(PersistentStore store) {
        if (this.nParent == null) {
            return true;
        }
        return this == this.nParent.nLeft;
    }

    public NodeAVL child(PersistentStore store, boolean isleft) {
        return isleft ? this.getLeft(store) : this.getRight(store);
    }

    public NodeAVL set(PersistentStore store, boolean isLeft, NodeAVL n) {
        if (isLeft) {
            this.nLeft = n;
        } else {
            this.nRight = n;
        }
        if (n != null) {
            n.nParent = this;
        }
        return this;
    }

    public void replace(PersistentStore store, Index index, NodeAVL n) {
        if (this.nParent == null) {
            if (n != null) {
                n = n.setParent(store, null);
            }
            store.setAccessor(index, n);
        } else {
            this.nParent.set(store, this.isFromLeft(store), n);
        }
    }

    boolean equals(NodeAVL n) {
        return n == this;
    }

    @Override
    public void setInMemory(boolean in) {
    }

    @Override
    public void write(RowOutputInterface out) {
    }

    @Override
    public void write(RowOutputInterface out, IntLookup lookup) {
    }

    @Override
    public int getPos() {
        return 0;
    }

    protected Row getRow(PersistentStore store) {
        return this.row;
    }

    protected Object[] getData(PersistentStore store) {
        return this.row.getData();
    }

    @Override
    public void updateAccessCount(int count) {
    }

    @Override
    public int getAccessCount() {
        return 0;
    }

    @Override
    public void setStorageSize(int size) {
    }

    @Override
    public int getStorageSize() {
        return 0;
    }

    @Override
    public void setPos(int pos) {
    }

    @Override
    public boolean hasChanged() {
        return false;
    }

    @Override
    public void setChanged(boolean flag) {
    }

    @Override
    public boolean isKeepInMemory() {
        return false;
    }

    @Override
    public boolean keepInMemory(boolean keep) {
        return true;
    }

    @Override
    public boolean isInMemory() {
        return false;
    }

    @Override
    public void restore() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public int getRealSize(RowOutputInterface out) {
        return 0;
    }

    @Override
    public boolean isMemory() {
        return true;
    }

    @Override
    public int getBlock() {
        return -1;
    }

    @Override
    public void setBlock(int block) {
    }
}

