/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.index;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.session.Session;

public class IndexTimeMonitor {
    private final String name;
    private final long maxIndexOperationExecutionTimeMs;
    private long startTime;
    private long iterationsCount;

    public IndexTimeMonitor(String name, long maxIndexOperationExecutionTimeMs) {
        this.name = name;
        this.maxIndexOperationExecutionTimeMs = maxIndexOperationExecutionTimeMs;
        this.startTime = 0L;
        this.iterationsCount = 0L;
    }

    public void check() {
        ++this.iterationsCount;
        if (this.iterationsCount > 1000L) {
            if (this.startTime == 0L) {
                this.startTime = System.currentTimeMillis();
                Session.checkIfThreadIsInterrupted();
            }
            if (this.iterationsCount % 1000L == 0L) {
                Session.checkIfThreadIsInterrupted();
                if (this.maxIndexOperationExecutionTimeMs > 0L && System.currentTimeMillis() - this.startTime > this.maxIndexOperationExecutionTimeMs) {
                    Trace.logError(this, "Index(" + this.name + ") operation exceeded maximum execution time of " + this.maxIndexOperationExecutionTimeMs + "ms, iterationsCount: " + this.iterationsCount + ".");
                    Trace.logException(this, new Exception(), true);
                    throw new DataspaceException("Index(" + this.name + ") operation exceeded maximum execution time of " + this.maxIndexOperationExecutionTimeMs + " ms, iterationsCount: " + this.iterationsCount + ".");
                }
            }
        }
    }
}

