/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.index;

import com.streamscape.Trace;
import com.streamscape.ds.CheckpointManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.persist.index.IndexTimeMonitor;
import com.streamscape.ds.persist.index.NodeAVL;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.persist.row.RowAVL;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.constraint.Constraint;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableBase;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;

public class IndexAVL
implements Index {
    private static final IndexRowIterator emptyIterator = new IndexRowIterator(null, null, null, null, 0, false, false);
    private final long persistenceId;
    protected final NameManager.ObjectName name;
    private final boolean[] colCheck;
    final int[] colIndex;
    private final int[] defaultColMap;
    final Type[] colTypes;
    private final boolean[] colDesc;
    private final boolean[] nullsLast;
    final boolean isSimpleOrder;
    final boolean isSimple;
    protected final boolean isPK;
    protected final boolean isUnique;
    protected final boolean isConstraint;
    private final boolean isForward;
    private boolean isClustered;
    protected TableBase table;
    int position;
    private final long indexOperationMaxTimeMs;
    private String indexNameWithParent;
    Object[] nullData;

    public IndexAVL(NameManager.ObjectName name, long id, TableBase table, int[] columns, boolean[] descending, boolean[] nullsLast, Type[] colTypes, boolean pk, boolean unique, boolean constraint, boolean forward, String indexOperationMaxTime) {
        this.persistenceId = id;
        this.name = name;
        this.colIndex = columns;
        this.colTypes = colTypes;
        this.colDesc = descending == null ? new boolean[columns.length] : descending;
        this.nullsLast = nullsLast == null ? new boolean[columns.length] : nullsLast;
        this.isPK = pk;
        this.isUnique = unique;
        this.isConstraint = constraint;
        this.isForward = forward;
        this.table = table;
        this.colCheck = table.getNewColumnCheckList();
        ArrayUtil.intIndexesToBooleanArray(this.colIndex, this.colCheck);
        this.defaultColMap = new int[columns.length];
        ArrayUtil.fillSequence(this.defaultColMap);
        boolean simpleOrder = this.colIndex.length > 0;
        for (int i = 0; i < this.colDesc.length; ++i) {
            if (!this.colDesc[i] && !this.nullsLast[i]) continue;
            simpleOrder = false;
        }
        this.isSimpleOrder = simpleOrder;
        this.isSimple = this.isSimpleOrder && this.colIndex.length == 1;
        this.nullData = new Object[this.colIndex.length];
        this.indexOperationMaxTimeMs = CheckpointManager.convertInterval(indexOperationMaxTime);
        Trace.logDebug(this, this.getIndexNameWithParent() + ": Setting max index operation time to " + this.indexOperationMaxTimeMs + "ms (" + indexOperationMaxTime + ")");
    }

    @Override
    public int getObjectType() {
        return 21;
    }

    @Override
    public NameManager.ObjectName getObjectName() {
        return this.name;
    }

    @Override
    public NameManager.ObjectName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public NameManager.ObjectName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getSQLInSchema(String schemaName) {
        return this.getSQL(this.getObjectName().statementName, schemaName);
    }

    @Override
    public String getSQL() {
        return this.getSQL(this.getObjectName().statementName);
    }

    @Override
    public String getSQL(String name) {
        return this.getSQL(name, ((Table)this.table).getObjectName().schema.getStatementName());
    }

    public String getSQL(String name, String schemaName) {
        StringBuffer sb = new StringBuffer(64);
        sb.append("CREATE").append(' ');
        if (this.isUnique()) {
            sb.append("UNIQUE").append(' ');
        }
        sb.append("INDEX").append(' ');
        sb.append(name);
        sb.append(' ').append("ON").append(' ');
        sb.append(((Table)this.table).getObjectName().getSchemaQualifiedStatementName(schemaName));
        int[] col = this.getColumns();
        int len = this.getVisibleColumns();
        sb.append(((Table)this.table).getColumnListSQL(col, len));
        return sb.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    @Override
    public RowIterator emptyIterator() {
        return emptyIterator;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(int position) {
        this.position = position;
    }

    @Override
    public long getPersistenceId() {
        return this.persistenceId;
    }

    @Override
    public int getVisibleColumns() {
        return this.colIndex.length;
    }

    @Override
    public int getColumnCount() {
        return this.colIndex.length;
    }

    @Override
    public boolean isUnique() {
        return this.isUnique;
    }

    @Override
    public boolean isConstraint() {
        return this.isConstraint;
    }

    @Override
    public int[] getColumns() {
        return this.colIndex;
    }

    @Override
    public Type[] getColumnTypes() {
        return this.colTypes;
    }

    @Override
    public boolean[] getColumnDesc() {
        return this.colDesc;
    }

    @Override
    public int[] getDefaultColumnMap() {
        return this.defaultColMap;
    }

    @Override
    public int getIndexOrderValue() {
        if (this.isPK) {
            return 0;
        }
        if (this.isConstraint) {
            return this.isForward ? 4 : (this.isUnique ? 0 : 1);
        }
        return 2;
    }

    @Override
    public boolean isForward() {
        return this.isForward;
    }

    @Override
    public void setTable(TableBase table) {
        this.table = table;
    }

    @Override
    public void setClustered(boolean clustered) {
        this.isClustered = clustered;
    }

    @Override
    public boolean isClustered() {
        return this.isClustered;
    }

    @Override
    public int size(Session session, PersistentStore store) {
        return (int)store.elementCount(session);
    }

    @Override
    public int sizeUnique(PersistentStore store) {
        return store.elementCountUnique(this);
    }

    public int getNodeCount(Session session, PersistentStore store) {
        int count = 0;
        RowIterator it = this.firstRow(session, store);
        IndexTimeMonitor indexTimeMonitor = this.createIndexTimeMonitor();
        while (it.hasNext()) {
            indexTimeMonitor.check();
            it.getNextRow();
            ++count;
        }
        return count;
    }

    @Override
    public boolean isEmpty(PersistentStore store) {
        store.readLock();
        try {
            boolean bl = this.getAccessor(store) == null;
            return bl;
        }
        finally {
            store.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkIndex(PersistentStore store) {
        store.readLock();
        try {
            NodeAVL p;
            NodeAVL f = null;
            IndexTimeMonitor indexTimeMonitor = this.createIndexTimeMonitor();
            for (p = this.getAccessor(store); p != null; p = p.getLeft(store)) {
                indexTimeMonitor.check();
                f = p;
                this.checkNodes(store, p);
            }
            p = f;
            while (f != null) {
                indexTimeMonitor.check();
                this.checkNodes(store, f);
                f = this.next(store, f);
            }
        }
        finally {
            store.readUnlock();
        }
    }

    void checkNodes(PersistentStore store, NodeAVL p) {
        NodeAVL l = p.getLeft(store);
        NodeAVL r = p.getRight(store);
        if (l != null && l.getBalance(store) == -2) {
            System.out.print("broken index - deleted");
        }
        if (r != null && r.getBalance(store) == -2) {
            System.out.print("broken index -deleted");
        }
        if (l != null && !p.equals(l.getParent(store))) {
            System.out.print("broken index - no parent");
        }
        if (r != null && !p.equals(r.getParent(store))) {
            System.out.print("broken index - no parent");
        }
    }

    @Override
    public int compareRowNonUnique(Session session, Object[] a, Object[] b, int[] rowColMap) {
        int fieldcount = rowColMap.length;
        for (int j = 0; j < fieldcount; ++j) {
            int i = this.colTypes[j].compare(session, a[this.colIndex[j]], b[rowColMap[j]]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    @Override
    public int compareRowNonUnique(Session session, Object[] a, Object[] b, int[] rowColMap, int fieldCount) {
        for (int j = 0; j < fieldCount; ++j) {
            int i = this.colTypes[j].compare(session, a[this.colIndex[j]], b[rowColMap[j]]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    @Override
    public int compareRowNonUnique(Session session, Object[] a, Object[] b, int fieldCount) {
        for (int j = 0; j < fieldCount; ++j) {
            int i = this.colTypes[j].compare(session, a[this.colIndex[j]], b[this.colIndex[j]]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    @Override
    public int compareRow(Session session, Object[] a, Object[] b) {
        for (int j = 0; j < this.colIndex.length; ++j) {
            boolean nulls;
            int i = this.colTypes[j].compare(session, a[this.colIndex[j]], b[this.colIndex[j]]);
            if (i == 0) continue;
            if (this.isSimpleOrder) {
                return i;
            }
            boolean bl = nulls = a[this.colIndex[j]] == null || b[this.colIndex[j]] == null;
            if (this.colDesc[j] && !nulls) {
                i = -i;
            }
            if (this.nullsLast[j] && nulls) {
                i = -i;
            }
            return i;
        }
        return 0;
    }

    int compareRowForInsertOrDelete(Session session, Row newRow, Row existingRow, boolean useRowId, int start) {
        Object[] a = newRow.getData();
        Object[] b = existingRow.getData();
        for (int j = start; j < this.colIndex.length; ++j) {
            boolean nulls;
            int i = this.colTypes[j].compare(session, OtherTypeWrapper.unwrap(a[this.colIndex[j]]), OtherTypeWrapper.unwrap(b[this.colIndex[j]]));
            if (i == 0) continue;
            if (this.isSimpleOrder) {
                return i;
            }
            boolean bl = nulls = a[this.colIndex[j]] == null || b[this.colIndex[j]] == null;
            if (this.colDesc[j] && !nulls) {
                i = -i;
            }
            if (this.nullsLast[j] && nulls) {
                i = -i;
            }
            return i;
        }
        if (useRowId) {
            return newRow.getPos() - existingRow.getPos();
        }
        return 0;
    }

    int compareObject(Session session, Object[] a, Object[] b, int[] rowColMap, int position) {
        return this.colTypes[position].compare(session, a[this.colIndex[position]], b[rowColMap[position]]);
    }

    boolean hasNulls(Session session, Object[] rowData) {
        if (this.colIndex.length == 1) {
            return rowData[this.colIndex[0]] == null;
        }
        boolean normal = session == null ? true : session.dataspaceStore.sqlUniqueNulls;
        for (int j = 0; j < this.colIndex.length; ++j) {
            if (rowData[this.colIndex[j]] == null) {
                if (!normal) continue;
                return true;
            }
            if (normal) continue;
            return false;
        }
        return !normal;
    }

    @Override
    public void insert(Session session, PersistentStore store, Row row) {
        NodeAVL n;
        boolean isleft = true;
        int compare = -1;
        boolean compareRowId = !this.isUnique || this.hasNulls(session, row.getData());
        NodeAVL x = n = this.getAccessor(store);
        if (n == null) {
            store.setAccessor((Index)this, ((RowAVL)row).getNode(this.position));
            return;
        }
        IndexTimeMonitor indexTimeMonitor = this.createIndexTimeMonitor();
        do {
            indexTimeMonitor.check();
            Row currentRow = n.getRow(store);
            compare = this.compareRowForInsertOrDelete(session, row, currentRow, compareRowId, 0);
            if (compare == 0 && session != null && !compareRowId && session.dataspaceStore.txManager.isMVRows() && !this.isEqualReadable(session, store, n)) {
                compareRowId = true;
                compare = this.compareRowForInsertOrDelete(session, row, currentRow, compareRowId, this.colIndex.length);
            }
            if (compare != 0) continue;
            Constraint c = null;
            if (this.isConstraint) {
                c = ((Table)this.table).getUniqueConstraintForIndex(this);
            }
            if (c == null) {
                throw Error.error(104, this.name.statementName);
            }
            throw c.getException(row.getData());
        } while ((n = (x = n).child(store, isleft = compare < 0)) != null);
        x = x.set(store, isleft, ((RowAVL)row).getNode(this.position));
        this.balance(store, x, isleft);
    }

    @Override
    public void delete(Session session, PersistentStore store, Row row) {
        NodeAVL node = ((RowAVL)(row = (Row)store.get(row, false))).getNode(this.position);
        if (node != null) {
            this.delete(store, node);
        }
    }

    protected void delete(PersistentStore store, NodeAVL x) {
        IndexTimeMonitor indexTimeMonitor;
        NodeAVL n;
        if (x == null) {
            return;
        }
        if (x.getLeft(store) == null) {
            n = x.getRight(store);
        } else if (x.getRight(store) == null) {
            n = x.getLeft(store);
        } else {
            NodeAVL d = x;
            x = x.getLeft(store);
            indexTimeMonitor = this.createIndexTimeMonitor();
            while (true) {
                indexTimeMonitor.check();
                NodeAVL temp = x.getRight(store);
                if (temp == null) break;
                x = temp;
            }
            n = x.getLeft(store);
            int b = x.getBalance(store);
            x = x.setBalance(store, d.getBalance(store));
            d = d.setBalance(store, b);
            NodeAVL xp = x.getParent(store);
            NodeAVL dp = d.getParent(store);
            if (d.isRoot(store)) {
                store.setAccessor((Index)this, x);
            }
            x = x.setParent(store, dp);
            if (dp != null) {
                dp = dp.isRight(store, d) ? dp.setRight(store, x) : dp.setLeft(store, x);
            }
            if (d.equals(xp)) {
                if ((d = d.setParent(store, x)).isLeft(store, x)) {
                    x = x.setLeft(store, d);
                    NodeAVL dr = d.getRight(store);
                    x = x.setRight(store, dr);
                } else {
                    x = x.setRight(store, d);
                    dl = d.getLeft(store);
                    x = x.setLeft(store, dl);
                }
            } else {
                d = d.setParent(store, xp);
                xp = xp.setRight(store, d);
                dl = d.getLeft(store);
                NodeAVL dr = d.getRight(store);
                x = x.setLeft(store, dl);
                x = x.setRight(store, dr);
            }
            x.getRight(store).setParent(store, x);
            x.getLeft(store).setParent(store, x);
            d = d.setLeft(store, n);
            if (n != null) {
                n = n.setParent(store, d);
            }
            x = d = d.setRight(store, null);
        }
        boolean isleft = x.isFromLeft(store);
        x.replace(store, this, n);
        n = x.getParent(store);
        x.delete();
        indexTimeMonitor = this.createIndexTimeMonitor();
        while (n != null) {
            indexTimeMonitor.check();
            x = n;
            int sign = isleft ? 1 : -1;
            switch (x.getBalance(store) * sign) {
                case -1: {
                    x = x.setBalance(store, 0);
                    break;
                }
                case 0: {
                    x = x.setBalance(store, sign);
                    return;
                }
                case 1: {
                    NodeAVL r = x.child(store, !isleft);
                    int b = r.getBalance(store);
                    if (b * sign >= 0) {
                        x.replace(store, this, r);
                        NodeAVL child = r.child(store, isleft);
                        x = x.set(store, !isleft, child);
                        r = r.set(store, isleft, x);
                        if (b == 0) {
                            x = x.setBalance(store, sign);
                            r = r.setBalance(store, -sign);
                            return;
                        }
                        x = x.setBalance(store, 0);
                        x = r = r.setBalance(store, 0);
                        break;
                    }
                    NodeAVL l = r.child(store, isleft);
                    x.replace(store, this, l);
                    b = l.getBalance(store);
                    r = r.set(store, isleft, l.child(store, !isleft));
                    l = l.set(store, !isleft, r);
                    x = x.set(store, !isleft, l.child(store, isleft));
                    l = l.set(store, isleft, x);
                    x = x.setBalance(store, b == sign ? -sign : 0);
                    r = r.setBalance(store, b == -sign ? sign : 0);
                    x = l = l.setBalance(store, 0);
                }
            }
            isleft = x.isFromLeft(store);
            n = x.getParent(store);
        }
    }

    @Override
    public boolean existsParent(Session session, PersistentStore store, Object[] rowdata, int[] rowColMap) {
        NodeAVL node = this.findNode(session, store, rowdata, rowColMap, rowColMap.length, 41, 2, false);
        return node != null;
    }

    @Override
    public RowIterator findFirstRow(Session session, PersistentStore store, Object[] rowdata, int matchCount, int distinctCount, int compareType, boolean reversed, boolean[] map) {
        if (compareType == 74) {
            return this.lastRow(session, store);
        }
        NodeAVL node = this.findNode(session, store, rowdata, this.defaultColMap, matchCount, compareType, 0, reversed);
        if (node == null) {
            return emptyIterator;
        }
        return new IndexRowIterator(session, store, this, node, distinctCount, false, reversed);
    }

    @Override
    public RowIterator findFirstRow(Session session, PersistentStore store, Object[] rowdata) {
        NodeAVL node = this.findNode(session, store, rowdata, this.colIndex, this.colIndex.length, 41, 0, false);
        if (node == null) {
            return emptyIterator;
        }
        return new IndexRowIterator(session, store, this, node, 0, false, false);
    }

    @Override
    public RowIterator findFirstRow(Session session, PersistentStore store, Object[] rowdata, int[] rowColMap) {
        NodeAVL node = this.findNode(session, store, rowdata, rowColMap, rowColMap.length, 41, 0, false);
        if (node == null) {
            return emptyIterator;
        }
        return new IndexRowIterator(session, store, this, node, 0, false, false);
    }

    @Override
    public RowIterator findFirstRowNotNull(Session session, PersistentStore store) {
        NodeAVL node = this.findNode(session, store, this.nullData, this.defaultColMap, 1, 48, 0, false);
        if (node == null) {
            return emptyIterator;
        }
        return new IndexRowIterator(session, store, this, node, 0, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowIterator firstRow(Session session, PersistentStore store) {
        store.readLock();
        try {
            IndexRowIterator indexRowIterator;
            NodeAVL x;
            NodeAVL l = x = this.getAccessor(store);
            IndexTimeMonitor indexTimeMonitor = this.createIndexTimeMonitor();
            while (l != null) {
                indexTimeMonitor.check();
                x = l;
                l = x.getLeft(store);
            }
            while (session != null && x != null) {
                indexTimeMonitor.check();
                Row row = x.getRow(store);
                if (session.dataspaceStore.txManager.canRead(session, row, 0, null)) break;
                x = this.next(store, x);
            }
            if (x == null) {
                indexRowIterator = emptyIterator;
                return indexRowIterator;
            }
            indexRowIterator = new IndexRowIterator(session, store, this, x, 0, false, false);
            return indexRowIterator;
        }
        finally {
            store.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowIterator firstRow(PersistentStore store) {
        store.readLock();
        try {
            NodeAVL x;
            NodeAVL l = x = this.getAccessor(store);
            IndexTimeMonitor indexTimeMonitor = this.createIndexTimeMonitor();
            while (l != null) {
                indexTimeMonitor.check();
                x = l;
                l = x.getLeft(store);
            }
            if (x == null) {
                IndexRowIterator indexRowIterator = emptyIterator;
                return indexRowIterator;
            }
            IndexRowIterator indexRowIterator = new IndexRowIterator(null, store, this, x, 0, false, false);
            return indexRowIterator;
        }
        finally {
            store.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowIterator lastRow(Session session, PersistentStore store) {
        store.readLock();
        try {
            IndexRowIterator indexRowIterator;
            NodeAVL x;
            NodeAVL l = x = this.getAccessor(store);
            IndexTimeMonitor indexTimeMonitor = this.createIndexTimeMonitor();
            while (l != null) {
                indexTimeMonitor.check();
                x = l;
                l = x.getRight(store);
            }
            while (session != null && x != null) {
                indexTimeMonitor.check();
                Row row = x.getRow(store);
                if (session.dataspaceStore.txManager.canRead(session, row, 0, null)) break;
                x = this.last(store, x);
            }
            if (x == null) {
                indexRowIterator = emptyIterator;
                return indexRowIterator;
            }
            indexRowIterator = new IndexRowIterator(session, store, this, x, 0, false, true);
            return indexRowIterator;
        }
        finally {
            store.readUnlock();
        }
    }

    NodeAVL next(Session session, PersistentStore store, NodeAVL x, int distinctCount) {
        Row row;
        if (x == null) {
            return null;
        }
        IndexTimeMonitor indexTimeMonitor = this.createIndexTimeMonitor();
        do {
            indexTimeMonitor.check();
            if (distinctCount != 0) {
                Object[] baseData = x.getData(store);
                return this.findNode(session, store, baseData, this.colIndex, distinctCount, 43, 0, false);
            }
            x = this.next(store, x);
            if (x == null) {
                return x;
            }
            if (session != null) continue;
            return x;
        } while (!session.dataspaceStore.txManager.canRead(session, row = x.getRow(store), 0, null));
        return x;
    }

    NodeAVL last(Session session, PersistentStore store, NodeAVL x, int distinctCount) {
        Row row;
        if (x == null) {
            return null;
        }
        IndexTimeMonitor indexTimeMonitor = this.createIndexTimeMonitor();
        do {
            indexTimeMonitor.check();
            if (distinctCount != 0) {
                Object[] baseData = x.getData(store);
                return this.findNode(session, store, baseData, this.colIndex, distinctCount, 44, 0, false);
            }
            x = this.last(store, x);
            if (x == null) {
                return x;
            }
            if (session != null) continue;
            return x;
        } while (!session.dataspaceStore.txManager.canRead(session, row = x.getRow(store), 0, null));
        return x;
    }

    NodeAVL next(PersistentStore store, NodeAVL x) {
        NodeAVL temp = x.getRight(store);
        if (temp != null) {
            x = temp;
            temp = x.getLeft(store);
            IndexTimeMonitor indexTimeMonitor = this.createIndexTimeMonitor();
            while (temp != null) {
                indexTimeMonitor.check();
                x = temp;
                temp = x.getLeft(store);
            }
            return x;
        }
        temp = x;
        IndexTimeMonitor indexTimeMonitor = this.createIndexTimeMonitor();
        for (x = x.getParent(store); x != null && x.isRight(store, temp); x = x.getParent(store)) {
            indexTimeMonitor.check();
            temp = x;
        }
        return x;
    }

    NodeAVL last(PersistentStore store, NodeAVL x) {
        if (x == null) {
            return null;
        }
        NodeAVL temp = x.getLeft(store);
        if (temp != null) {
            x = temp;
            temp = x.getRight(store);
            IndexTimeMonitor indexTimeMonitor = this.createIndexTimeMonitor();
            while (temp != null) {
                indexTimeMonitor.check();
                x = temp;
                temp = x.getRight(store);
            }
            return x;
        }
        temp = x;
        IndexTimeMonitor indexTimeMonitor = this.createIndexTimeMonitor();
        for (x = x.getParent(store); x != null && x.isLeft(store, temp); x = x.getParent(store)) {
            indexTimeMonitor.check();
            temp = x;
        }
        return x;
    }

    boolean isEqualReadable(Session session, PersistentStore store, NodeAVL node) {
        block4: {
            Object[] nodeData;
            IndexTimeMonitor indexTimeMonitor;
            Object[] data;
            Row row;
            NodeAVL c;
            block3: {
                c = node;
                row = node.getRow(store);
                session.dataspaceStore.txManager.setTransactionInfo(row);
                if (session.dataspaceStore.txManager.canRead(session, row, 1, null)) {
                    return true;
                }
                data = node.getData(store);
                indexTimeMonitor = this.createIndexTimeMonitor();
                do {
                    indexTimeMonitor.check();
                    c = this.last(store, c);
                    if (c == null || this.compareRow(session, data, nodeData = c.getData(store)) != 0) break block3;
                    row = c.getRow(store);
                    session.dataspaceStore.txManager.setTransactionInfo(row);
                } while (!session.dataspaceStore.txManager.canRead(session, row, 1, null));
                return true;
            }
            do {
                indexTimeMonitor.check();
                c = this.next(session, store, node, 0);
                if (c == null || this.compareRow(session, data, nodeData = c.getData(store)) != 0) break block4;
                row = c.getRow(store);
                session.dataspaceStore.txManager.setTransactionInfo(row);
            } while (!session.dataspaceStore.txManager.canRead(session, row, 1, null));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeAVL findNode(Session session, PersistentStore store, Object[] rowdata, int[] rowColMap, int fieldCount, int compareType, int readMode, boolean reversed) {
        store.readLock();
        try {
            NodeAVL x = this.getAccessor(store);
            NodeAVL n = null;
            NodeAVL result = null;
            Row currentRow = null;
            if (compareType != 41 && compareType != 47) {
                --fieldCount;
            }
            IndexTimeMonitor indexTimeMonitor = this.createIndexTimeMonitor();
            while (x != null) {
                indexTimeMonitor.check();
                currentRow = x.getRow(store);
                int i = 0;
                if (fieldCount > 0) {
                    i = this.compareRowNonUnique(session, currentRow.getData(), rowdata, rowColMap, fieldCount);
                }
                if (i == 0) {
                    switch (compareType) {
                        case 41: 
                        case 47: {
                            result = x;
                            n = x.getLeft(store);
                            break;
                        }
                        case 43: 
                        case 48: {
                            i = this.compareObject(session, currentRow.getData(), rowdata, rowColMap, fieldCount);
                            if (i <= 0) {
                                n = x.getRight(store);
                                break;
                            }
                            result = x;
                            n = x.getLeft(store);
                            break;
                        }
                        case 42: {
                            i = this.compareObject(session, currentRow.getData(), rowdata, rowColMap, fieldCount);
                            if (i < 0) {
                                n = x.getRight(store);
                                break;
                            }
                            result = x;
                            n = x.getLeft(store);
                            break;
                        }
                        case 44: {
                            i = this.compareObject(session, currentRow.getData(), rowdata, rowColMap, fieldCount);
                            if (i < 0) {
                                result = x;
                                n = x.getRight(store);
                                break;
                            }
                            n = x.getLeft(store);
                            break;
                        }
                        case 45: {
                            i = this.compareObject(session, currentRow.getData(), rowdata, rowColMap, fieldCount);
                            if (i <= 0) {
                                result = x;
                                n = x.getRight(store);
                                break;
                            }
                            n = x.getLeft(store);
                            break;
                        }
                        default: {
                            Error.runtimeError(201, "Index");
                            break;
                        }
                    }
                } else if (i < 0) {
                    n = x.getRight(store);
                } else if (i > 0) {
                    n = x.getLeft(store);
                }
                if (n == null) break;
                x = n;
            }
            if (session == null) {
                NodeAVL nodeAVL = result;
                return nodeAVL;
            }
            while (result != null) {
                indexTimeMonitor.check();
                currentRow = result.getRow(store);
                if (session.dataspaceStore.txManager.canRead(session, currentRow, readMode, this.colIndex)) break;
                NodeAVL nodeAVL = result = reversed ? this.last(store, result) : this.next(store, result);
                if (result == null) break;
                currentRow = result.getRow(store);
                if (fieldCount <= 0 || this.compareRowNonUnique(session, currentRow.getData(), rowdata, rowColMap, fieldCount) == 0) continue;
                result = null;
                break;
            }
            NodeAVL nodeAVL = result;
            return nodeAVL;
        }
        finally {
            store.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeAVL findNode(Session session, PersistentStore store, Object data, int compareType, int readMode) {
        store.readLock();
        try {
            NodeAVL x = this.getAccessor(store);
            NodeAVL n = null;
            NodeAVL result = null;
            Row currentRow = null;
            IndexTimeMonitor indexTimeMonitor = this.createIndexTimeMonitor();
            while (x != null) {
                indexTimeMonitor.check();
                currentRow = x.getRow(store);
                int i = this.colTypes[0].compare(session, data, currentRow.getData()[this.colIndex[0]]);
                switch (compareType) {
                    case 41: 
                    case 47: {
                        if (i == 0) {
                            result = x;
                            n = x.getLeft(store);
                            break;
                        }
                        if (i > 0) {
                            n = x.getRight(store);
                            break;
                        }
                        if (i >= 0) break;
                        n = x.getLeft(store);
                        break;
                    }
                    case 43: 
                    case 48: {
                        if (i >= 0) {
                            n = x.getRight(store);
                            break;
                        }
                        result = x;
                        n = x.getLeft(store);
                        break;
                    }
                    case 42: {
                        if (i > 0) {
                            n = x.getRight(store);
                            break;
                        }
                        result = x;
                        n = x.getLeft(store);
                        break;
                    }
                    default: {
                        Error.runtimeError(201, "Index");
                    }
                }
                if (n == null) break;
                x = n;
            }
            if (session == null) {
                NodeAVL nodeAVL = result;
                return nodeAVL;
            }
            while (result != null) {
                indexTimeMonitor.check();
                currentRow = result.getRow(store);
                if (session.dataspaceStore.txManager.canRead(session, currentRow, readMode, this.colIndex)) break;
                result = this.next(store, result);
                if (compareType != 41 || this.colTypes[0].compare(session, data, currentRow.getData()[this.colIndex[0]]) == 0) continue;
                result = null;
                break;
            }
            NodeAVL nodeAVL = result;
            return nodeAVL;
        }
        finally {
            store.readUnlock();
        }
    }

    void balance(PersistentStore store, NodeAVL x, boolean isleft) {
        IndexTimeMonitor indexTimeMonitor = this.createIndexTimeMonitor();
        while (true) {
            indexTimeMonitor.check();
            int sign = isleft ? 1 : -1;
            switch (x.getBalance(store) * sign) {
                case 1: {
                    x = x.setBalance(store, 0);
                    return;
                }
                case 0: {
                    x = x.setBalance(store, -sign);
                    break;
                }
                case -1: {
                    NodeAVL l = x.child(store, isleft);
                    if (l.getBalance(store) == -sign) {
                        x.replace(store, this, l);
                        x = x.set(store, isleft, l.child(store, !isleft));
                        l = l.set(store, !isleft, x);
                        x = x.setBalance(store, 0);
                        l = l.setBalance(store, 0);
                    } else {
                        NodeAVL r = l.child(store, !isleft);
                        x.replace(store, this, r);
                        l = l.set(store, !isleft, r.child(store, isleft));
                        r = r.set(store, isleft, l);
                        x = x.set(store, isleft, r.child(store, !isleft));
                        r = r.set(store, !isleft, x);
                        int rb = r.getBalance(store);
                        x = x.setBalance(store, rb == -sign ? sign : 0);
                        l = l.setBalance(store, rb == sign ? -sign : 0);
                        r = r.setBalance(store, 0);
                    }
                    return;
                }
            }
            if (x.isRoot(store)) {
                return;
            }
            isleft = x.isFromLeft(store);
            x = x.getParent(store);
        }
    }

    NodeAVL getAccessor(PersistentStore store) {
        NodeAVL node = (NodeAVL)store.getAccessor(this);
        return node;
    }

    IndexRowIterator getIterator(Session session, PersistentStore store, NodeAVL x, boolean single, boolean reversed) {
        if (x == null) {
            return emptyIterator;
        }
        IndexRowIterator it = new IndexRowIterator(session, store, this, x, 0, single, reversed);
        return it;
    }

    @Override
    public boolean isBuilt() {
        return true;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    private IndexTimeMonitor createIndexTimeMonitor() {
        return new IndexTimeMonitor(this.getIndexNameWithParent(), this.indexOperationMaxTimeMs);
    }

    private String getIndexNameWithParent() {
        if (this.indexNameWithParent == null) {
            this.indexNameWithParent = this.name != null ? (this.name.parent != null ? this.name.parent.getSchemaQualifiedStatementName() + "." + this.name.name : (this.table instanceof Table && ((Table)this.table).getObjectName() != null ? ((Table)this.table).getObjectName().getSchemaQualifiedStatementName() + "." + this.name.name : this.name.name)) : "unknown";
        }
        return this.indexNameWithParent;
    }

    public static final class IndexRowIterator
    implements RowIterator {
        final Session session;
        final PersistentStore store;
        final IndexAVL index;
        NodeAVL nextnode;
        Row lastrow;
        int distinctCount;
        boolean single;
        boolean reversed;

        public IndexRowIterator(Session session, PersistentStore store, IndexAVL index, NodeAVL node, int distinctCount, boolean single, boolean reversed) {
            this.session = session;
            this.store = store;
            this.index = index;
            this.distinctCount = distinctCount;
            this.single = single;
            this.reversed = reversed;
            if (index == null) {
                return;
            }
            this.nextnode = node;
        }

        @Override
        public boolean hasNext() {
            return this.nextnode != null;
        }

        @Override
        public Row getNextRow() {
            if (this.nextnode == null) {
                this.release();
                return null;
            }
            NodeAVL lastnode = this.nextnode;
            if (this.single) {
                this.nextnode = null;
            } else {
                this.store.readLock();
                try {
                    this.nextnode = this.reversed ? this.index.last(this.session, this.store, this.nextnode, this.distinctCount) : this.index.next(this.session, this.store, this.nextnode, this.distinctCount);
                }
                finally {
                    this.store.readUnlock();
                }
            }
            this.lastrow = lastnode.getRow(this.store);
            return this.lastrow;
        }

        @Override
        public Object[] getNext() {
            Row row = this.getNextRow();
            return row == null ? null : row.getData();
        }

        @Override
        public void remove() {
            this.store.delete(this.session, this.lastrow);
            this.store.remove(this.lastrow.getPos());
        }

        @Override
        public void release() {
        }

        @Override
        public boolean setRowColumns(boolean[] columns) {
            return false;
        }

        @Override
        public long getRowId() {
            return this.nextnode.getPos();
        }
    }
}

