/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.fulltext.lucene.highlight;

import com.streamscape.ds.persist.fulltext.lucene.highlight.WeightedTerm;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;

public final class QueryTermExtractor {
    private static final IndexSearcher EMPTY_INDEXSEARCHER;

    public static final WeightedTerm[] getTerms(Query query) {
        return QueryTermExtractor.getTerms(query, false);
    }

    public static final WeightedTerm[] getIdfWeightedTerms(Query query, IndexReader reader, String fieldName) {
        WeightedTerm[] terms = QueryTermExtractor.getTerms(query, false, fieldName);
        int totalNumDocs = reader.maxDoc();
        for (int i = 0; i < terms.length; ++i) {
            try {
                int docFreq = reader.docFreq(new Term(fieldName, terms[i].term));
                float idf = (float)(Math.log((double)totalNumDocs / (double)(docFreq + 1)) + 1.0);
                terms[i].weight *= idf;
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return terms;
    }

    public static WeightedTerm[] getTerms(Query query, boolean prohibited, String fieldName) {
        HashSet<WeightedTerm> terms = new HashSet<WeightedTerm>();
        Predicate<String> fieldSelector = fieldName == null ? f -> true : fieldName::equals;
        query.visit((QueryVisitor)new BoostedTermExtractor(1.0f, terms, prohibited, fieldSelector));
        return terms.toArray(new WeightedTerm[0]);
    }

    public static final WeightedTerm[] getTerms(Query query, boolean prohibited) {
        return QueryTermExtractor.getTerms(query, prohibited, null);
    }

    static {
        try {
            MultiReader emptyReader = new MultiReader(new IndexReader[0]);
            EMPTY_INDEXSEARCHER = new IndexSearcher((IndexReader)emptyReader);
            EMPTY_INDEXSEARCHER.setQueryCache(null);
        }
        catch (IOException bogus) {
            throw new RuntimeException(bogus);
        }
    }

    private static class BoostedTermExtractor
    extends QueryVisitor {
        final float boost;
        final Set<WeightedTerm> terms;
        final boolean includeProhibited;
        final Predicate<String> fieldSelector;

        private BoostedTermExtractor(float boost, Set<WeightedTerm> terms, boolean includeProhibited, Predicate<String> fieldSelector) {
            this.boost = boost;
            this.terms = terms;
            this.includeProhibited = includeProhibited;
            this.fieldSelector = fieldSelector;
        }

        public boolean acceptField(String field) {
            return this.fieldSelector.test(field);
        }

        public void consumeTerms(Query query, Term ... terms) {
            for (Term term : terms) {
                this.terms.add(new WeightedTerm(this.boost, term.text()));
            }
        }

        public QueryVisitor getSubVisitor(BooleanClause.Occur occur, Query parent) {
            if (parent instanceof BoostQuery) {
                float newboost = this.boost * ((BoostQuery)parent).getBoost();
                return new BoostedTermExtractor(newboost, this.terms, this.includeProhibited, this.fieldSelector);
            }
            if (occur == BooleanClause.Occur.MUST_NOT && !this.includeProhibited) {
                return QueryVisitor.EMPTY_VISITOR;
            }
            return this;
        }
    }
}

