/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.fulltext.lucene;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;

public class LuceneUtils {
    public static String getIndexFormat(final Directory dir) throws IOException {
        return (String)new SegmentInfos.FindSegmentsFile<String>(dir){

            protected String doBody(String segmentFileName) throws IOException {
                String format = "unknown";
                try (IndexInput in = dir.openInput(segmentFileName, IOContext.READ);){
                    if (1071082519 == in.readInt()) {
                        int actualVersion = CodecUtil.checkHeaderNoMagic((DataInput)in, (String)"segments", (int)7, (int)Integer.MAX_VALUE);
                        if (actualVersion == 7) {
                            format = "Lucene 7.0 or later";
                        } else if (actualVersion == 8) {
                            format = "Lucene 7.2 or later";
                        } else if (actualVersion == 9) {
                            format = "Lucene 7.4 or later";
                        } else if (actualVersion >= 10) {
                            format = "Lucene 8.6 or later";
                        }
                    } else {
                        format = "Lucene 5.x or prior (UNSUPPORTED)";
                    }
                }
                return format;
            }
        }.run();
    }

    public static Map<String, Long> countTerms(IndexReader reader, Collection<String> fields) throws IOException {
        HashMap<String, Long> res = new HashMap<String, Long>();
        for (String field : fields) {
            Terms terms;
            if (!res.containsKey(field)) {
                res.put(field, 0L);
            }
            if ((terms = MultiTerms.getTerms((IndexReader)reader, (String)field)) == null) continue;
            TermsEnum te = terms.iterator();
            while (te.next() != null) {
                res.put(field, (Long)res.get(field) + 1L);
            }
        }
        return res;
    }

    public static Long getTermsCount(IndexReader reader) throws IOException {
        return LuceneUtils.countTerms(reader, LuceneUtils.getFieldNames(reader)).values().stream().mapToLong(Long::longValue).sum();
    }

    public static Collection<String> getFieldNames(IndexReader reader) {
        return StreamSupport.stream(LuceneUtils.getFieldInfos(reader).spliterator(), false).map(f -> f.name).collect(Collectors.toList());
    }

    public static FieldInfos getFieldInfos(IndexReader reader) {
        if (reader instanceof LeafReader) {
            return ((LeafReader)reader).getFieldInfos();
        }
        return FieldInfos.getMergedFieldInfos((IndexReader)reader);
    }

    public static String escapeQueryString(String query) {
        return query.replace("\"", "\\\"");
    }
}

