/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.fulltext.lucene;

import com.streamscape.ds.persist.fulltext.lucene.LuceneUtils;
import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.lucene.index.IndexReader;

public class LuceneTermCounts {
    private final Map<String, Long> termCountMap;

    public LuceneTermCounts(IndexReader reader) throws IOException {
        this.termCountMap = LuceneUtils.countTerms(reader, LuceneUtils.getFieldNames(reader));
    }

    public long getTotalCount() {
        return this.termCountMap.values().stream().mapToLong(Long::longValue).sum();
    }

    public Map<String, Long> getFieldCounts() {
        Comparator<Map.Entry<String, Long>> comparator = Map.Entry.comparingByKey();
        return this.sortedTermCounts(comparator);
    }

    private Map<String, Long> sortedTermCounts(Comparator<Map.Entry<String, Long>> comparator) {
        return this.termCountMap.entrySet().stream().sorted(comparator).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1, LinkedHashMap::new));
    }
}

