/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.fulltext.lucene;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.navigator.RowSetNavigatorClient;
import com.streamscape.ds.persist.DataspaceStoreProperties;
import com.streamscape.ds.persist.fulltext.CollectionColumn;
import com.streamscape.ds.persist.fulltext.DocumentIndex;
import com.streamscape.ds.persist.fulltext.DocumentResultSet;
import com.streamscape.ds.persist.fulltext.FullTextIndex;
import com.streamscape.ds.persist.fulltext.FullTextManager;
import com.streamscape.ds.persist.fulltext.FullTextQuery;
import com.streamscape.ds.persist.fulltext.FullTextSerializer;
import com.streamscape.ds.persist.fulltext.FullTextTableIndex;
import com.streamscape.ds.persist.fulltext.FullTextUtils;
import com.streamscape.ds.persist.fulltext.IndexColumn;
import com.streamscape.ds.persist.fulltext.lucene.LuceneBM25Similarity;
import com.streamscape.ds.persist.fulltext.lucene.LuceneTermCounts;
import com.streamscape.ds.persist.fulltext.lucene.LuceneUtils;
import com.streamscape.ds.persist.fulltext.lucene.highlight.Highlighter;
import com.streamscape.ds.persist.fulltext.lucene.highlight.QueryScorer;
import com.streamscape.ds.persist.fulltext.lucene.highlight.SimpleHTMLFormatter;
import com.streamscape.ds.persist.fulltext.lucene.highlight.SimpleSpanFragmenter;
import com.streamscape.ds.persist.fulltext.lucene.highlight.TextFragmentsResult;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.FlobDataID;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.parser.ParseProcessor;
import com.streamscape.slex.lang.parameter.DateParameter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.tika.Tika;

public class LuceneDocumentIndex
implements DocumentIndex {
    private DataspaceStore dataspaceStore;
    private NameManager.ObjectName indexName;
    private IndexWriter indexWriter;
    private static String TABLE_FIELD = "TABLE";
    private static String COLUMN_FIELD = "COLUMN";
    private static String DATA_FIELD = "DATA";
    private static String PK_FIELD = "PK";
    private static String SYS_CREATED_FILE_NAME = "sys_created";
    private static String SYS_MODIFIED_FILE_NAME = "sys_modified";
    private static int DEFAULT_MAX_LIMIT = 1000;
    private Tika tika;
    private Directory store;
    private DocumentIndex.StoreType storeType;

    public LuceneDocumentIndex(DataspaceStore dataspaceStore, NameManager.ObjectName indexName, DocumentIndex.StoreType storeType) {
        try {
            this.dataspaceStore = dataspaceStore;
            this.indexName = indexName;
            this.storeType = storeType;
            this.initDirectory();
            this.initIndexWriter();
        }
        catch (Exception e) {
            throw new DataspaceException("Cannot initialize Lucene Index Writer; " + e.getMessage(), e);
        }
    }

    private IndexWriter retrieveIndexWriter() throws IOException {
        if (this.validateIndexWriter()) {
            return this.indexWriter;
        }
        Trace.logError(this, "IndexWriter unexpectedly closed.");
        return this.initIndexWriter();
    }

    private boolean validateIndexWriter() {
        return this.indexWriter != null && this.indexWriter.isOpen();
    }

    private IndexWriter initIndexWriter() throws IOException {
        StandardAnalyzer analyzer = new StandardAnalyzer();
        IndexWriterConfig iwc = new IndexWriterConfig((Analyzer)analyzer);
        iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        DataspaceStoreProperties props = this.dataspaceStore.getProperties();
        iwc.setMaxBufferedDocs(props.getIntegerProperty("text.engine.max_buffered_docs"));
        iwc.setRAMBufferSizeMB((double)props.getIntegerProperty("text.engine.ram_buffered_size"));
        iwc.setRAMPerThreadHardLimitMB(props.getIntegerProperty("text.engine.ram_per_thread_hard_limit"));
        iwc.setReaderPooling(props.isPropertyTrue("text.engine.reader_pooling"));
        iwc.setUseCompoundFile(props.isPropertyTrue("text.engine.use_compound_file"));
        this.indexWriter = new IndexWriter(this.store, new IndexWriterConfig());
        this.indexWriter.close();
        this.indexWriter = new IndexWriter(this.store, iwc);
        return this.indexWriter;
    }

    private void initDirectory() throws IOException {
        if (this.storeType.equals((Object)DocumentIndex.StoreType.PERSISTENT)) {
            this.initDataSpaceDirectory();
            this.store = FSDirectory.open((Path)this.initIndexDirectory());
        } else {
            this.store = new RAMDirectory();
        }
    }

    @Override
    public void insert(Session session, Object[] newData, Table table, FullTextIndex index) throws Exception {
        FullTextTableIndex tableIndex = index.getTableIndex(table);
        List<IndexColumn> columns = tableIndex.getIndexColumns();
        for (IndexColumn tColumn : columns) {
            int columnIndex = tColumn.getIndex();
            Document doc = new Document();
            String tableName = table.getObjectName().name;
            doc.add((IndexableField)new TextField(TABLE_FIELD, tableName, Field.Store.YES));
            doc.add((IndexableField)new TextField(PK_FIELD, this.getPKString(table, newData), Field.Store.YES));
            ColumnSchema column = tableIndex.getTable().getColumn(columnIndex);
            String value = null;
            switch (column.getDataType().getSQLGenericTypeCode()) {
                case 1119: {
                    FlobDataID dataID = (FlobDataID)newData[columnIndex];
                    String flobPath = FullTextUtils.getFlobPath(session, dataID);
                    try (FileSystem fileSystem = session.dataspaceStore.flobManager.getFlobFileManager().createFileSystem(flobPath);
                         InputStream inputStream = fileSystem.open(flobPath);){
                        value = ParseProcessor.getText(inputStream);
                    }
                    Trace.logDebug(this, value);
                    break;
                }
                case 1111: {
                    Object o = OtherTypeWrapper.unwrap(newData[columnIndex]);
                    if (tColumn.getSpath() != null) {
                        try {
                            o = session.sessionContext.sdrManager.getValueAtPath(tColumn.getSpath(), o);
                        }
                        catch (Exception ex) {
                            o = null;
                        }
                    }
                    value = FullTextUtils.serialize(o);
                    if (!index.isExplicitCollection()) break;
                    Object mapValue = FullTextSerializer.getSerializer().deserialize("object", value);
                    FullTextUtils.processExplicitCollections(mapValue, null, null, null);
                    value = FullTextUtils.mserialize(mapValue);
                    break;
                }
                default: {
                    if (newData[columnIndex] == null) break;
                    value = newData[columnIndex].toString();
                }
            }
            if ((value = StringUtils.trimToNull(value)) == null) continue;
            if (tColumn.getFilter() != null) {
                value = tColumn.getFilter().apply(value);
            }
            String columnName = tColumn.getFullPath();
            doc.add((IndexableField)new TextField(COLUMN_FIELD, tableName + "." + columnName, Field.Store.YES));
            doc.add((IndexableField)new TextField(DATA_FIELD, value, Field.Store.YES));
            this.retrieveIndexWriter().addDocument((Iterable)doc);
        }
    }

    @Override
    public void batchInsert(Session session, List<Object[]> newData, Table table, FullTextIndex index) throws Exception {
        for (Object[] record : newData) {
            this.insert(session, record, table, index);
        }
    }

    @Override
    public void delete(Object[] oldData, Table table, FullTextIndex index) throws Exception {
        QueryParser parser = new QueryParser(null, this.indexWriter.getAnalyzer());
        String queryStr = this.buildDeleteQuery(table, oldData);
        Query query = parser.parse(queryStr);
        this.retrieveIndexWriter().deleteDocuments(new Query[]{query});
    }

    private String buildDeleteQuery(Table table, Object[] row) throws Exception {
        return TABLE_FIELD + ":\"" + table.getObjectName().name + "\" AND " + PK_FIELD + ":\"" + LuceneUtils.escapeQueryString(this.getPKString(table, row)) + "\"";
    }

    @Override
    public void update(Session session, Object[] oldData, Object[] newData, Table table, FullTextIndex index) throws Exception {
        this.delete(oldData, table, index);
        this.insert(session, newData, table, index);
    }

    private IndexReader getReader() throws IOException {
        return DirectoryReader.open((IndexWriter)this.indexWriter);
    }

    private String buildSearchQuery(List<CollectionColumn> columns, FullTextQuery fullTextQuery) {
        ArrayList<CallSite> subQueries = new ArrayList<CallSite>();
        for (CollectionColumn collectionColumn : columns) {
            subQueries.add((CallSite)((Object)(COLUMN_FIELD + ":\"" + FullTextUtils.getFullColumnName(collectionColumn) + "\"")));
        }
        String expression = fullTextQuery.isMatchType() ? "(" + fullTextQuery.getQueryString() + ")" : "\"" + fullTextQuery.getQueryString() + "\"";
        return DATA_FIELD + ":" + expression + " AND (" + String.join((CharSequence)" OR ", subQueries) + ")";
    }

    private String getPKString(Table table, Object[] row) throws Exception {
        ArrayList<Object> res = new ArrayList<Object>();
        int[] pkCols = table.getPrimaryKey();
        for (int i = 0; i < pkCols.length; ++i) {
            res.add(row[pkCols[i]]);
        }
        return FullTextUtils.serialize(res);
    }

    @Override
    public void deleteAll() throws Exception {
        this.retrieveIndexWriter().deleteAll();
    }

    @Override
    public void deleteAll(Table table) throws Exception {
        QueryParser parser = new QueryParser(null, this.indexWriter.getAnalyzer());
        String queryStr = TABLE_FIELD + ":\"" + table.getObjectName().name + "\"";
        Query query = parser.parse(queryStr);
        this.retrieveIndexWriter().deleteDocuments(new Query[]{query});
        this.commit();
    }

    @Override
    public void addSpecificProperties(Result result) {
        try (IndexReader indexReader = this.getReader();){
            RowSetNavigator navigator = result.navigator;
            Directory directory = this.indexWriter.getDirectory();
            LuceneTermCounts termCounts = new LuceneTermCounts(indexReader);
            if (directory instanceof FSDirectory) {
                navigator.add(new Object[]{"Index Path", ((FSDirectory)directory).getDirectory().toString()});
            }
            navigator.add(new Object[]{"Number of Documents", indexReader.numDocs()});
            String format = "n/a";
            try {
                format = LuceneUtils.getIndexFormat(directory);
            }
            catch (Exception exception) {
                // empty catch block
            }
            navigator.add(new Object[]{"Index Format", format});
            navigator.add(new Object[]{"Directory Implementation", directory.getClass().getName()});
            navigator.add(new Object[]{"Number of Terms", termCounts.getTotalCount()});
            if (directory instanceof FSDirectory) {
                String created = this.getCreatedDate() != null ? DateParameter.formatDate(this.getCreatedDate().getTime()) : "n/a";
                navigator.add(new Object[]{"Created On", created});
                String modified = this.getModifiedDate() != null ? DateParameter.formatDate(this.getModifiedDate().getTime()) : "n/a";
                navigator.add(new Object[]{"Modified On", modified});
            }
        }
        catch (Exception e) {
            Trace.logException(this, e, true);
            throw new DataspaceException("Error while adding specific properties");
        }
    }

    @Override
    public Result getTupleStatistics() {
        Result result;
        block8: {
            IndexReader indexReader = this.getReader();
            try {
                ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.SQL_BIGINT, Type.SQL_FLOAT}, new String[]{"Tuple", "Number of Terms", "Percentage"});
                RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                Result result2 = Result.newDataResult(metaData);
                result2.setNavigator(navigator);
                LuceneTermCounts termCounts = new LuceneTermCounts(indexReader);
                long totalTermNumber = termCounts.getTotalCount();
                termCounts.getFieldCounts().forEach((fieldName, count) -> navigator.add(new Object[]{fieldName, count, Float.valueOf((float)count.longValue() / (float)totalTermNumber * 100.0f)}));
                result = result2;
                if (indexReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (indexReader != null) {
                        try {
                            indexReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new DataspaceException("Error while getting index reader");
                }
            }
            indexReader.close();
        }
        return result;
    }

    private Path initDataSpaceDirectory() {
        try {
            Path dir = Paths.get(FullTextManager.FULL_TEXT_DIR, this.indexName.schema.getNameString());
            if (!Files.exists(dir, new LinkOption[0])) {
                Files.createDirectory(dir, new FileAttribute[0]);
            }
            return dir;
        }
        catch (Exception e) {
            throw new DataspaceException("Failed create directory for dataspace.");
        }
    }

    private Path initIndexDirectory() {
        try {
            Path dir = Paths.get(this.indexFolder(), new String[0]);
            if (!Files.exists(dir, new LinkOption[0])) {
                Files.createDirectory(dir, new FileAttribute[0]);
                this.setCreatedTime();
                this.setModifiedTime();
            }
            return dir;
        }
        catch (Exception e) {
            throw new DataspaceException("Cannot create directory for the index.");
        }
    }

    private String indexFolder() {
        return FullTextManager.FULL_TEXT_DIR + "/" + this.indexName.schema.getNameString() + "/" + this.indexName.getNameString();
    }

    private static String indexFolder(NameManager.ObjectName idxName) {
        return FullTextManager.FULL_TEXT_DIR + "/" + idxName.schema.getNameString() + "/" + idxName.getNameString();
    }

    public static void removeIndexFolder(NameManager.ObjectName indexName) throws IOException {
        FileUtils.deleteDirectory(new File(LuceneDocumentIndex.indexFolder(indexName)));
    }

    @Override
    public DocumentResultSet search(List<CollectionColumn> columns, FullTextQuery fullTextQuery) {
        DocumentResultSet documentResultSet;
        block14: {
            DocumentResultSet resultSet = new DocumentResultSet();
            QueryParser parser = new QueryParser(null, this.indexWriter.getAnalyzer());
            parser.setAllowLeadingWildcard(true);
            IndexReader indexReader = this.getReader();
            try {
                List<CollectionColumn> columnsWithNOTOperands;
                Query query = parser.parse(this.buildSearchQuery(columns, fullTextQuery));
                IndexSearcher searcher = new IndexSearcher(indexReader);
                LuceneBM25Similarity similarity = new LuceneBM25Similarity();
                similarity.setEnableIdfFactor(fullTextQuery.isEnableIdfFactor());
                similarity.setEnableTfFactor(fullTextQuery.isEnableTfFactor());
                similarity.setEnableLengthNormFactor(fullTextQuery.isEnableLengthNormFactor());
                searcher.setSimilarity((Similarity)similarity);
                int queryMaxLimit = DEFAULT_MAX_LIMIT;
                if (fullTextQuery.getTop() > 0) {
                    queryMaxLimit = fullTextQuery.getTop();
                }
                TopDocs topDocs = searcher.search(query, queryMaxLimit);
                ScoreDoc[] hits = topDocs.scoreDocs;
                Highlighter highlighter = this.retrieveHighlighter(query);
                long totalHits = Math.min(topDocs.totalHits.value, (long)hits.length);
                int i = 0;
                while ((long)i < totalHits) {
                    int docId = hits[i].doc;
                    Document doc = searcher.doc(docId);
                    String pk = doc.get(PK_FIELD);
                    Pair<String, String> columnPair = FullTextUtils.parseFullColumnName(doc.get(COLUMN_FIELD));
                    ExplainData explain = new ExplainData(searcher.explain(query, docId));
                    String text = doc.get(DATA_FIELD);
                    TokenStream tokenStream = this.indexWriter.getAnalyzer().tokenStream(DATA_FIELD, text);
                    TextFragmentsResult fragResult = highlighter.getBestTextFragments(tokenStream, text, true, 5);
                    resultSet.addRow(doc.get(TABLE_FIELD), pk, (List)FullTextUtils.deserialize(pk), (String)columnPair.second, explain.getScore(), this.indexName.name, fragResult.getEntries(), fragResult.getFragmentString(), explain.getTf(), explain.getIdf(), explain.getLengthNorm());
                    ++i;
                }
                List<CollectionColumn> columnsWithANDOperands = this.columnsWithAND(columns);
                if (!columnsWithANDOperands.isEmpty()) {
                    Set columnNames = columnsWithANDOperands.stream().map(c -> c.getColumn().getNameString()).collect(Collectors.toSet());
                    Map<String, List<DocumentResultSet.ResultRow>> indexedResultSet = this.indexResultSetByPK(resultSet);
                    for (String pk : indexedResultSet.keySet()) {
                        List<DocumentResultSet.ResultRow> pkRows = indexedResultSet.get(pk);
                        List foundRows = pkRows.stream().filter(r -> columnNames.contains(r.getColumnName())).collect(Collectors.toList());
                        if (foundRows.size() == columnNames.size()) continue;
                        resultSet.removeAllRows(foundRows);
                    }
                }
                if (!(columnsWithNOTOperands = this.columnsWithNOT(columns)).isEmpty()) {
                    Set columnNames = columnsWithNOTOperands.stream().map(c -> c.getColumn().getNameString()).collect(Collectors.toSet());
                    Map<String, List<DocumentResultSet.ResultRow>> indexedResultSet = this.indexResultSetByPK(resultSet);
                    for (String pk : indexedResultSet.keySet()) {
                        List<DocumentResultSet.ResultRow> pkRows = indexedResultSet.get(pk);
                        List foundRows = pkRows.stream().filter(r -> columnNames.contains(r.getColumnName())).collect(Collectors.toList());
                        if (foundRows.size() == 0) continue;
                        resultSet.removeAllRows(pkRows);
                    }
                }
                documentResultSet = resultSet;
                if (indexReader == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (indexReader != null) {
                        try {
                            indexReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Trace.logException(this, e, true);
                    throw new DataspaceException("Wrong query");
                }
            }
            indexReader.close();
        }
        return documentResultSet;
    }

    private Map<String, List<DocumentResultSet.ResultRow>> indexResultSetByPK(DocumentResultSet resultSet) {
        HashMap<String, List<DocumentResultSet.ResultRow>> result = new HashMap<String, List<DocumentResultSet.ResultRow>>();
        for (DocumentResultSet.ResultRow row : resultSet.getRows()) {
            if (!result.containsKey(row.getPkString())) {
                result.put(row.getPkString(), new ArrayList());
            }
            ((List)result.get(row.getPkString())).add(row);
        }
        return result;
    }

    private List<CollectionColumn> columnsWithAND(List<CollectionColumn> columns) {
        return columns.stream().filter(col -> col.getOperand().equals((Object)CollectionColumn.ColumnOperand.AND)).collect(Collectors.toList());
    }

    private List<CollectionColumn> columnsWithNOT(List<CollectionColumn> columns) {
        return columns.stream().filter(col -> col.getOperand().equals((Object)CollectionColumn.ColumnOperand.NOT)).collect(Collectors.toList());
    }

    private Highlighter retrieveHighlighter(Query query) {
        SimpleHTMLFormatter formatter = new SimpleHTMLFormatter("<b>", "</b>");
        QueryScorer scorer = new QueryScorer(query);
        Highlighter highlighter = new Highlighter(formatter, scorer);
        SimpleSpanFragmenter fragmenter = new SimpleSpanFragmenter(scorer, 10);
        highlighter.setTextFragmenter(fragmenter);
        return highlighter;
    }

    @Override
    public long commit() throws IOException {
        IndexWriter iw = this.retrieveIndexWriter();
        boolean hasChanges = iw.hasUncommittedChanges();
        long last = iw.commit();
        if (hasChanges) {
            this.setModifiedTime();
        }
        return last;
    }

    @Override
    public void rollback() throws IOException {
        if (!this.validateIndexWriter()) {
            Trace.logError(this, "IndexWriter unexpectedly closed. Rollback failed");
        } else {
            this.indexWriter.rollback();
        }
        this.initIndexWriter();
    }

    @Override
    public void removeDirectory() throws IOException {
        this.indexWriter.close();
        FileIOUtils.deleteFileDir(new File(this.indexFolder()));
    }

    @Override
    public void release() throws IOException {
        this.indexWriter.close();
    }

    @Override
    public Path getIndexPath() {
        if (this.store instanceof FSDirectory) {
            return ((FSDirectory)this.store).getDirectory();
        }
        return null;
    }

    @Override
    public String getIndexFormat() {
        try {
            return LuceneUtils.getIndexFormat(this.store);
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    private void setCreatedTime() {
        try {
            FileUtils.write(new File(this.indexFolder(), SYS_CREATED_FILE_NAME), String.valueOf(new Date().getTime()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setModifiedTime() {
        try {
            FileUtils.write(new File(this.indexFolder(), SYS_MODIFIED_FILE_NAME), String.valueOf(new Date().getTime()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Date getCreatedDate() {
        try {
            String ts = FileUtils.readFileToString(new File(this.indexFolder(), SYS_CREATED_FILE_NAME));
            return new Date(Long.parseLong(ts));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Date getModifiedDate() {
        try {
            String ts = FileUtils.readFileToString(new File(this.indexFolder(), SYS_MODIFIED_FILE_NAME));
            return new Date(Long.parseLong(ts));
        }
        catch (Exception e) {
            return null;
        }
    }

    private Tika getTika() {
        if (this.tika == null) {
            this.tika = new Tika();
        }
        return this.tika;
    }

    @Override
    public void close() {
        try {
            this.indexWriter.close();
        }
        catch (IOException e) {
            throw new DataspaceException("Unable to close text index: " + this.indexName.name);
        }
    }

    static class ExplainData {
        private float freq;
        private float tf;
        private float idf;
        private float lengthNorm;
        private float score;

        public ExplainData(Explanation explain) {
            this.processDetails(explain.getDetails()[0]);
        }

        private void processDetails(Explanation explanation) {
            this.score = 1.0f;
            this.idf = 1.0f;
            this.freq = 1.0f;
            this.lengthNorm = 1.0f;
            this.tf = 1.0f;
            if (explanation.getDetails().length == 0) {
                return;
            }
            Explanation termExplain = explanation.getDetails()[0];
            this.score = termExplain.getValue().floatValue();
            for (Explanation expl : termExplain.getDetails()) {
                String desc = expl.getDescription();
                if (desc.startsWith("idf")) {
                    this.idf = expl.getValue().floatValue();
                    continue;
                }
                if (!desc.startsWith("tf")) continue;
                this.tf = expl.getValue().floatValue();
                float k1 = 1.0f;
                float b = 1.0f;
                float dl = 1.0f;
                float avgdl = 1.0f;
                for (Explanation subExpl : expl.getDetails()) {
                    float subVal = subExpl.getValue().floatValue();
                    String subDesc = subExpl.getDescription();
                    if (subDesc.startsWith("freq,")) {
                        this.freq = subVal;
                        continue;
                    }
                    if (subDesc.startsWith("k1,")) {
                        k1 = subVal;
                        continue;
                    }
                    if (subDesc.startsWith("b,")) {
                        b = subVal;
                        continue;
                    }
                    if (subDesc.startsWith("dl,")) {
                        dl = subVal;
                        continue;
                    }
                    if (!subDesc.startsWith("avgdl,")) continue;
                    avgdl = subVal;
                }
                this.lengthNorm = k1 * (1.0f - b + b * dl / avgdl);
            }
        }

        public float getFreq() {
            return this.freq;
        }

        public float getIdf() {
            return this.idf;
        }

        public float getLengthNorm() {
            return this.lengthNorm;
        }

        public float getScore() {
            return this.score;
        }

        public float getTf() {
            return this.tf;
        }
    }
}

