/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.fulltext.lucene;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SmallFloat;

public class LuceneBM25Similarity
extends Similarity {
    private final float k1;
    private final float b;
    private boolean enableTfFactor = true;
    private boolean enableIdfFactor = true;
    private boolean enableLengthNormFactor = true;
    protected boolean discountOverlaps = true;
    private static final float[] LENGTH_TABLE = new float[256];

    public LuceneBM25Similarity(float k1, float b) {
        if (!Float.isFinite(k1) || k1 < 0.0f) {
            throw new IllegalArgumentException("illegal k1 value: " + k1 + ", must be a non-negative finite value");
        }
        if (Float.isNaN(b) || b < 0.0f || b > 1.0f) {
            throw new IllegalArgumentException("illegal b value: " + b + ", must be between 0 and 1");
        }
        this.k1 = k1;
        this.b = b;
    }

    public LuceneBM25Similarity() {
        this(1.2f, 0.75f);
    }

    protected float idf(long docFreq, long docCount) {
        return (float)Math.log(1.0 + ((double)(docCount - docFreq) + 0.5) / ((double)docFreq + 0.5));
    }

    protected float scorePayload(int doc, int start, int end, BytesRef payload) {
        return 1.0f;
    }

    protected float avgFieldLength(CollectionStatistics collectionStats) {
        return (float)((double)collectionStats.sumTotalTermFreq() / (double)collectionStats.docCount());
    }

    public void setDiscountOverlaps(boolean v) {
        this.discountOverlaps = v;
    }

    public boolean getDiscountOverlaps() {
        return this.discountOverlaps;
    }

    public final long computeNorm(FieldInvertState state) {
        int numTerms = state.getIndexOptions() == IndexOptions.DOCS && state.getIndexCreatedVersionMajor() >= 8 ? state.getUniqueTermCount() : (this.discountOverlaps ? state.getLength() - state.getNumOverlap() : state.getLength());
        return SmallFloat.intToByte4((int)numTerms);
    }

    public Explanation idfExplain(CollectionStatistics collectionStats, TermStatistics termStats) {
        long df = termStats.docFreq();
        long docCount = collectionStats.docCount();
        float idf = this.enableIdfFactor ? this.idf(df, docCount) : 1.0f;
        return Explanation.match((Number)Float.valueOf(idf), (String)"idf, computed as log(1 + (N - n + 0.5) / (n + 0.5)) from:", (Explanation[])new Explanation[]{Explanation.match((Number)df, (String)"n, number of documents containing term", (Explanation[])new Explanation[0]), Explanation.match((Number)docCount, (String)"N, total number of documents with field", (Explanation[])new Explanation[0])});
    }

    public Explanation idfExplain(CollectionStatistics collectionStats, TermStatistics[] termStats) {
        double idf = 0.0;
        ArrayList<Explanation> details = new ArrayList<Explanation>();
        for (TermStatistics stat : termStats) {
            Explanation idfExplain = this.idfExplain(collectionStats, stat);
            details.add(idfExplain);
            idf += (double)idfExplain.getValue().floatValue();
        }
        return Explanation.match((Number)Float.valueOf((float)idf), (String)"idf, sum of:", details);
    }

    public final Similarity.SimScorer scorer(float boost, CollectionStatistics collectionStats, TermStatistics ... termStats) {
        Explanation idf = termStats.length == 1 ? this.idfExplain(collectionStats, termStats[0]) : this.idfExplain(collectionStats, termStats);
        float avgdl = this.avgFieldLength(collectionStats);
        float[] cache = new float[256];
        for (int i = 0; i < cache.length; ++i) {
            cache[i] = 1.0f / (this.k1 * (1.0f - this.b + this.b * LENGTH_TABLE[i] / avgdl));
        }
        return new BM25Scorer(boost, this.k1, this.b, idf, avgdl, cache);
    }

    public String toString() {
        return "BM25(k1=" + this.k1 + ",b=" + this.b + ")";
    }

    public final float getK1() {
        return this.k1;
    }

    public final float getB() {
        return this.b;
    }

    public void setEnableTfFactor(boolean enableTfFactor) {
        this.enableTfFactor = enableTfFactor;
    }

    public void setEnableIdfFactor(boolean enableIdfFactor) {
        this.enableIdfFactor = enableIdfFactor;
    }

    public void setEnableLengthNormFactor(boolean enableLengthNormFactor) {
        this.enableLengthNormFactor = enableLengthNormFactor;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            LuceneBM25Similarity.LENGTH_TABLE[i] = SmallFloat.byte4ToInt((byte)((byte)i));
        }
    }

    private class BM25Scorer
    extends Similarity.SimScorer {
        private final float boost;
        private final float k1;
        private final float b;
        private final Explanation idf;
        private final float avgdl;
        private final float[] cache;
        private final float weight;

        BM25Scorer(float boost, float k1, float b, Explanation idf, float avgdl, float[] cache) {
            this.boost = boost;
            this.idf = idf;
            this.avgdl = avgdl;
            this.k1 = k1;
            this.b = b;
            this.cache = cache;
            this.weight = boost * idf.getValue().floatValue();
        }

        public float score(float freq, long encodedNorm) {
            float normInverse = LuceneBM25Similarity.this.enableLengthNormFactor ? this.cache[(byte)encodedNorm & 0xFF] : 1.0f;
            freq = LuceneBM25Similarity.this.enableTfFactor ? freq : 1.0f;
            return this.weight - this.weight / (1.0f + freq * normInverse);
        }

        public Explanation explain(Explanation freq, long encodedNorm) {
            ArrayList<Explanation> subs = new ArrayList<Explanation>(this.explainConstantFactors());
            Explanation tfExpl = this.explainTF(freq, encodedNorm);
            subs.add(tfExpl);
            float normInverse = this.cache[(byte)encodedNorm & 0xFF];
            return Explanation.match((Number)Float.valueOf(this.weight - this.weight / (1.0f + freq.getValue().floatValue() * normInverse)), (String)("score(freq=" + String.valueOf(freq.getValue()) + "), computed as boost * idf * tf from:"), subs);
        }

        private Explanation explainTF(Explanation freq, long norm) {
            ArrayList<Explanation> subs = new ArrayList<Explanation>();
            subs.add(freq);
            float doclen = LENGTH_TABLE[(byte)norm & 0xFF];
            if (LuceneBM25Similarity.this.enableLengthNormFactor) {
                subs.add(Explanation.match((Number)Float.valueOf(this.k1), (String)"k1, term saturation parameter", (Explanation[])new Explanation[0]));
                subs.add(Explanation.match((Number)Float.valueOf(this.b), (String)"b, length normalization parameter", (Explanation[])new Explanation[0]));
                if ((norm & 0xFFL) > 39L) {
                    subs.add(Explanation.match((Number)Float.valueOf(doclen), (String)"dl, length of field (approximate)", (Explanation[])new Explanation[0]));
                } else {
                    subs.add(Explanation.match((Number)Float.valueOf(doclen), (String)"dl, length of field", (Explanation[])new Explanation[0]));
                }
                subs.add(Explanation.match((Number)Float.valueOf(this.avgdl), (String)"avgdl, average length of field", (Explanation[])new Explanation[0]));
            }
            float normInverse = LuceneBM25Similarity.this.enableLengthNormFactor ? 1.0f / (this.k1 * (1.0f - this.b + this.b * doclen / this.avgdl)) : 1.0f;
            float freqVal = LuceneBM25Similarity.this.enableTfFactor ? freq.getValue().floatValue() : 1.0f;
            return Explanation.match((Number)Float.valueOf(1.0f - 1.0f / (1.0f + freqVal * normInverse)), (String)"tf, computed as freq / (freq + k1 * (1 - b + b * dl / avgdl)) from:", subs);
        }

        private List<Explanation> explainConstantFactors() {
            ArrayList<Explanation> subs = new ArrayList<Explanation>();
            if (this.boost != 1.0f) {
                subs.add(Explanation.match((Number)Float.valueOf(this.boost), (String)"boost", (Explanation[])new Explanation[0]));
            }
            subs.add(this.idf);
            return subs;
        }
    }
}

