/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.fulltext;

import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.table.Table;
import java.util.List;
import java.util.function.Function;

public class IndexColumn {
    private int index;
    private Table table;
    private ColumnSchema columnSchema;
    private Function<String, String> filter;
    private String path;
    private String spath;
    Function<Object, List<String>> valueExtractor;

    public IndexColumn(Table table, int index) {
        this(table, index, null);
    }

    public IndexColumn(Table table, int index, Function<String, String> filter) {
        this.table = table;
        this.index = index;
        this.filter = filter;
        this.columnSchema = table.getColumn(index);
    }

    public IndexColumn(Table table, String columnName) {
        columnName = columnName.trim();
        String[] columnNameTokens = columnName.split("\\.", 2);
        int idx = table.getColumnIndex(columnNameTokens[0]);
        if (columnNameTokens.length == 2) {
            this.path = columnNameTokens[1];
            this.spath = "//" + columnNameTokens[1].replace('.', '/');
        }
        this.table = table;
        this.index = idx;
        this.columnSchema = table.getColumn(this.index);
    }

    public int getIndex() {
        return this.index;
    }

    public ColumnSchema getColumnSchema() {
        return this.columnSchema;
    }

    public Function<String, String> getFilter() {
        return this.filter;
    }

    public Function<Object, List<String>> getValueExtractor() {
        return this.valueExtractor;
    }

    public String getSpath() {
        return this.spath;
    }

    public String getFullPath() {
        Object name = this.columnSchema.getObjectName().statementName;
        if (this.path != null) {
            name = (String)name + "." + this.path;
        }
        return name;
    }

    public String getPath() {
        return this.path;
    }
}

