/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.fulltext;

import com.streamscape.Trace;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.persist.fulltext.CollectionColumn;
import com.streamscape.ds.persist.fulltext.DocumentResultSet;
import com.streamscape.ds.persist.fulltext.FullTextSerializer;
import com.streamscape.ds.persist.fulltext.FullTextTuple;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.FlobDataID;
import com.streamscape.lib.utils.Pair;
import com.streamscape.omf.serializer.SerializerException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FullTextUtils {
    public static List<String> getPrimaryColumnNames(Table table) {
        return table.getColumnNameList(table.getPrimaryKey()).stream().map(o -> o.name).collect(Collectors.toList());
    }

    public static List<String> getColumnFullNames(List<FullTextTuple> tuples) {
        return tuples.stream().map(FullTextTuple::getFullName).collect(Collectors.toList());
    }

    public static String serialize(Object res) throws SerializerException {
        return FullTextSerializer.getSerializer().serialize(res);
    }

    public static Object deserialize(String res) throws SerializerException {
        return FullTextSerializer.getSerializer().deserialize(res);
    }

    public static Map<String, DocumentResultSet.ResultRow> indexByPKString(List<DocumentResultSet.ResultRow> rows) {
        HashMap<String, DocumentResultSet.ResultRow> res = new HashMap<String, DocumentResultSet.ResultRow>();
        rows.forEach(row -> res.put(row.getPkString(), (DocumentResultSet.ResultRow)row));
        return res;
    }

    public static Pair<String, String> parseFullColumnName(String fullColumnName) {
        String[] res = fullColumnName.split("\\.");
        return new Pair<String, String>(res[0], res[1]);
    }

    public static String getFullColumnName(CollectionColumn column) {
        return column.getColumn().getTableNameString() + "." + column.getIndexColumn().getFullPath();
    }

    public static void calculateRelativeParameters(DocumentResultSet resultSet) {
        float totalScore = 0.0f;
        for (DocumentResultSet.ResultRow row : resultSet.getRows()) {
            totalScore += row.getScore();
        }
        for (DocumentResultSet.ResultRow row : resultSet.getRows()) {
            row.setRelevance(row.getScore() / totalScore * 100.0f);
        }
    }

    public static void sortByScoreAsc(DocumentResultSet resultSet) {
        Collections.sort(resultSet.getRows(), (a, b) -> Float.compare(a.getScore(), b.getScore()));
    }

    public static void sortByScoreDesc(DocumentResultSet resultSet) {
        Collections.sort(resultSet.getRows(), (a, b) -> Float.compare(b.getScore(), a.getScore()));
    }

    public static String getFlobPath(Session session, FlobDataID dataId) {
        return session.getDataspaceStore().flobManager.getFlobFileManager().getAbsoluteFilePath(dataId.getLocation(), dataId.getFilename());
    }

    public static Session retrieveSDSSession(Session session) {
        Session sdsSession = session.dataspaceStore.getSessionManager().newSession(session.dataspaceStore, session.getUser(), false, true);
        sdsSession.dataspaceStore = session.dataspaceStore;
        NameManager.ObjectName sdsSchemaName = session.dataspaceStore.schemaManager.findSchema("SDS").getObjectName();
        sdsSession.setCurrentDataspaceName(sdsSchemaName);
        return sdsSession;
    }

    public static void processExplicitCollections(Object obj, String key, Map pMap, String pKey) {
        if (obj instanceof List) {
            List list = (List)obj;
            for (Object item : list) {
                if (key != null && pMap != null && (item instanceof String || item instanceof Number)) {
                    pMap.put(key, FullTextUtils.expandExplicitList(key, list));
                    return;
                }
                FullTextUtils.processExplicitCollections(item, null, null, null);
            }
        } else if (obj instanceof Map) {
            try {
                Map subMap = (Map)obj;
                for (Map.Entry entry : subMap.entrySet()) {
                    String k = (String)entry.getKey();
                    Object value = entry.getValue();
                    FullTextUtils.processExplicitCollections(value, k, subMap, key);
                }
            }
            catch (ClassCastException e) {
                Trace.logException(FullTextUtils.class, e, true);
            }
        } else if (pKey != null && pMap != null && (obj instanceof String || obj instanceof Number)) {
            pMap.put(key, pKey + " " + key + " " + String.valueOf(obj));
        }
    }

    private static String expandExplicitList(String key, List<Object> list) {
        StringBuilder sb = new StringBuilder();
        for (Object o : list) {
            sb.append(key).append(" ").append(o).append(" ");
        }
        return sb.toString().trim();
    }

    public static String mserialize(Object res) throws SerializerException {
        return FullTextSerializer.getMSerializer().serialize(res);
    }
}

