/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.fulltext;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.table.Table;

public class FullTextTuple {
    private String name;
    private String displayName;
    private String tableName;
    private Table table;
    private String spath;
    public static String FIELD_SCORE_NAME = "score";
    public static String FIELD_TUPLES_NAME = "tuple";
    public static String FIELD_COLLECTION_NAME = "collection";
    public static String FIELD_RELEVANCE_NAME = "relevance";
    public static String FIELD_ENTRIES_NAME = "entries";
    public static String FIELD_FRAGMENT_NAME = "fragment";
    public static String FIND_TABLE_NAME = "statistics";

    public FullTextTuple(Table table, String columnName) {
        String[] colNameTokens = columnName.split("\\.", 2);
        ColumnSchema column = table.getColumn(colNameTokens[0]);
        if (column == null) {
            throw Error.error(5501, columnName);
        }
        this.name = column.getObjectName().name;
        this.tableName = column.getTableNameString();
        this.table = table;
        if (colNameTokens.length > 1) {
            this.spath = "//" + colNameTokens[1].replace('.', '/');
        }
    }

    public FullTextTuple(String tableName, String tupleName, String displayName) {
        this.tableName = tableName;
        this.name = tupleName;
        this.displayName = displayName;
    }

    public String getNameString() {
        return this.name;
    }

    public String getTableNameString() {
        return this.tableName;
    }

    public static FullTextTuple createScoreColumn() {
        return FullTextTuple.createSystemFullTextTuple(FIELD_SCORE_NAME);
    }

    public static FullTextTuple createTuplesColumn() {
        return FullTextTuple.createSystemFullTextTuple(FIELD_TUPLES_NAME);
    }

    public static FullTextTuple createCollectionColumn() {
        return FullTextTuple.createSystemFullTextTuple(FIELD_COLLECTION_NAME);
    }

    public static FullTextTuple createPercentageColumn() {
        return FullTextTuple.createSystemFullTextTuple(FIELD_RELEVANCE_NAME);
    }

    public static FullTextTuple createEntriesColumn() {
        return FullTextTuple.createSystemFullTextTuple(FIELD_ENTRIES_NAME);
    }

    public static FullTextTuple createFragmentColumn() {
        return FullTextTuple.createSystemFullTextTuple(FIELD_FRAGMENT_NAME);
    }

    private static FullTextTuple createSystemFullTextTuple(String tupleName) {
        return new FullTextTuple(FIND_TABLE_NAME, tupleName, null);
    }

    public String getFullName() {
        return "[" + this.getTableNameString() + "]." + this.getNameString();
    }

    public String getDisplayName() {
        return this.displayName != null ? this.displayName : this.getNameString();
    }

    public String getSpath() {
        return this.spath;
    }
}

