/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.fulltext;

import com.streamscape.ds.persist.fulltext.IndexColumn;
import com.streamscape.ds.schema.table.Table;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class FullTextTableIndex {
    protected Table table;
    protected List<IndexColumn> columns;
    protected List<Integer> columnIndexes = new ArrayList<Integer>();

    protected FullTextTableIndex(Table table, List<IndexColumn> columns) {
        this.table = table;
        this.columns = columns;
        if (columns != null) {
            this.columnIndexes = columns.stream().map(IndexColumn::getIndex).collect(Collectors.toList());
        }
    }

    public Table getTable() {
        return this.table;
    }

    public List<IndexColumn> getIndexColumns() {
        return this.columns;
    }

    public int[] getColumnIndexes() {
        return this.columns.stream().mapToInt(IndexColumn::getIndex).toArray();
    }

    boolean containsColumnIndex(int colIndex) {
        return this.columnIndexes.contains(colIndex);
    }

    public String getColumnListSQL() {
        LinkedList<String> sqlColList = new LinkedList<String>();
        for (IndexColumn tCol : this.getIndexColumns()) {
            String item = tCol.getFullPath();
            sqlColList.add(item);
        }
        return "(" + String.join((CharSequence)",", sqlColList) + ")";
    }
}

