/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.fulltext;

import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.navigator.RowSetNavigatorClient;
import com.streamscape.ds.persist.fulltext.DocumentResultSet;
import com.streamscape.ds.persist.fulltext.FullTextQuery;
import com.streamscape.ds.persist.fulltext.FullTextTuple;
import com.streamscape.ds.persist.fulltext.FullTextUtils;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.FlobDataID;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.lib.utils.SQLType;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FullTextSearchResult {
    private DocumentResultSet resultSet;
    private FullTextQuery query;
    private Session session;
    private List<Object[]> preparedData = new LinkedList<Object[]>();

    public FullTextSearchResult(DocumentResultSet resultSet, FullTextQuery query, Session session) {
        this.resultSet = resultSet;
        this.query = query;
        this.session = session;
        this.prepare();
    }

    public Result toResult() {
        ResultMetaData metaData = this.getResultMetaData();
        RowSetNavigatorClient navigator = new RowSetNavigatorClient();
        Result result = Result.newDataResult(metaData);
        result.setNavigator(navigator);
        for (Object[] record : this.getData()) {
            for (int i = 0; i < record.length; ++i) {
                if (!(record[i] instanceof List)) continue;
                record[i] = record[i].toString();
            }
            navigator.add(record);
        }
        return result;
    }

    private List<Object[]> getData() {
        if (this.query.getTop() > 0) {
            return this.preparedData.subList(0, Math.min(this.preparedData.size(), this.query.getTop()));
        }
        return this.preparedData;
    }

    public RowSet toRowSet() throws Exception {
        RowSet rs = new RowSet(this.getRowSetMetaData());
        for (Object[] record : this.getData()) {
            rs.addToRowSet(record);
        }
        return rs;
    }

    private void prepare() {
        FullTextUtils.calculateRelativeParameters(this.resultSet);
        if (this.query.getOrderType().equals((Object)FullTextQuery.OrderType.ASC)) {
            FullTextUtils.sortByScoreAsc(this.resultSet);
        } else {
            FullTextUtils.sortByScoreDesc(this.resultSet);
        }
        if (this.query.getReturnType().equals((Object)FullTextQuery.ReturnType.STATISTICS)) {
            this.resultSet.getRows().forEach(row -> this.preparedData.add(new Object[]{row.getColumnName(), row.getTableName(), this.pkToString(row.getPk()), row.getIndexName(), this.formatNumbers(row.getTf()), this.formatNumbers(row.getIdf()), this.formatNumbers(row.getLengthNorm()), this.formatNumbers(row.getScore()), this.formatNumbers(row.getRelevance(), 2)}));
        } else {
            ArrayList columnNames = new ArrayList();
            this.query.getReturnColumns().forEach(cs -> columnNames.add(cs.getFullName()));
            Map<String, List<DocumentResultSet.ResultRow>> indexedRows = this.resultSet.getRowsIndexedByTable();
            indexedRows.forEach((tableName, rows) -> {
                try {
                    this.getTableReturnResult((List<DocumentResultSet.ResultRow>)rows, this.query, (String)tableName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                rows.forEach(row -> {
                    Map<String, Object> aData = row.getAdditionalData();
                    Object[] data = new Object[columnNames.size()];
                    for (int i = 0; i < columnNames.size(); ++i) {
                        Object elem = aData.get(columnNames.get(i));
                        if (elem instanceof FlobDataID) {
                            elem = FullTextUtils.getFlobPath(this.session, (FlobDataID)elem).toString();
                        }
                        data[i] = elem;
                    }
                    this.preparedData.add(data);
                });
            });
        }
    }

    private String pkToString(List<Object> pk) {
        return pk.stream().map(Object::toString).collect(Collectors.joining(","));
    }

    private String formatNumbers(float val) {
        return this.formatNumbers(val, 4);
    }

    private String formatNumbers(float val, int places) {
        return String.format("%." + places + "f", Float.valueOf(val));
    }

    private void getTableReturnResult(List<DocumentResultSet.ResultRow> rows, FullTextQuery query, String tableName) throws Exception {
        List<FullTextTuple> returnColumns = query.getReturnColumns(tableName);
        List<String> columnNames = FullTextUtils.getColumnFullNames(returnColumns);
        ArrayList<Object> pVals = new ArrayList<Object>();
        ArrayList<CallSite> replacements = new ArrayList<CallSite>();
        for (DocumentResultSet.ResultRow row : rows) {
            pVals.addAll(row.getPk());
            Object[] qMarks = new String[row.getPk().size()];
            Arrays.fill(qMarks, "?");
            replacements.add((CallSite)((Object)("(" + String.join((CharSequence)",", (CharSequence[])qMarks) + ")")));
        }
        Table table = (Table)this.session.dataspaceStore.schemaManager.getSchemaObject(tableName, this.session.getCurrentDataspaceName().name, 3);
        List<String> primaryColumnNames = FullTextUtils.getPrimaryColumnNames(table);
        String columnNamesSelectSql = columnNames.isEmpty() ? "" : String.join((CharSequence)",", columnNames) + ",";
        String sql = "SELECT " + columnNamesSelectSql + String.join((CharSequence)",", primaryColumnNames) + " FROM [" + tableName + "] WHERE (" + String.join((CharSequence)",", primaryColumnNames) + ") IN (" + String.join((CharSequence)",", replacements) + ")";
        Result result = this.session.executeCompiledStatement(this.session.compileStatement(sql), pVals.toArray());
        RowSetNavigator nav = result.getNavigator();
        List<FullTextTuple> sysColumns = query.getReturnColumns(FullTextTuple.FIND_TABLE_NAME);
        HashMap dbData = new HashMap();
        while (nav.next()) {
            Object[] current = nav.getCurrent();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (int i = 0; i < columnNames.size(); ++i) {
                Object obj = current[i];
                Type t = result.metaData.columnTypes[i];
                if (t != null && t.typeCode == 91) {
                    obj = Type.SQL_DATE.convertSQLToJava(this.session, obj);
                }
                if (obj instanceof OtherTypeWrapper) {
                    String spath = returnColumns.get(i).getSpath();
                    obj = ((OtherTypeWrapper)obj).getObject();
                    if (spath != null) {
                        try {
                            obj = this.session.sessionContext.sdrManager.getValueAtPath(spath, obj);
                        }
                        catch (Exception ex) {
                            obj = null;
                        }
                    }
                    if (obj != null && !(obj instanceof String)) {
                        obj = FullTextUtils.serialize(obj);
                    }
                }
                hashMap.put(columnNames.get(i), obj);
            }
            int s = columnNames.size();
            LinkedList<Object> o = new LinkedList<Object>();
            for (int i = s; i < s + primaryColumnNames.size(); ++i) {
                o.add(current[i]);
            }
            dbData.put(FullTextUtils.serialize(o), hashMap);
        }
        for (DocumentResultSet.ResultRow resultRow : rows) {
            Map<String, Object> addData = resultRow.getAdditionalData();
            addData.putAll((Map)dbData.get(resultRow.getPkString()));
            if (!sysColumns.isEmpty()) {
                sysColumns.forEach(sysColumn -> addData.put(sysColumn.getFullName(), resultRow.getSystemValue(sysColumn.getNameString())));
            }
            resultRow.setAdditionalData(addData);
        }
    }

    private ResultMetaData getResultMetaData() {
        if (this.query.getReturnType().equals((Object)FullTextQuery.ReturnType.STATISTICS)) {
            return ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Tuple", "Collection", "Key", "Index Used", "Tf", "Idf", "LengthNorm", "Score", "Relevance"});
        }
        ArrayList types = new ArrayList();
        ArrayList columnNames = new ArrayList();
        this.query.getReturnColumns().forEach(cs -> {
            columnNames.add(cs.getDisplayName());
            types.add(Type.SQL_VARCHAR);
        });
        return ResultMetaData.newSimpleResultMetaData(types.toArray(new Type[0]), columnNames.toArray(new String[0]));
    }

    private RowMetaData getRowSetMetaData() {
        RowMetaData rowMetaData = new RowMetaData();
        if (this.query.getReturnType().equals((Object)FullTextQuery.ReturnType.STATISTICS)) {
            rowMetaData.addColumn("Tuple", SQLType.STRING);
            rowMetaData.addColumn("Collection", SQLType.STRING);
            rowMetaData.addColumn("Key", SQLType.STRING);
            rowMetaData.addColumn("Index Used", SQLType.STRING);
            rowMetaData.addColumn("Tf", SQLType.STRING);
            rowMetaData.addColumn("Idf", SQLType.STRING);
            rowMetaData.addColumn("LengthNorm", SQLType.STRING);
            rowMetaData.addColumn("Score", SQLType.STRING);
            rowMetaData.addColumn("Relevance", SQLType.STRING);
            return rowMetaData;
        }
        this.query.getReturnColumns().forEach(cs -> rowMetaData.addColumn(cs.getTableNameString() + "." + cs.getNameString(), SQLType.STRING));
        return rowMetaData;
    }
}

