/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.fulltext;

import com.streamscape.ds.persist.fulltext.CollectionColumn;
import com.streamscape.ds.persist.fulltext.FullTextIndex;
import com.streamscape.ds.persist.fulltext.FullTextTuple;
import com.streamscape.ds.persist.fulltext.IndexColumn;
import com.streamscape.ds.schema.table.Table;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FullTextQuery {
    private Map<Table, Map<IndexColumn, CollectionColumn.ColumnOperand>> tableColumnsMap;
    private List<FullTextIndex> indexList;
    private String queryString;
    private ReturnType returnType;
    private SearchType searchType;
    private OrderType orderType;
    private List<FullTextTuple> returnColumns;
    private boolean enableTfFactor;
    private boolean enableIdfFactor;
    private boolean enableLengthNormFactor;
    private int top;

    public FullTextQuery(String queryString, Map<Table, Map<IndexColumn, CollectionColumn.ColumnOperand>> tableColumnsMap, List<FullTextIndex> indexList, ReturnType returnType, List<FullTextTuple> returnColumns, SearchType searchType, OrderType orderType, boolean enableTfFactor, boolean enableIdfFactor, boolean enableLengthNormFactor, int top) {
        this.queryString = queryString;
        this.tableColumnsMap = tableColumnsMap;
        this.indexList = indexList;
        this.returnType = returnType;
        this.returnColumns = returnColumns;
        this.searchType = searchType;
        this.orderType = orderType;
        this.enableTfFactor = enableTfFactor;
        this.enableIdfFactor = enableIdfFactor;
        this.enableLengthNormFactor = enableLengthNormFactor;
        this.top = top;
    }

    public Map<Table, Map<IndexColumn, CollectionColumn.ColumnOperand>> getTableColumnsMap() {
        return this.tableColumnsMap;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public ReturnType getReturnType() {
        return this.returnType;
    }

    public List<FullTextTuple> getReturnColumns(String tableName) {
        return this.returnColumns.stream().filter(cs -> cs.getTableNameString().equals(tableName)).collect(Collectors.toList());
    }

    public Table getTable(String tableName) {
        for (Table table : this.tableColumnsMap.keySet()) {
            if (!table.getObjectName().name.equals(tableName)) continue;
            return table;
        }
        return null;
    }

    public List<FullTextTuple> getReturnColumns() {
        return this.returnColumns;
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    public boolean isMatchType() {
        return this.searchType.equals((Object)SearchType.MATCH);
    }

    public OrderType getOrderType() {
        return this.orderType;
    }

    public boolean isEnableTfFactor() {
        return this.enableTfFactor;
    }

    public boolean isEnableIdfFactor() {
        return this.enableIdfFactor;
    }

    public boolean isEnableLengthNormFactor() {
        return this.enableLengthNormFactor;
    }

    public List<FullTextIndex> getIndexList() {
        return this.indexList;
    }

    public int getTop() {
        return this.top;
    }

    public static enum ReturnType {
        STATISTICS,
        DATA;

    }

    public static enum SearchType {
        TEXT,
        MATCH;

    }

    public static enum OrderType {
        ASC,
        DESC;

    }
}

