/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.fulltext;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.persist.fulltext.CollectionColumn;
import com.streamscape.ds.persist.fulltext.DocumentIndex;
import com.streamscape.ds.persist.fulltext.DocumentResultSet;
import com.streamscape.ds.persist.fulltext.FullTextIndex;
import com.streamscape.ds.persist.fulltext.FullTextIndexImpl;
import com.streamscape.ds.persist.fulltext.FullTextQuery;
import com.streamscape.ds.persist.fulltext.FullTextSearchResult;
import com.streamscape.ds.persist.fulltext.FullTextTableIndex;
import com.streamscape.ds.persist.fulltext.FullTextUtils;
import com.streamscape.ds.persist.fulltext.IndexColumn;
import com.streamscape.ds.persist.fulltext.lucene.LuceneDocumentIndex;
import com.streamscape.ds.persist.row.RowAction;
import com.streamscape.ds.schema.collection.AbstractCollection;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.state.DataspaceStateHolder;
import com.streamscape.ds.state.StateHolder;
import com.streamscape.lib.utils.Pair;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FullTextManager {
    private DataspaceStore dataspaceStore;
    private List<FullTextIndex> indexes = new ArrayList<FullTextIndex>();
    private FullTextIndex sysldefIndex;
    public static String FULL_TEXT_DIR;
    public static final String SYSLDEF_TEXT_INDEX_NAME = "SYSLDEF_TEXT_INDEX";

    public FullTextManager(DataspaceStore dataspaceStore) {
        this.dataspaceStore = dataspaceStore;
        FULL_TEXT_DIR = dataspaceStore.dataspaceLocation + File.separator + "fulltext";
        try {
            Path indexDir = Paths.get(FULL_TEXT_DIR, new String[0]);
            if (!Files.exists(indexDir, new LinkOption[0])) {
                Files.createDirectory(indexDir, new FileAttribute[0]);
            }
        }
        catch (Exception e) {
            throw new DataspaceException("Cannot create root full-text directory.", e);
        }
    }

    public FullTextIndex createIndex(Session session, NameManager.ObjectName indexName, Map<Table, List<IndexColumn>> tableColumnsMap, DocumentIndex.StoreType storeType, boolean noData, int commitTimeInterval, int changeBufferSize, boolean implicitCollection) {
        try {
            boolean materialize = !DocumentIndex.exists(indexName) && !noData;
            LuceneDocumentIndex documentIndex = new LuceneDocumentIndex(this.dataspaceStore, indexName, storeType);
            FullTextIndexImpl index = new FullTextIndexImpl(this.dataspaceStore, indexName, tableColumnsMap, documentIndex, commitTimeInterval, changeBufferSize, implicitCollection);
            if (materialize) {
                index.materialize(session);
            }
            index.getTableIndexes().forEach(idx -> idx.getTable().addFullTextIndex(index));
            this.indexes.add(index);
            String initAt = documentIndex.getIndexPath() == null ? "in memory" : "at " + String.valueOf(documentIndex.getIndexPath());
            Trace.logInfo(this, "Text index (" + documentIndex.getIndexFormat() + ") initialized " + initAt);
            return index;
        }
        catch (Exception e) {
            throw new DataspaceException("Failed to initialize Document Index: " + indexName.name + ". Lucene error: " + e.getMessage(), e);
        }
    }

    public FullTextSearchResult search(FullTextQuery query, Session session) {
        DocumentResultSet wholeResultSet = new DocumentResultSet();
        Map<DocumentIndex, List<CollectionColumn>> indexColumns = this.indexColumnsMap(query, session);
        indexColumns.forEach((documentIndex, columnSchemas) -> wholeResultSet.addResultSet(documentIndex.search((List<CollectionColumn>)columnSchemas, query)));
        return new FullTextSearchResult(wholeResultSet, query, session);
    }

    private Map<DocumentIndex, List<CollectionColumn>> indexColumnsMap(FullTextQuery query, Session session) {
        HashMap<DocumentIndex, List<CollectionColumn>> indexMap = new HashMap<DocumentIndex, List<CollectionColumn>>();
        if (!query.getTableColumnsMap().isEmpty()) {
            for (FullTextIndex index : this.indexes) {
                query.getTableColumnsMap().forEach((table, columns) -> {
                    DocumentIndex docIndex = index.getDocumentIndex();
                    if (!columns.keySet().isEmpty()) {
                        for (IndexColumn iCol : columns.keySet()) {
                            ColumnSchema foundColumn = index.getColumn((Table)table, iCol.getIndex());
                            if (foundColumn == null) continue;
                            if (!indexMap.containsKey(docIndex)) {
                                indexMap.put(docIndex, new ArrayList());
                            }
                            ((List)indexMap.get(docIndex)).add(new CollectionColumn((CollectionColumn.ColumnOperand)((Object)((Object)columns.get(iCol))), iCol));
                        }
                    } else {
                        List<IndexColumn> foundColumns = index.getIndexColumns((Table)table);
                        if (foundColumns.isEmpty()) {
                            return;
                        }
                        if (!indexMap.containsKey(docIndex)) {
                            indexMap.put(docIndex, new ArrayList());
                        }
                        ((List)indexMap.get(docIndex)).addAll(foundColumns.stream().map(col -> new CollectionColumn(CollectionColumn.ColumnOperand.OR, (IndexColumn)col)).collect(Collectors.toList()));
                    }
                });
            }
        } else {
            List<FullTextIndex> searchIndexList = query.getIndexList();
            for (FullTextIndex index : this.indexes) {
                if (!index.getObjectName().schema.equals(session.currentDataspace) || !searchIndexList.isEmpty() && !searchIndexList.contains(index)) continue;
                DocumentIndex docIndex = index.getDocumentIndex();
                List colColumns = index.getIndexColumns().stream().map(iCol -> new CollectionColumn(CollectionColumn.ColumnOperand.OR, (IndexColumn)iCol)).collect(Collectors.toList());
                indexMap.put(docIndex, colColumns);
            }
        }
        return indexMap;
    }

    public void dropIndex(FullTextIndex index) {
        index.remove();
        this.indexes.remove(index);
    }

    public void commit(Session session) throws Exception {
        if (this.indexes.isEmpty()) {
            return;
        }
        Map<FullTextIndex, List<RowAction>> rowActionMap = this.getRowActions(session);
        if (rowActionMap == null) {
            return;
        }
        for (FullTextIndex fti : rowActionMap.keySet()) {
            fti.processRowActions(session, rowActionMap.get(fti));
        }
    }

    private Map<FullTextIndex, List<RowAction>> getRowActions(Session session) {
        int limit = session.rowActionList.size();
        if (limit == 0) {
            return null;
        }
        HashMap<FullTextIndex, List<RowAction>> res = new HashMap<FullTextIndex, List<RowAction>>();
        Object[] list = session.rowActionList.getArray();
        for (int i = 0; i < limit; ++i) {
            List<FullTextIndex> ftis;
            RowAction action = (RowAction)list[i];
            if (action == null || !(action.table instanceof Table) || (ftis = ((Table)action.table).getFullTextIndexes()) == null) continue;
            for (FullTextIndex fti : ftis) {
                if (!res.containsKey(fti)) {
                    res.put(fti, new LinkedList());
                }
                ((List)res.get(fti)).add(action);
            }
        }
        return res;
    }

    public void rollback(Session session) {
        if (this.indexes.isEmpty()) {
            return;
        }
    }

    public FullTextIndex retrieveSysldefIndex(Session sdsSession) {
        if (this.sysldefIndex != null) {
            return this.sysldefIndex;
        }
        int DESCRIPTION_COLUMN_IDX = 4;
        Table sysldefTable = (Table)sdsSession.dataspaceStore.schemaManager.findSchemaObject("SYSLDEF", "SDS", 3);
        HashMap<Table, List<IndexColumn>> columnsMap = new HashMap<Table, List<IndexColumn>>();
        IndexColumn tColumn = new IndexColumn(sysldefTable, 4, s -> s.replace("''", "'"));
        columnsMap.put(sysldefTable, Arrays.asList(tColumn));
        NameManager.ObjectName indexName = sdsSession.dataspaceStore.nameManager.newObjectName(SYSLDEF_TEXT_INDEX_NAME, false, 38);
        indexName.setSchemaIfNull(sdsSession.getCurrentDataspaceName());
        this.sysldefIndex = sdsSession.dataspaceStore.getFullTextManager().createIndex(sdsSession, indexName, columnsMap, DocumentIndex.StoreType.PERSISTENT, false, -1, -1, false);
        return this.sysldefIndex;
    }

    public void deleteSysldefFolder(Session sdsSession) throws IOException {
        NameManager.ObjectName indexName = sdsSession.dataspaceStore.nameManager.newObjectName(SYSLDEF_TEXT_INDEX_NAME, false, 38);
        indexName.setSchemaIfNull(sdsSession.getCurrentDataspaceName());
        LuceneDocumentIndex.removeIndexFolder(indexName);
    }

    public FullTextIndex getSysldefIndex() {
        return this.sysldefIndex;
    }

    public void reindexSysldefIndex(Session sdsSession) throws Exception {
        try {
            FullTextIndex index = this.retrieveSysldefIndex(sdsSession);
            index.reindex(sdsSession);
        }
        catch (Exception e) {
            try {
                this.deleteSysldefFolder(sdsSession);
            }
            catch (Exception exception) {
                // empty catch block
            }
            FullTextIndex index = this.retrieveSysldefIndex(sdsSession);
            index.reindex(sdsSession);
        }
    }

    public boolean txSyncEnable() {
        return this.dataspaceStore.getProperties().isPropertyTrue("text.engine.tx.sync.enable");
    }

    public void setTxCollectionSuspectState(Session session) {
        Map<AbstractCollection, List<FullTextIndex>> collectionMap = this.getTxCollections(session);
        if (collectionMap == null) {
            return;
        }
        for (AbstractCollection collection : collectionMap.keySet()) {
            for (FullTextIndex index : collectionMap.get(collection)) {
                collection.getStateHolder().setSuspectState((StateHolder.SuspectStateOriginator)DataspaceStateHolder.textIndex(index.getObjectName()), "The full-text index needs to be synchronized");
            }
        }
    }

    public void setTxTextIndexSuspectState(Session session) {
        Map<AbstractCollection, List<FullTextIndex>> collectionMap = this.getTxCollections(session);
        if (collectionMap == null) {
            return;
        }
        for (AbstractCollection collection : collectionMap.keySet()) {
            for (FullTextIndex index : collectionMap.get(collection)) {
                index.getStateHolder().setSuspectState(DataspaceStateHolder.invalid, "The full-text index needs to be synchronized");
                index.getStateHolder().setLastError("The full-text index needs to be synchronized");
            }
        }
    }

    private Map<AbstractCollection, List<FullTextIndex>> getTxCollections(Session session) {
        int limit = session.rowActionList.size();
        if (limit == 0) {
            return null;
        }
        HashMap<AbstractCollection, List<FullTextIndex>> collectionMap = new HashMap<AbstractCollection, List<FullTextIndex>>();
        Object[] list = session.rowActionList.getArray();
        for (int i = 0; i < limit; ++i) {
            RowAction action = (RowAction)list[i];
            if (!(action.table instanceof Table)) continue;
            try {
                Table table = (Table)action.table;
                if (table.getFullTextIndexes() == null) continue;
                AbstractCollection collection = (AbstractCollection)this.dataspaceStore.schemaManager.getCollection(session, table.getObjectName().name, table.getSchemaName().name);
                collectionMap.put(collection, table.getFullTextIndexes());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return collectionMap;
    }

    public String getRowActionListToLog(Session session) {
        try {
            int limit = session.rowActionList.size();
            if (limit == 0) {
                return null;
            }
            ArrayList<Pair<String, Object[]>> logList = new ArrayList<Pair<String, Object[]>>();
            Object[] list = session.rowActionList.getArray();
            for (int i = 0; i < limit; ++i) {
                RowAction action = (RowAction)list[i];
                if (!(action.table instanceof Table) || action.memoryRow == null) continue;
                Table table = (Table)action.table;
                logList.add(new Pair<String, Object[]>(table.getObjectName().name, action.memoryRow.getData()));
            }
            if (logList.isEmpty()) {
                return null;
            }
            return FullTextUtils.serialize(logList);
        }
        catch (Exception e) {
            return null;
        }
    }

    public IndexColumn findIndexColumn(Table baseTable, String path) {
        for (FullTextIndex idx : this.indexes) {
            FullTextTableIndex tIdx = idx.getTableIndex(baseTable);
            if (tIdx == null) continue;
            for (IndexColumn iCol : tIdx.getIndexColumns()) {
                if (!iCol.getFullPath().equals(path)) continue;
                return iCol;
            }
        }
        return null;
    }

    public void closeAll() {
        for (FullTextIndex index : this.indexes) {
            index.close();
        }
    }
}

