/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.fulltext;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.DataspaceStoreState;
import com.streamscape.ds.io.rowio.RowOutputBinaryEncode;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.persist.fulltext.DocumentIndex;
import com.streamscape.ds.persist.fulltext.FullTextIndex;
import com.streamscape.ds.persist.fulltext.FullTextTableIndex;
import com.streamscape.ds.persist.fulltext.IndexColumn;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.persist.row.RowAction;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.AbstractCollection;
import com.streamscape.ds.schema.collection.fspace.directory.DirectoryTableCollection;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.VirtualTable;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.state.DataspaceStateHolder;
import com.streamscape.ds.types.CharacterType;
import com.streamscape.ds.types.FlobType;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.Type;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.fs.client.FileInfo;
import com.streamscape.lib.utils.parser.ParseProcessor;
import com.streamscape.sdo.operation.SLMessage;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractOperation;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;

public class FullTextIndexImpl
implements FullTextIndex {
    public static int DEFAULT_MAX_CHANGE_BUFFER_SIZE = 1000;
    public static int DEFAULT_COMMIT_TIME_INTERVAL = 60;
    protected NameManager.ObjectName objectName;
    protected Map<Table, FullTextTableIndex> tableIndexes = new LinkedHashMap<Table, FullTextTableIndex>();
    protected DocumentIndex documentIndex;
    private boolean isStarted = true;
    private int maxChangeBufferSize = DEFAULT_MAX_CHANGE_BUFFER_SIZE;
    private int commitTimeInterval = DEFAULT_COMMIT_TIME_INTERVAL;
    private boolean explicitCollection;
    private AtomicInteger changeBufferSize = new AtomicInteger();
    private DataspaceStore dataspaceStore;
    protected DataspaceStateHolder stateHolder = new DataspaceStateHolder();

    public FullTextIndexImpl(DataspaceStore dataspaceStore, NameManager.ObjectName objectName, Map<Table, List<IndexColumn>> tableColumnsMap, DocumentIndex documentIndex, int commitTimeInterval, int changeBufferSize, boolean explicitCollection) {
        if (commitTimeInterval > 0) {
            this.commitTimeInterval = commitTimeInterval;
        }
        if (changeBufferSize > 0) {
            this.maxChangeBufferSize = changeBufferSize;
        }
        this.objectName = objectName;
        this.documentIndex = documentIndex;
        tableColumnsMap.forEach(this::addTableIndex);
        this.stateHolder.setState(DataspaceStoreState.ONLINE);
        this.dataspaceStore = dataspaceStore;
        this.explicitCollection = explicitCollection;
        this.registerCommitter();
    }

    @Override
    public void addTableIndex(Table table, List<IndexColumn> columns) {
        if (columns.isEmpty()) {
            LinkedList<Integer> columnIndexes = new LinkedList<Integer>();
            for (int i = 0; i < table.getColumnCount(); ++i) {
                ColumnSchema column = table.getColumn(i);
                Type type = column.getDataType();
                if (!(type instanceof CharacterType) && !(type instanceof FlobType) && !(type instanceof OtherType)) continue;
                columnIndexes.add(i);
            }
            if (columnIndexes.isEmpty()) {
                throw new DataspaceException("There are no fields with either Character Type or Flob Yype");
            }
            columns = columnIndexes.stream().map(idx -> new IndexColumn(table, (int)idx)).collect(Collectors.toList());
        }
        this.tableIndexes.put(table, new FullTextTableIndex(table, columns));
    }

    @Override
    public int getObjectType() {
        return 38;
    }

    @Override
    public NameManager.ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public NameManager.ObjectName getSchemaName() {
        return this.objectName.schema;
    }

    @Override
    public NameManager.ObjectName getCatalogName() {
        return this.objectName.schema.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.objectName.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet hs = new OrderedHashSet();
        if (this.tableIndexes != null) {
            for (Table tbl : this.tableIndexes.keySet()) {
                hs.add(tbl.getObjectName());
            }
        }
        return hs;
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    @Override
    public DocumentIndex getDocumentIndex() {
        return this.documentIndex;
    }

    @Override
    public void insert(Session session, Object[] newData, Table table) throws Exception {
        this.checkBatchAutoCommit();
        this.documentIndex.insert(session, newData, table, this);
    }

    @Override
    public void batchInsert(Session session, List<Object[]> newData, Table table) throws Exception {
        for (Object[] record : newData) {
            this.insert(session, record, table);
        }
    }

    @Override
    public void delete(Session session, Object[] oldData, Table table) throws Exception {
        this.checkBatchAutoCommit();
        this.documentIndex.delete(oldData, table, this);
    }

    @Override
    public void update(Session session, Object[] oldData, Object[] newData, Table table) throws Exception {
        this.checkBatchAutoCommit();
        this.documentIndex.update(session, oldData, newData, table, this);
    }

    private void checkBatchAutoCommit() {
        if (this.changeBufferSize.addAndGet(1) > this.maxChangeBufferSize) {
            this.commit();
            this.changeBufferSize.set(0);
        }
    }

    @Override
    public List<FullTextTableIndex> getTableIndexes() {
        return new ArrayList<FullTextTableIndex>(this.tableIndexes.values());
    }

    @Override
    public FullTextTableIndex getTableIndex(Table table) {
        return this.tableIndexes.get(table);
    }

    @Override
    public void materialize(Session session) throws Exception {
        try {
            this.indexExistingRows(session);
        }
        catch (Exception e) {
            this.documentIndex.release();
            throw new DataspaceException(e);
        }
        finally {
            this.raiseMessage(null, false, session);
        }
    }

    public void raiseMessage(String message, boolean error, Session session) throws FabricException {
        SLMessage slm = new SLMessage(message, !error, session.getComponentName(), session.getSLSessionName());
        AbstractOperation.raiseSLMessage(slm);
    }

    private void indexExistingRows(Session session) {
        RowOutputBinaryEncode rowOut = new RowOutputBinaryEncode(session.dataspaceStore.dataspaceLogger.getCrypto(), 256, 8);
        this.tableIndexes.forEach((table, tableIndex) -> {
            Table baseTable = table.getBaseTable();
            RowIterator iter = table.rowIterator(session);
            long tblSampleCount = baseTable.getSampleCount();
            int step = 2950;
            int cnt = 0;
            try {
                this.raiseMessage("Table '" + table.getObjectName().name + "'\n", false, session);
                if (baseTable instanceof VirtualTable && ((VirtualTable)baseTable).helper instanceof DirectoryTableCollection) {
                    DirectoryTableCollection dirTable = (DirectoryTableCollection)((VirtualTable)baseTable).helper;
                    String path = dirTable.getPath();
                    Result res = session.executeDirectStatement("select * from " + table.getObjectName().statementName);
                    RowSetNavigator rowSet = res.getNavigator();
                    int dataColIdx = table.getColumnIndex("Data");
                    boolean containsDataField = tableIndex.containsColumnIndex(dataColIdx);
                    int nameColIdx = table.getPrimaryKey()[0];
                    while (rowSet.next()) {
                        Object[] data = rowSet.getCurrent();
                        String filePath = FilenameUtils.concat(path, (String)data[nameColIdx]);
                        FileInfo fileInfo = dirTable.getFileSystem(session).getInfo(filePath);
                        if (containsDataField && !fileInfo.isDirectory() && fileInfo.getSize() > 0L) {
                            try (InputStream is = dirTable.getFileSystem(session).open(filePath);){
                                data[dataColIdx] = ParseProcessor.getText(is);
                            }
                        }
                        this.insert(session, data, (Table)table);
                    }
                } else {
                    while (iter.hasNext()) {
                        ++cnt;
                        Row row = iter.getNextRow();
                        if (row != null) {
                            rowOut.reset();
                            rowOut.writeData(row, baseTable.getBaseTable().colTypes);
                            Object[] data = row.getData();
                            this.insert(session, data, (Table)table);
                            if (cnt % 2950 != 0) continue;
                            this.raiseMessage("...Indexing " + String.format("%.2f", Float.valueOf((float)cnt * 100.0f / (float)tblSampleCount)) + "%\n", false, session);
                            continue;
                        }
                        break;
                    }
                }
                this.raiseMessage("...Indexing 100.00%\n", false, session);
            }
            catch (Exception e) {
                Trace.logException(this, e, true);
                throw new DataspaceException("Error while indexing existing table rows: '" + table.getObjectName().name + "'");
            }
        });
    }

    @Override
    public void reindex(Session session) throws Exception {
        this.deleteAll(session);
        this.indexExistingRows(session);
    }

    @Override
    public void remove() {
        try {
            this.tableIndexes.forEach((table, tableIndexes) -> table.removeFullTextIndex(this));
            this.documentIndex.removeDirectory();
            this.isStarted = false;
        }
        catch (Exception e) {
            throw new DataspaceException(e);
        }
    }

    @Override
    public String getColumnDescription() {
        ArrayList<String> tableColumns = new ArrayList<String>();
        for (FullTextTableIndex tableIndex : this.getTableIndexes()) {
            StringBuilder sb = new StringBuilder();
            sb.append(tableIndex.getTable().getObjectName().name);
            sb.append(tableIndex.getColumnListSQL());
            tableColumns.add(sb.toString());
        }
        return String.join((CharSequence)", ", tableColumns);
    }

    @Override
    public void addSpecificProperties(Result result) {
        this.documentIndex.addSpecificProperties(result);
    }

    @Override
    public Result getTupleStatistics() {
        return this.documentIndex.getTupleStatistics();
    }

    @Override
    public String[] getListPropertyValues() throws Exception {
        return new String[1];
    }

    private void deleteAll(Session session) throws Exception {
        this.documentIndex.deleteAll();
        this.commit();
    }

    @Override
    public void deleteAllTable(Table table) throws Exception {
        this.documentIndex.deleteAll(table);
    }

    @Override
    public String getSQL() {
        return this.getSQL(this.getObjectName().statementName);
    }

    @Override
    public String getSQLInSchema(String schemaName) {
        return this.getSQL(this.getObjectName().statementName, schemaName);
    }

    @Override
    public String getSQL(String name) {
        return this.getSQL(name, null);
    }

    public String getSQL(String name, String schemaName) {
        StringBuffer sb = new StringBuffer(64);
        sb.append("CREATE").append(' ');
        sb.append("TEXT").append(' ');
        sb.append("INDEX").append(' ');
        sb.append(name);
        sb.append(' ').append("ON").append(' ');
        for (int i = 0; i < this.getTableIndexes().size(); ++i) {
            FullTextTableIndex tableIndex = this.getTableIndexes().get(i);
            if (i != 0) {
                sb.append(",");
            }
            sb.append(tableIndex.getTable().getObjectName().getStatementName());
            sb.append(tableIndex.getColumnListSQL());
        }
        return sb.toString();
    }

    @Override
    public Set<ColumnSchema> getColumns(Table table, int[] filterColumns) {
        HashSet<ColumnSchema> columnSchemas = new HashSet<ColumnSchema>();
        if (!this.tableIndexes.containsKey(table)) {
            return columnSchemas;
        }
        int[] columns = this.tableIndexes.get(table).getColumnIndexes();
        if (filterColumns != null) {
            List columnList = Arrays.stream(columns).boxed().collect(Collectors.toList());
            for (int filterColumnIdx : filterColumns) {
                if (!columnList.contains(filterColumnIdx)) {
                    throw new DataspaceException("Column " + table.getObjectName().name + "." + table.getColumn(filterColumnIdx).getNameString() + " not found in indexes");
                }
                columnSchemas.add(table.getColumn(filterColumnIdx));
            }
        } else {
            for (int idx : columns) {
                columnSchemas.add(table.getColumn(idx));
            }
        }
        return columnSchemas;
    }

    @Override
    public List<IndexColumn> getIndexColumns(Table table) {
        LinkedList<IndexColumn> iCols = new LinkedList<IndexColumn>();
        if (!this.tableIndexes.containsKey(table)) {
            return iCols;
        }
        return this.tableIndexes.get(table).getIndexColumns();
    }

    @Override
    public ColumnSchema getColumn(Table table, int column) {
        Set<ColumnSchema> res = this.getColumns(table, new int[]{column});
        if (!res.isEmpty()) {
            return res.iterator().next();
        }
        return null;
    }

    @Override
    public List<IndexColumn> getIndexColumns() {
        LinkedList<IndexColumn> columns = new LinkedList<IndexColumn>();
        this.tableIndexes.forEach((table, tableIndex) -> {
            for (IndexColumn tColumn : tableIndex.getIndexColumns()) {
                columns.add(tColumn);
            }
        });
        return columns;
    }

    @Override
    public void commit() {
        try {
            this.documentIndex.commit();
        }
        catch (Exception e) {
            throw new DataspaceException("Full text commit failed", e);
        }
    }

    @Override
    public void rollback(Session session) {
    }

    @Override
    public DataspaceStateHolder getStateHolder() {
        return this.stateHolder;
    }

    @Override
    public DataspaceStateHolder aggregateStateHolder() {
        if (this.getStateHolder().isSuspectState()) {
            return this.getStateHolder();
        }
        boolean isOnline = true;
        for (Table table : this.tableIndexes.keySet()) {
            NameManager.ObjectName tableObj = table.getObjectName();
            AbstractCollection collection = (AbstractCollection)this.dataspaceStore.schemaManager.findSchemaObject(tableObj.name, tableObj.schema.name, 4);
            if (collection == null || !collection.aggregateStateHolder().isSuspectState()) continue;
            isOnline = false;
            break;
        }
        return new DataspaceStateHolder(isOnline ? DataspaceStoreState.ONLINE : DataspaceStoreState.SUSPECT);
    }

    @Override
    public void processRowActions(Session session, List<RowAction> rowActions) throws Exception {
        for (RowAction act : rowActions) {
            Object[] dt = act.memoryRow.getData();
            Table tbl = (Table)act.table;
            int type = act.getType();
            if (type == 1) {
                if (tbl instanceof VirtualTable && ((VirtualTable)tbl).helper instanceof DirectoryTableCollection) continue;
                this.insert(session, dt, tbl);
                continue;
            }
            if (type != 2) continue;
            this.delete(session, dt, tbl);
        }
    }

    private void registerCommitter() {
        FabricThreadManager.getInstance().createThread("FSYS:FullTextManager.Committer", "", () -> {
            while (this.isStarted) {
                try {
                    this.commit();
                    Thread.sleep(this.commitTimeInterval * 1000);
                }
                catch (InterruptedException e) {
                    Trace.logException(this, e, true);
                }
            }
        }).start();
    }

    @Override
    public boolean isExplicitCollection() {
        return this.explicitCollection;
    }

    @Override
    public Date getCreatedDate() {
        return this.documentIndex.getCreatedDate();
    }

    @Override
    public Date getModifiedDate() {
        return this.documentIndex.getModifiedDate();
    }

    @Override
    public void close() {
        this.isStarted = false;
        this.commit();
        this.documentIndex.close();
    }
}

