/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.fulltext;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.persist.fulltext.FullTextTuple;
import com.streamscape.lib.utils.Pair;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DocumentResultSet {
    private List<ResultRow> rows = new ArrayList<ResultRow>();

    public void addRow(ResultRow row) {
        this.rows.add(row);
    }

    public void addRow(String tableName, String pkStr, List<Object> pk, String columnName, float score, String indexName, Pair<Integer, Integer>[] entries, String fragment, float tf, float idf, float lengthNorm) {
        this.rows.add(new ResultRow(tableName, pkStr, pk, columnName, entries, fragment, score, indexName, tf, idf, lengthNorm));
    }

    public List<ResultRow> getRows() {
        return this.rows;
    }

    public void addResultSet(DocumentResultSet resultSet) {
        this.rows.addAll(resultSet.rows);
    }

    public Map<String, List<ResultRow>> getRowsIndexedByTable() {
        return this.rows.stream().collect(Collectors.groupingBy(ResultRow::getTableName));
    }

    public boolean removeRow(ResultRow row) {
        return this.rows.remove(row);
    }

    public boolean removeAllRows(Collection<?> c) {
        return this.rows.removeAll(c);
    }

    public static class ResultRow {
        private String tableName;
        private String pkString;
        private List<Object> pk;
        private String columnName;
        private float score;
        private String indexName;
        private String uid;
        private Pair<Integer, Integer>[] entries;
        private String fragment;
        private float relevance;
        private float tf;
        private float idf;
        private float lengthNorm;
        private Map<String, Object> additionalData;

        public ResultRow(String tableName, String pkString, List<Object> pk, String columnName, Pair<Integer, Integer>[] entries, String fragment, float score, String indexName, float tf, float idf, float lengthNorm) {
            this.tableName = tableName;
            this.pk = pk;
            this.columnName = columnName;
            this.score = score;
            this.indexName = indexName;
            this.uid = tableName + "." + String.valueOf(pk);
            this.pkString = pkString;
            this.entries = entries;
            this.fragment = fragment;
            this.tf = tf;
            this.idf = idf;
            this.lengthNorm = lengthNorm;
        }

        public String getTableName() {
            return this.tableName;
        }

        public List<Object> getPk() {
            return this.pk;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public float getScore() {
            return this.score;
        }

        public String getIndexName() {
            return this.indexName;
        }

        public String getUid() {
            return this.uid;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public void setScore(float score) {
            this.score = score;
        }

        public String getPkString() {
            return this.pkString;
        }

        public Object getSystemValue(String syscolumnName) {
            if (FullTextTuple.FIELD_SCORE_NAME.equals(syscolumnName)) {
                return Float.valueOf(this.score);
            }
            if (FullTextTuple.FIELD_TUPLES_NAME.equals(syscolumnName)) {
                return this.columnName;
            }
            if (FullTextTuple.FIELD_COLLECTION_NAME.equals(syscolumnName)) {
                return this.tableName;
            }
            if (FullTextTuple.FIELD_RELEVANCE_NAME.equals(syscolumnName)) {
                return Float.valueOf(this.relevance);
            }
            if (FullTextTuple.FIELD_ENTRIES_NAME.equals(syscolumnName)) {
                ArrayList<CallSite> res = new ArrayList<CallSite>();
                for (Pair<Integer, Integer> entry : this.entries) {
                    res.add((CallSite)((Object)(String.valueOf(entry.first) + ":" + String.valueOf(entry.second))));
                }
                return res;
            }
            if (FullTextTuple.FIELD_FRAGMENT_NAME.equals(syscolumnName)) {
                return this.fragment;
            }
            throw new DataspaceException("Wrong system tuple name.");
        }

        public Map<String, Object> getAdditionalData() {
            if (this.additionalData == null) {
                this.additionalData = new HashMap<String, Object>();
            }
            return this.additionalData;
        }

        public void setAdditionalData(Map<String, Object> additionalData) {
            this.additionalData = additionalData;
        }

        public float getRelevance() {
            return this.relevance;
        }

        public void setRelevance(float relevance) {
            this.relevance = relevance;
        }

        public float getTf() {
            return this.tf;
        }

        public float getIdf() {
            return this.idf;
        }

        public float getLengthNorm() {
            return this.lengthNorm;
        }
    }
}

