/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.fulltext;

import com.streamscape.ds.NameManager;
import com.streamscape.ds.persist.fulltext.CollectionColumn;
import com.streamscape.ds.persist.fulltext.DocumentResultSet;
import com.streamscape.ds.persist.fulltext.FullTextIndex;
import com.streamscape.ds.persist.fulltext.FullTextManager;
import com.streamscape.ds.persist.fulltext.FullTextQuery;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;

public interface DocumentIndex {
    public void insert(Session var1, Object[] var2, Table var3, FullTextIndex var4) throws Exception;

    public void delete(Object[] var1, Table var2, FullTextIndex var3) throws Exception;

    public void update(Session var1, Object[] var2, Object[] var3, Table var4, FullTextIndex var5) throws Exception;

    public void deleteAll() throws Exception;

    public DocumentResultSet search(List<CollectionColumn> var1, FullTextQuery var2);

    public void deleteAll(Table var1) throws Exception;

    public void addSpecificProperties(Result var1);

    public Result getTupleStatistics();

    public void batchInsert(Session var1, List<Object[]> var2, Table var3, FullTextIndex var4) throws Exception;

    public void removeDirectory() throws IOException;

    public void release() throws IOException;

    public long commit() throws IOException;

    public void rollback() throws IOException;

    public static boolean exists(NameManager.ObjectName indexName) {
        return Files.exists(Paths.get(FullTextManager.FULL_TEXT_DIR, indexName.schema.getNameString(), indexName.getNameString()), new LinkOption[0]);
    }

    public Path getIndexPath();

    public String getIndexFormat();

    public Date getCreatedDate();

    public Date getModifiedDate();

    public void close();

    public static enum StoreType {
        PERSISTENT,
        MEMORY;

    }
}

