/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.persist.DataFileCache;
import com.streamscape.ds.persist.FileTableCache;
import com.streamscape.ds.persist.PersistentStoreDelegate;
import com.streamscape.ds.persist.RowStoreAVLDisk;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.VirtualTable;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.OtherTypeBytesWrapper;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.omf.FactoryManagerException;
import com.streamscape.omf.java.JSerializerException;
import com.streamscape.omf.java.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class TableTypesValidator {
    private DataspaceStore dataspaceStore;
    private int topN;
    private NormalizeScope normalizeScope;

    public TableTypesValidator(DataspaceStore dataspaceStore, int topN, NormalizeScope normalizeScope) {
        this.dataspaceStore = dataspaceStore;
        this.topN = topN;
        this.normalizeScope = normalizeScope;
        if (this.topN == 0 || this.topN > 10000) {
            this.topN = 10000;
            Trace.logInfo(this, "WARNING: topN = {} is to big, max is {}", topN, this.topN);
        }
    }

    public InvalidTypes validateAllTables() {
        InvalidTypes invalidTypes = new InvalidTypes();
        for (String schemaName : this.dataspaceStore.schemaManager.getSchemaNamesArray()) {
            this.validateAllTables(schemaName, invalidTypes);
        }
        return invalidTypes;
    }

    public InvalidTypes validateAllTables(String schemaName) {
        InvalidTypes invalidTypes = new InvalidTypes();
        this.validateAllTables(schemaName, invalidTypes);
        return invalidTypes;
    }

    public void validateAllTables(String schemaName, InvalidTypes invalidTypes) {
        DataspaceSchema schema = this.dataspaceStore.schemaManager.findSchema(schemaName);
        if (schema == null) {
            throw new DataspaceException("Schema '" + schemaName + "' doesn't exist.");
        }
        for (int i = 0; i < schema.getTables().size(); ++i) {
            Table table = (Table)schema.getTables().get(i);
            this.validateTableTypes(table, invalidTypes);
        }
    }

    public InvalidTypes validateTableTypes(Table table) {
        InvalidTypes invalidTypes = new InvalidTypes();
        this.validateTableTypes(table, invalidTypes);
        return invalidTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateTableTypes(Table table, InvalidTypes invalidTypes) {
        block37: {
            if (table.getTableType() == 12 || table instanceof VirtualTable) {
                return;
            }
            Session session = null;
            try {
                RangeVariable range = new RangeVariable(table, null, null, null, null);
                ArrayList<Integer> indentityColumnsIndexes = new ArrayList<Integer>();
                ArrayList<Integer> primaryKeyColumnsIndexes = new ArrayList<Integer>();
                ArrayList<Integer> otherColumnsIndexes = new ArrayList<Integer>();
                ArrayList otherColumnClasses = new ArrayList();
                for (int i = 0; i < table.getColumnCount(); ++i) {
                    ColumnSchema column = table.getColumn(i);
                    if (column.getDataType().isDistinctType()) {
                        range.addColumn(i);
                        try {
                            if (session == null) {
                                session = this.dataspaceStore.collectionSessionManager.newSysSession();
                                session.setAutoCommit(false);
                            }
                            otherColumnClasses.add(((OtherType)column.getDataType()).resolveInternalClass(session));
                            otherColumnsIndexes.add(i);
                        }
                        catch (Exception exception) {
                            this.invalidateColumn(invalidTypes, column, new ArrayList<Integer>(), new ArrayList<String>(), new ArrayList<Object>(), "", exception.getMessage());
                        }
                    }
                    if (column.isIdentity() || column.isPrimaryKey()) {
                        range.addColumn(i);
                        indentityColumnsIndexes.add(i);
                        continue;
                    }
                    if (!column.isPrimaryKey()) continue;
                    range.addColumn(i);
                    primaryKeyColumnsIndexes.add(i);
                }
                if (otherColumnsIndexes.size() <= 0) break block37;
                session.setTypesCheck(true);
                RangeVariable.RangeIteratorMain rangeIterator = range.getIterator(session);
                try {
                    long elementsCount = table.store.elementCountGetOnly();
                    Trace.logInfo(this, "{} {} columns in table {} of size {}, topN = {} ...", this.normalizeScope != NormalizeScope.NONE ? "Normalizing" : "Checking ", otherColumnsIndexes.size(), table.getObjectName().getSchemaQualifiedStatementName(), elementsCount, this.topN);
                    int checkedRows = 0;
                    int errorsCount = 0;
                    int normalizedCount = 0;
                    int removedCount = 0;
                    while ((this.topN == 0 || errorsCount < this.topN) && rangeIterator.next()) {
                        if (++checkedRows % 100000 == 0) {
                            Trace.logInfo(this, "{} {} columns in table {} of size {}, checkedRows: {}, errorsCount: {}, normalizedCount: {}, removedCount: {}", this.normalizeScope != NormalizeScope.NONE ? "Normalizing" : "Checking ", otherColumnsIndexes.size(), table.getObjectName().getSchemaQualifiedStatementName(), elementsCount, checkedRows, errorsCount, normalizedCount, removedCount);
                        }
                        for (int i = 0; i < otherColumnsIndexes.size(); ++i) {
                            byte[] bytes;
                            DataFileCache cache;
                            PersistentStoreDelegate delegate;
                            int otherColumnIndex = (Integer)otherColumnsIndexes.get(i);
                            Object object = rangeIterator.getCurrent()[otherColumnIndex];
                            Row row = rangeIterator.getCurrentRow();
                            if (!row.hasChanged() && !(object instanceof OtherTypeBytesWrapper) && ((RangeVariable.RangeIteratorBase)rangeIterator).store instanceof PersistentStoreDelegate && (delegate = (PersistentStoreDelegate)((RangeVariable.RangeIteratorBase)rangeIterator).store).getStore() instanceof RowStoreAVLDisk && (row = (cache = ((RowStoreAVLDisk)delegate.getStore()).cache) instanceof FileTableCache ? (Row)cache.get(row, ((RangeVariable.RangeIteratorBase)rangeIterator).store, false) : (Row)cache.getFromFile(row.getPos(), ((RangeVariable.RangeIteratorBase)rangeIterator).store, false, true)) != null) {
                                object = row.getData()[otherColumnIndex];
                            }
                            ColumnSchema otherColumn = table.getColumn(otherColumnIndex);
                            Object error = null;
                            boolean isObsolete = false;
                            if (object instanceof OtherTypeBytesWrapper && (bytes = ((OtherTypeBytesWrapper)object).getBytes()) != null) {
                                try {
                                    if (Utils.isObsolete(bytes)) {
                                        error = "Obsolete or Deprecated data signature. Collection normalization may be required.";
                                        isObsolete = true;
                                    }
                                    try {
                                        object = new OtherTypeWrapper(bytes, true);
                                    }
                                    catch (Exception exception) {
                                        isObsolete = false;
                                        error = "Column value deserialization failed. Cause: " + exception.getMessage();
                                    }
                                }
                                catch (FactoryManagerException | JSerializerException exception) {
                                    error = "Failed to deserialize binary data. Cause: " + Utils.formatExceptionWithUnrepeatedCauses(exception);
                                }
                            }
                            if (!isObsolete && object instanceof OtherTypeWrapper) {
                                try {
                                    object = OtherTypeWrapper.unwrap(object);
                                }
                                catch (Exception exception) {
                                    error = Utils.formatExceptionWithUnrepeatedCauses(exception);
                                }
                                if (object != null && error == null) {
                                    Class clazz = (Class)otherColumnClasses.get(i);
                                    if (clazz == null) {
                                        error = "Type class cannot be resolved.";
                                    } else if (!clazz.isAssignableFrom(object.getClass())) {
                                        error = clazz.getName().equals(object.getClass().getName()) ? "Column type and value type instances mismatch. Try to clear objects cache for this table." : "Column type and value type mismatch. Column class is '" + clazz.getName() + "', value type is '" + object.getClass().getName() + "'.";
                                    }
                                }
                            }
                            if (error == null) continue;
                            ++errorsCount;
                            ArrayList identity = new ArrayList();
                            ArrayList<Integer> identityColumnIndexes = new ArrayList<Integer>();
                            ArrayList<String> identityColumnNames = new ArrayList<String>();
                            ArrayList<Object> identityValues = new ArrayList<Object>();
                            Consumer<Integer> c = index -> {
                                Object value = OtherTypeWrapper.unwrap(rangeIterator.getCurrent()[index]);
                                try {
                                    value = table.getColumn((int)index).getDataType().convertToString(value);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                identity.add(table.getColumn((int)index).getNameString() + "=" + String.valueOf(value));
                                identityColumnNames.add(table.getColumn((int)index).getNameString());
                                identityValues.add(value);
                            };
                            if (primaryKeyColumnsIndexes.size() > 0) {
                                identityColumnIndexes = primaryKeyColumnsIndexes;
                                primaryKeyColumnsIndexes.forEach(c);
                            } else {
                                identityColumnIndexes = indentityColumnsIndexes;
                                indentityColumnsIndexes.forEach(c);
                            }
                            this.invalidateColumn(invalidTypes, otherColumn, identityColumnIndexes, identityColumnNames, identityValues, ((Object)identity).toString(), (String)error);
                            if (this.normalizeScope == NormalizeScope.NONE) continue;
                            if (!session.isInMidTransaction()) {
                                session.startTransaction();
                            }
                            if (isObsolete) {
                                session.addDeleteActionForUpdate(table, row, null);
                                row.getData()[otherColumnIndex] = object;
                                table.insertSingleRowForUpdate(session, table.getRowStore(session), row.getData(), null);
                                ++normalizedCount;
                                continue;
                            }
                            if (this.normalizeScope != NormalizeScope.ALL) continue;
                            session.addDeleteAction(table, row, null);
                            ++removedCount;
                        }
                    }
                    Trace.logInfo(this, "{} table {} of size {} finished, checkedRows: {}, errorsCount: {}, normalizedCount: {}, removedCount: {}", this.normalizeScope != NormalizeScope.NONE ? "Normalizing" : "Checking ", table.getObjectName().getSchemaQualifiedStatementName(), elementsCount, checkedRows, errorsCount, normalizedCount, removedCount);
                }
                catch (Exception exception) {
                    Trace.logError(this, "Types validation for table '" + table.getObjectName().getSchemaQualifiedStatementName() + "' failed.");
                    Trace.logException(this, exception, true);
                }
                finally {
                    rangeIterator.release();
                }
            }
            finally {
                if (session != null) {
                    session.commit(true);
                    session.close();
                }
            }
        }
    }

    private void invalidateColumn(InvalidTypes invalidTypes, ColumnSchema column, List<Integer> identityColumnIndexes, List<String> identityColumnNames, List<Object> identityValues, String identity, String error) {
        InvalidTable invalidTable = invalidTypes.getOrCreateInvalidTable((OtherType)column.getDataType(), column.getObjectName().parent);
        invalidTable.setIdentityColumnIndexes(identityColumnIndexes);
        invalidTable.setIdentityColumnNames(identityColumnNames);
        invalidTable.addInvalidColumn(column, identityValues, identity, error);
    }

    public static enum NormalizeScope {
        NONE,
        OBSOLETE,
        ALL;

    }

    public static class InvalidTypes {
        private Map<OtherType, List<InvalidTable>> invalidTypes = new HashMap<OtherType, List<InvalidTable>>();

        public InvalidTable getOrCreateInvalidTable(OtherType type, NameManager.ObjectName tableName) {
            List<InvalidTable> invalidTables = this.invalidTypes.get(type);
            InvalidTable invalidTable = null;
            if (invalidTables == null) {
                invalidTables = new ArrayList<InvalidTable>();
                this.invalidTypes.put(type, invalidTables);
            } else {
                for (InvalidTable t : invalidTables) {
                    if (!t.objectName.equals(tableName)) continue;
                    invalidTable = t;
                    break;
                }
            }
            if (invalidTable == null) {
                invalidTable = new InvalidTable(tableName);
                invalidTables.add(invalidTable);
            }
            return invalidTable;
        }

        public void add(InvalidTypes otherInvalidTypes) {
            if (otherInvalidTypes == null) {
                return;
            }
            for (Map.Entry<OtherType, List<InvalidTable>> otherInvalidTypeEntry : otherInvalidTypes.invalidTypes.entrySet()) {
                List<InvalidTable> l = this.invalidTypes.get(otherInvalidTypeEntry.getKey());
                if (l != null) {
                    l.addAll((Collection<InvalidTable>)otherInvalidTypeEntry.getValue());
                    continue;
                }
                this.invalidTypes.put(otherInvalidTypeEntry.getKey(), otherInvalidTypeEntry.getValue());
            }
        }

        public Map<OtherType, List<InvalidTable>> getInvalidTypes() {
            return this.invalidTypes;
        }
    }

    public static class InvalidTable {
        private NameManager.ObjectName objectName;
        private List<InvalidColumn> invalidColumns = new ArrayList<InvalidColumn>();
        private List<Integer> identityColumnIndexes;
        private List<String> identityColumnNames;

        public InvalidTable(NameManager.ObjectName objectName) {
            this.objectName = objectName;
        }

        public void addInvalidColumn(ColumnSchema column, List<Object> identityValues, String identity, String error) {
            InvalidColumn invalidColumn = this.invalidColumns.stream().filter(c -> c.getColumnName().equals(column.getObjectName().name)).findAny().orElse(null);
            if (invalidColumn == null) {
                invalidColumn = new InvalidColumn(column.getObjectName().name);
                this.invalidColumns.add(invalidColumn);
            }
            invalidColumn.setError(error);
            invalidColumn.addInvalidRow(new InvalidRow(identityValues.toArray(), identity, error));
        }

        public List<InvalidColumn> getInvalidColumns() {
            return this.invalidColumns;
        }

        public NameManager.ObjectName getObjectName() {
            return this.objectName;
        }

        public void setIdentityColumnIndexes(List<Integer> identityColumnIndexes) {
            this.identityColumnIndexes = identityColumnIndexes;
        }

        public List<Integer> getIdentityColumnIndexes() {
            return this.identityColumnIndexes;
        }

        public void setIdentityColumnNames(List<String> identityColumnNames) {
            this.identityColumnNames = identityColumnNames;
        }
    }

    public static class InvalidColumn {
        private String columnName;
        private List<InvalidRow> invalidRows = new ArrayList<InvalidRow>();
        private String error;

        public InvalidColumn(String columnName) {
            this.columnName = columnName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void addInvalidRow(InvalidRow invalidRow) {
            this.invalidRows.add(invalidRow);
        }

        public List<InvalidRow> getInvalidRows() {
            return this.invalidRows;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getError() {
            return this.error;
        }
    }

    public static class InvalidRow {
        private Object[] identityValues;
        private String identity;
        private String error;

        public InvalidRow(Object[] identityValues, String identity, String error) {
            this.identityValues = identityValues;
            this.identity = identity;
            this.error = error;
        }

        public Object[] getIdentityValues() {
            return this.identityValues;
        }

        public String getError() {
            return this.error;
        }

        public String getIdentity() {
            return this.identity;
        }
    }
}

