/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TableDuplicatesResolver {
    private final DataspaceStore dataspaceStore;
    private final Table table;

    public TableDuplicatesResolver(DataspaceStore dataspaceStore, Table table) {
        this.dataspaceStore = dataspaceStore;
        this.table = table;
    }

    public TableDuplicates findDuplicates(OrderBy orderBy) {
        TableDuplicates result = new TableDuplicates(this.table.getObjectName().schema != null ? this.table.getObjectName().schema.getNameString() : "", this.table.getObjectName().name);
        for (Index index : this.table.getIndexList()) {
            TableIndexDuplicates indexDuplicates;
            if (!index.isUnique() || (indexDuplicates = this.findDuplicates(index.getObjectName().name, orderBy)) == null || !indexDuplicates.hasDuplicates()) continue;
            result.indexDuplicates.add(indexDuplicates);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableIndexDuplicates findDuplicates(String constraintName, OrderBy orderBy) {
        Index index = this.table.getIndex(constraintName);
        if (index != null && index.isUnique()) {
            int i;
            ArrayList<String> constraintColumnNames = new ArrayList<String>();
            ArrayList<Integer> constraintColumnIndexes = new ArrayList<Integer>();
            ArrayList<String> columnNames = new ArrayList<String>();
            for (i = 0; i < index.getColumns().length; ++i) {
                constraintColumnNames.add(this.table.getColumn(index.getColumns()[i]).getNameString());
                constraintColumnIndexes.add(index.getColumns()[i]);
            }
            for (i = 0; i < this.table.getColumnCount(); ++i) {
                columnNames.add(this.table.getColumn(i).getNameString());
            }
            if (orderBy != null && !columnNames.contains(orderBy.columnName)) {
                throw new DataspaceException("There is no column " + orderBy.columnName + " for ordering.");
            }
            TableIndexDuplicates indexDuplicates = new TableIndexDuplicates(constraintName, this.table.getPrimaryIndex() == index, constraintColumnNames, constraintColumnIndexes, columnNames);
            try (Session session = null;){
                session = this.dataspaceStore.collectionSessionManager.newSysSession();
                RangeVariable range = new RangeVariable(this.table, null, null, null, null);
                for (int columnIndex : index.getColumns()) {
                    range.addColumn(columnIndex);
                }
                RangeVariable.RangeIteratorMain rangeIterator = range.getIterator(session);
                try {
                    HashMap<String, Object[]> map = new HashMap<String, Object[]>();
                    while (rangeIterator.next()) {
                        Object[] constraintValues = new Object[index.getColumns().length];
                        Object[] currentRow = rangeIterator.getCurrent();
                        for (int i2 = 0; i2 < index.getColumns().length; ++i2) {
                            constraintValues[i2] = rangeIterator.getCurrent(index.getColumns()[i2]);
                        }
                        String key = Stream.of(constraintValues).map(v -> String.valueOf(v)).collect(Collectors.joining("-"));
                        if (map.containsKey(key)) {
                            Object[] oldDuplicateValues = (Object[])map.get(key);
                            List<Object[]> valuesList = indexDuplicates.duplicateValues.get(key);
                            if (valuesList == null) {
                                valuesList = new ArrayList<Object[]>();
                                indexDuplicates.duplicateValues.put(key, valuesList);
                            }
                            if (oldDuplicateValues != null) {
                                valuesList.add(currentRow);
                                map.put(key, null);
                            }
                            valuesList.add(currentRow);
                            indexDuplicates.duplicateCounts.put(key, indexDuplicates.duplicateCounts.getOrDefault(key, 1) + 1);
                            continue;
                        }
                        map.put(key, constraintValues);
                    }
                }
                catch (Exception exception) {
                    Trace.logError(this, "Duplicates finding failed for table '" + this.table.getObjectName().getSchemaQualifiedStatementName() + "' and constraint '" + constraintName + "'.");
                    Trace.logException(this, exception, true);
                }
                finally {
                    rangeIterator.release();
                }
            }
            if (orderBy != null) {
                int orderByColumnIndex = columnNames.indexOf(orderBy.columnName);
                if (orderByColumnIndex == -1) {
                    throw new DataspaceException("There is no column " + orderBy.columnName + " for ordering.");
                }
                Object object = indexDuplicates.duplicateValues.keySet().iterator();
                while (object.hasNext()) {
                    String key = (String)object.next();
                    List<Object[]> valuesList = indexDuplicates.duplicateValues.get(key);
                    valuesList.sort((o1, o2) -> {
                        Object v1 = o1[orderByColumnIndex];
                        Object v2 = o2[orderByColumnIndex];
                        if (v1 == null && v2 == null) {
                            return 0;
                        }
                        if (v1 == null) {
                            return -1;
                        }
                        if (v2 == null) {
                            return 1;
                        }
                        if (v1 instanceof Comparable && v2 instanceof Comparable) {
                            return ((Comparable)v1).compareTo(v2) * (orderBy.desceding ? -1 : 1);
                        }
                        if (v1 instanceof TimestampData && v2 instanceof TimestampData) {
                            return Long.compare(((TimestampData)v1).getMilliseconds(), ((TimestampData)v2).getMilliseconds()) * (orderBy.desceding ? -1 : 1);
                        }
                        return 0;
                    });
                }
            }
            return indexDuplicates;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixDuplicates(TableIndexDuplicates indexDuplicates) {
        Trace.logInfo(this, "Fixing duplicates for table '{}'  and constraint '{}', duplicate index values: {}, total duplicate rows: {}.", this.table.getObjectName().getSchemaQualifiedStatementName(), indexDuplicates.constraintName, indexDuplicates.duplicateValues.size(), indexDuplicates.duplicateCounts.values().stream().reduce(0, (a, b) -> a + b));
        try (Session session = null;){
            session = this.dataspaceStore.collectionSessionManager.newSysSession();
            Statement deleteStatement = session.compileStatement("DELETE FROM " + this.table.getObjectName().getSchemaQualifiedStatementName() + " WHERE " + indexDuplicates.constraintColumnNames.stream().map(c -> c + " = ?").collect(Collectors.joining(" AND ")));
            Statement insertStatement = session.compileStatement("INSERT INTO " + this.table.getObjectName().getSchemaQualifiedStatementName() + " (" + indexDuplicates.columnNames.stream().collect(Collectors.joining(", ")) + ") VALUES (" + indexDuplicates.columnNames.stream().map(c -> "?").collect(Collectors.joining(", ")) + ")");
            for (Map.Entry<String, List<Object[]>> entry : indexDuplicates.duplicateValues.entrySet()) {
                List<Object[]> values = entry.getValue();
                try {
                    Trace.logInfo(this, "Removing {} duplicate rows for index value '{}', all values: {}", values.size(), entry.getKey(), HTTPUtils.getJsonSerializerForJaxrx().serialize(values));
                }
                catch (SerializerException exception) {
                    Trace.logError(this, "Failed to serialize");
                    Trace.logException(this, exception, false);
                }
                Object[] constraintValues = new Object[indexDuplicates.constraintColumnIndexes.size()];
                for (int i = 0; i < indexDuplicates.constraintColumnIndexes.size(); ++i) {
                    constraintValues[i] = values.get(0)[indexDuplicates.constraintColumnIndexes.get(i)];
                }
                try {
                    Result deleteResult = session.executeCompiledStatement(deleteStatement, constraintValues);
                    Trace.logInfo(this, "Deleted {} rows.", deleteResult.getUpdateCount());
                    Object[] newRowValues = values.get(0);
                    Trace.logInfo(this, "Inserting one row instead of duplicated for index value '{}', row values: {}", entry.getKey(), HTTPUtils.getJsonSerializerForJaxrx().serialize(newRowValues));
                    session.executeCompiledStatement(insertStatement, newRowValues);
                    session.commit(true);
                }
                catch (Exception exception) {
                    Trace.logError(this, "Failed to remove duplicates");
                    Trace.logException(this, exception, false);
                }
            }
        }
    }

    public static class TableDuplicates {
        public String dataspaceName;
        public String tableName;
        public List<TableIndexDuplicates> indexDuplicates;

        public TableDuplicates(String dataspaceName, String tableName) {
            this.dataspaceName = dataspaceName;
            this.tableName = tableName;
            this.indexDuplicates = new ArrayList<TableIndexDuplicates>();
        }

        public boolean hasDuplicates() {
            for (TableIndexDuplicates indexDuplicates : this.indexDuplicates) {
                if (!indexDuplicates.hasDuplicates()) continue;
                return true;
            }
            return false;
        }

        public int getDuplicateKeysCount() {
            return this.indexDuplicates.stream().mapToInt(i -> i.duplicateValues.size()).reduce(0, (a, b) -> a + b);
        }

        public void deleteValues() {
            this.indexDuplicates.stream().forEach(i -> i.deleteValues());
        }
    }

    public static class OrderBy {
        private String columnName;
        private boolean desceding;

        public OrderBy(String columnName, boolean desceding) {
            this.columnName = columnName;
            this.desceding = desceding;
        }

        public String getColumnName() {
            return this.columnName;
        }
    }

    public static class TableIndexDuplicates {
        public String constraintName;
        public boolean isPrimaryKey;
        public List<String> constraintColumnNames;
        public List<Integer> constraintColumnIndexes;
        public List<String> columnNames;
        public Map<String, List<Object[]>> duplicateValues;
        public Map<String, Integer> duplicateCounts;

        public TableIndexDuplicates(String constraintName, boolean isPrimaryKey, List<String> constraintColumnNames, List<Integer> constraintColumnIndexes, List<String> columnNames) {
            this.constraintName = constraintName;
            this.isPrimaryKey = isPrimaryKey;
            this.constraintColumnNames = constraintColumnNames;
            this.constraintColumnIndexes = constraintColumnIndexes;
            this.columnNames = columnNames;
            this.duplicateValues = new HashMap<String, List<Object[]>>();
            this.duplicateCounts = new HashMap<String, Integer>();
        }

        public boolean hasDuplicates() {
            return this.duplicateValues.size() > 0;
        }

        public void deleteValues() {
            for (List<Object[]> values : this.duplicateValues.values()) {
                if (values.size() <= 0) continue;
                Object[] row = values.get(0);
                values.clear();
                for (int i = 0; i < row.length; ++i) {
                    if (this.constraintColumnIndexes.indexOf(i) != -1) continue;
                    row[i] = null;
                }
                values.add(row);
            }
        }
    }
}

