/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.scriptio.ScriptReaderBase;
import com.streamscape.ds.io.scriptio.ScriptReaderDecode;
import com.streamscape.ds.io.scriptio.ScriptReaderText;
import com.streamscape.ds.lib.IntKeyHashMap;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.parser.statement.StatementDML;
import com.streamscape.ds.persist.Crypto;
import com.streamscape.ds.persist.Log;
import com.streamscape.ds.persist.LogFileIndex;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.session.Session;
import java.io.EOFException;

public class ScriptRunner {
    public static void runRecoveryLog(DataspaceStore database, String logFilename, LogFileIndex index) {
        ScriptReaderText scr;
        Trace.logInfo(Log.class, "Processing Dataspace Recovery Log...");
        Crypto crypto = database.dataspaceLogger.getCrypto();
        try {
            scr = crypto == null ? new ScriptReaderText(database, logFilename, false) : new ScriptReaderDecode(database, logFilename, crypto, true);
        }
        catch (Throwable e) {
            if (!(e instanceof EOFException)) {
                database.dataspaceLogger.logSevereEvent("opening log file", e);
            }
            return;
        }
        if (index != null) {
            scr.setIndex(index);
        }
        ScriptRunner.runScript(database, scr);
        Trace.logInfo(Log.class, "Dataspace Recovery Log processed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static void runScript(DataspaceStore database, ScriptReaderBase scr) {
        block25: {
            sessionMap = new IntKeyHashMap();
            current = null;
            currentId = 0;
            statement = null;
            dummy = new StatementDML(81, 2004, null);
            recoveryLogFileName = database.dataspaceLogger.log.getRecoveryLogFileName();
            fullReplay = database.getURLProperties().isPropertyTrue("dtspace.exception_log_processing");
            dummy.setCompileTimestamp(0x7FFFFFFFFFFFFFFFL);
            database.setReferentialIntegrity(false);
            try {
                while (true) lbl-1000:
                // 3 sources

                {
                    try {
                        while (true) {
                            if (!(read = scr.readLoggedStatement(current))) {
                                break block25;
                            }
                            sessionId = scr.getSessionNumber();
                            if ((current == null || currentId != sessionId) && (current = (Session)sessionMap.get(currentId = sessionId)) == null) {
                                current = database.getSessionManager().newSessionForLog(database);
                                sessionMap.put(currentId, current);
                            }
                            if (current.isClosed()) {
                                sessionMap.remove(currentId);
                                continue;
                            }
                            result = null;
                            statementType = scr.getStatementType();
                            switch (statementType) {
                                case 1: {
                                    statement = scr.getLoggedStatement();
                                    try {
                                        cs = current.compileStatement(statement);
                                        result = current.executeCompiledStatement(cs, ValuePool.emptyObjectArray);
                                    }
                                    catch (Throwable e) {
                                        Trace.logException(ScriptRunner.class, e, true);
                                        result = Result.newErrorResult(e);
                                    }
                                    if (result == null || !result.isError()) break;
                                    if (result.getException() != null) {
                                        throw result.getException();
                                    }
                                    throw Error.error(result);
                                }
                                case 4: {
                                    current.commit(false);
                                    break;
                                }
                                case 7: {
                                    break;
                                }
                                case 3: {
                                    current.sessionContext.currentStatement = dummy;
                                    current.beginAction(dummy);
                                    data = scr.getData();
                                    scr.getCurrentTable().insertNoCheckFromLog(current, data);
                                    current.endAction(Result.updateOneResult);
                                    break;
                                }
                                case 2: {
                                    current.sessionContext.currentStatement = dummy;
                                    current.beginAction(dummy);
                                    table = scr.getCurrentTable();
                                    data = scr.getData();
                                    row = table.getDeleteRowFromLog(current, data);
                                    if (row != null) {
                                        current.addDeleteAction(table, row, null);
                                    }
                                    current.endAction(Result.updateOneResult);
                                    break;
                                }
                                case 6: {
                                    name = database.schemaManager.findSchemaHsqlName(scr.getCurrentSchema());
                                    if (name == null) break;
                                    current.setCurrentDataspaceName(name);
                                    break;
                                }
                            }
                            if (!current.isClosed()) continue;
                            sessionMap.remove(currentId);
                        }
                    }
                    catch (DataspaceException e) {
                        scr.resetSessionChanged();
                        scr.handleError(current, Error.error(e, 461, 25, new Object[]{new Integer(0), e.toString()}), scr.getLoggedStatement(), scr.getLineNumber());
                        error = "Recovery Log processing failure, file: " + recoveryLogFileName + ", line: " + scr.getLineNumber() + ", statement  :" + scr.getLoggedStatement();
                        database.dataspaceLogger.logSevereEvent(error, e);
                        if (!fullReplay) ** GOTO lbl-1000
                        throw Error.error(e, 461, error);
                    }
                    catch (OutOfMemoryError e) {
                        error = "out of memory processing log" + recoveryLogFileName + " line: " + scr.getLineNumber();
                        database.dataspaceLogger.logSevereEvent(error, e);
                        throw Error.error(460);
                    }
                    catch (Throwable e) {
                        error = "Recovery Log processing failure, file: " + recoveryLogFileName + ", line: " + scr.getLineNumber() + ", statement: " + scr.getLoggedStatement();
                        scr.handleError(current, Error.error(e, 461, 25, new Object[]{new Integer(0), e.toString()}), scr.getLoggedStatement(), scr.getLineNumber());
                        database.dataspaceLogger.logSevereEvent(error, e);
                        if (!fullReplay) continue;
                        throw Error.error(e, 461, error);
                    }
                    break;
                }
            }
            finally {
                if (scr != null) {
                    scr.close();
                }
                database.getSessionManager().closeAllSessions();
                database.setReferentialIntegrity(true);
            }
        }
    }
}

