/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.ds.DataspaceStore;
import com.streamscape.lib.file.RandomAccessInterface;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

final class ScaledRAFileSimple
implements RandomAccessInterface {
    final RandomAccessFile file;
    final boolean readOnly;
    final DataspaceStore database;

    ScaledRAFileSimple(DataspaceStore database, String name, String openMode) throws FileNotFoundException, IOException {
        this.file = new RandomAccessFile(name, openMode);
        this.database = database;
        this.readOnly = openMode.equals("r");
    }

    @Override
    public long length() throws IOException {
        return this.file.length();
    }

    @Override
    public void seek(long position) throws IOException {
        this.file.seek(position);
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.file.getFilePointer();
    }

    @Override
    public int read() throws IOException {
        return this.file.read();
    }

    @Override
    public long readLong() throws IOException {
        return this.file.readLong();
    }

    @Override
    public int readInt() throws IOException {
        return this.file.readInt();
    }

    @Override
    public void read(byte[] b, int offset, int length) throws IOException {
        this.file.readFully(b, offset, length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.file.write(b, off, len);
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.file.writeInt(i);
    }

    @Override
    public void writeLong(long i) throws IOException {
        this.file.writeLong(i);
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean ensureLength(long newLong) {
        return true;
    }

    @Override
    public boolean setLength(long newLength) {
        try {
            this.file.setLength(newLength);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public DataspaceStore getDatabase() {
        return null;
    }

    @Override
    public void synch() {
        try {
            this.file.getFD().sync();
        }
        catch (IOException e) {
            this.database.dataspaceLogger.logSevereEvent("RA file sync error ", e);
        }
    }
}

