/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.lib.HsqlByteArrayInputStream;
import com.streamscape.ds.lib.HsqlByteArrayOutputStream;
import com.streamscape.ds.persist.ScaledRAFileHybrid;
import com.streamscape.ds.persist.ScaledRAFileInJar;
import com.streamscape.lib.file.RandomAccessInterface;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

final class ScaledRAFile
implements RandomAccessInterface {
    static final int DATA_FILE_RAF = 0;
    static final int DATA_FILE_NIO = 1;
    static final int DATA_FILE_JAR = 2;
    static final int DATA_FILE_STORED = 3;
    static final int DATA_FILE_SINGLE = 4;
    static final int DATA_FILE_TEXT = 5;
    static final int bufferScale = 12;
    static final int bufferSize = 4096;
    static final long bufferMask = -4096L;
    final DataspaceStore database;
    final RandomAccessFile file;
    final FileDescriptor fileDescriptor;
    private final boolean readOnly;
    final String fileName;
    final byte[] buffer;
    final HsqlByteArrayInputStream bufferArray;
    final byte[] valueBuffer;
    final HsqlByteArrayOutputStream valueBufferArrayOutput;
    final HsqlByteArrayInputStream valueBufferArrayInput;
    long bufferOffset;
    long fileLength;
    final boolean extendLength;
    long seekPosition;
    int cacheHit;

    static RandomAccessInterface newScaledRAFile(DataspaceStore database, String name, boolean readonly, int type) throws FileNotFoundException, IOException {
        if (type == 3) {
            try {
                String cname = database.getURLProperties().getProperty("storage_class_name");
                String skey = database.getURLProperties().getProperty("storage_key");
                Class<?> zclass = Class.forName(cname);
                Constructor<?> constructor = zclass.getConstructor(String.class, Boolean.class, Object.class);
                return (RandomAccessInterface)constructor.newInstance(name, new Boolean(readonly), skey);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IOException();
            }
        }
        if (type == 2) {
            return new ScaledRAFileInJar(name);
        }
        if (type == 5) {
            return new ScaledRAFile(database, name, readonly, false);
        }
        if (type == 0) {
            return new ScaledRAFile(database, name, readonly, true);
        }
        File file = new File(name);
        long length = file.length();
        if (length > database.dataspaceLogger.propNioMaxSize) {
            return new ScaledRAFile(database, name, readonly, true);
        }
        try {
            Class.forName("java.nio.MappedByteBuffer");
            return new ScaledRAFileHybrid(database, name, readonly);
        }
        catch (Exception e) {
            return new ScaledRAFile(database, name, readonly, true);
        }
    }

    ScaledRAFile(DataspaceStore database, String fileName, boolean readOnly, boolean extendLength) throws FileNotFoundException, IOException {
        this.database = database;
        this.fileName = fileName;
        this.readOnly = readOnly;
        this.extendLength = extendLength;
        String accessMode = readOnly ? "r" : (extendLength ? "rw" : "rws");
        this.file = new RandomAccessFile(fileName, accessMode);
        this.buffer = new byte[4096];
        this.bufferArray = new HsqlByteArrayInputStream(this.buffer);
        this.valueBuffer = new byte[8];
        this.valueBufferArrayOutput = new HsqlByteArrayOutputStream(this.valueBuffer);
        this.valueBufferArrayInput = new HsqlByteArrayInputStream(this.valueBuffer);
        this.fileDescriptor = this.file.getFD();
        this.fileLength = this.length();
        this.readIntoBuffer();
    }

    @Override
    public long length() throws IOException {
        return this.file.length();
    }

    @Override
    public void seek(long position) throws IOException {
        if (this.readOnly && this.fileLength < position) {
            throw new IOException("read beyond end of file");
        }
        this.seekPosition = position;
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.seekPosition;
    }

    private void readIntoBuffer() throws IOException {
        long filePos = this.seekPosition & 0xFFFFFFFFFFFFF000L;
        long readLength = this.fileLength - filePos;
        if (readLength > (long)this.buffer.length) {
            readLength = this.buffer.length;
        }
        if (readLength < 0L) {
            throw new IOException("read beyond end of file");
        }
        try {
            this.file.seek(filePos);
            this.file.readFully(this.buffer, 0, (int)readLength);
            this.bufferOffset = filePos;
        }
        catch (IOException e) {
            this.resetPointer();
            this.database.dataspaceLogger.logWarningEvent(" " + filePos + " " + readLength, e);
            throw e;
        }
    }

    @Override
    public int read() throws IOException {
        try {
            if (this.seekPosition >= this.fileLength) {
                return -1;
            }
            if (this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
                this.readIntoBuffer();
            } else {
                ++this.cacheHit;
            }
            int val = this.buffer[(int)(this.seekPosition - this.bufferOffset)] & 0xFF;
            ++this.seekPosition;
            return val;
        }
        catch (IOException e) {
            this.resetPointer();
            this.database.dataspaceLogger.logWarningEvent("read failed", e);
            throw e;
        }
    }

    @Override
    public long readLong() throws IOException {
        this.valueBufferArrayInput.reset();
        this.read(this.valueBuffer, 0, 8);
        return this.valueBufferArrayInput.readLong();
    }

    @Override
    public int readInt() throws IOException {
        this.valueBufferArrayInput.reset();
        this.read(this.valueBuffer, 0, 4);
        return this.valueBufferArrayInput.readInt();
    }

    @Override
    public void read(byte[] b, int offset, int length) throws IOException {
        try {
            if (this.seekPosition + (long)length > this.fileLength) {
                throw new EOFException();
            }
            if (length > this.buffer.length && (this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length)) {
                this.file.seek(this.seekPosition);
                this.file.readFully(b, offset, length);
                this.seekPosition += (long)length;
                return;
            }
            if (this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
                this.readIntoBuffer();
            } else {
                ++this.cacheHit;
            }
            this.bufferArray.reset();
            if (this.seekPosition - this.bufferOffset != this.bufferArray.skip(this.seekPosition - this.bufferOffset)) {
                throw new EOFException();
            }
            int bytesRead = this.bufferArray.read(b, offset, length);
            this.seekPosition += (long)bytesRead;
            if (bytesRead < length) {
                this.file.seek(this.seekPosition);
                this.file.readFully(b, offset + bytesRead, length - bytesRead);
                this.seekPosition += (long)(length - bytesRead);
            }
        }
        catch (IOException e) {
            this.resetPointer();
            throw e;
        }
    }

    @Override
    public void write(byte[] b, int off, int length) throws IOException {
        try {
            this.file.seek(this.seekPosition);
            if (this.seekPosition < this.bufferOffset + (long)this.buffer.length && this.seekPosition + (long)length > this.bufferOffset) {
                this.writeToBuffer(b, off, length);
            }
            this.file.write(b, off, length);
            this.seekPosition += (long)length;
            if (!this.extendLength && this.fileLength < this.seekPosition) {
                this.fileLength = this.seekPosition;
            }
        }
        catch (IOException e) {
            this.resetPointer();
            this.database.dataspaceLogger.logWarningEvent("failed to write a byte array", e);
            throw e;
        }
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.valueBufferArrayOutput.reset();
        this.valueBufferArrayOutput.writeInt(i);
        this.write(this.valueBuffer, 0, 4);
    }

    @Override
    public void writeLong(long i) throws IOException {
        this.valueBufferArrayOutput.reset();
        this.valueBufferArrayOutput.writeLong(i);
        this.write(this.valueBuffer, 0, 8);
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean ensureLength(long newLength) {
        if (newLength <= this.fileLength) {
            return true;
        }
        try {
            this.extendLength(newLength);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean setLength(long newLength) {
        try {
            this.file.setLength(newLength);
            this.file.seek(0L);
            this.fileLength = this.file.length();
            this.seekPosition = 0L;
            this.readIntoBuffer();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public void synch() {
        try {
            this.fileDescriptor.sync();
        }
        catch (IOException e) {
            this.database.dataspaceLogger.logSevereEvent("RA file sync error ", e);
        }
    }

    private void writeToBuffer(byte[] b, int off, int len) throws IOException {
        int maxLength;
        int copyLength = len;
        int copyOffset = off;
        int bufferPos = (int)(this.seekPosition - this.bufferOffset);
        if (bufferPos < 0) {
            copyOffset -= bufferPos;
            copyLength += bufferPos;
            bufferPos = 0;
        }
        if ((maxLength = (int)(this.bufferOffset + (long)this.buffer.length - this.seekPosition)) < copyLength) {
            copyLength = maxLength;
        }
        System.arraycopy(b, copyOffset, this.buffer, bufferPos, copyLength);
    }

    private long getExtendLength(long position) {
        if (!this.extendLength) {
            return position;
        }
        int scaleUp = position < 262144L ? 2 : (position < 0x100000L ? 6 : (position < 0x1000000L ? 8 : 10));
        position = ScaledRAFile.getBinaryNormalisedCeiling(position, 12 + scaleUp);
        return position;
    }

    private void extendLength(long position) throws IOException {
        long newSize = this.getExtendLength(position);
        if (newSize > this.fileLength) {
            try {
                this.file.seek(newSize - 1L);
                this.file.write(0);
                this.fileLength = newSize;
            }
            catch (IOException e) {
                this.database.dataspaceLogger.logWarningEvent("data file enlarge failed ", e);
                throw e;
            }
        }
    }

    private void resetPointer() {
        try {
            this.seekPosition = 0L;
            this.fileLength = this.length();
            this.readIntoBuffer();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static long getBinaryNormalisedCeiling(long value, int scale) {
        long mask = -1L << scale;
        long newSize = value & mask;
        if (newSize != value) {
            newSize += (long)(1 << scale);
        }
        return newSize;
    }
}

