/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.lib.file.RandomAccessInterface;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ScaledRAAppendableFile
implements RandomAccessInterface {
    private final DataspaceStore database;
    private RandomAccessFile randomAccessFile;
    private final String fileName;
    private final byte[] buffer;
    private long bufferOffset;
    private int bufferLength = -1;
    private long seekPosition;
    private long lastPositionRead = -1L;
    private boolean wasNotFound = false;
    private boolean withLock = false;

    ScaledRAAppendableFile(DataspaceStore database, String fileName) {
        this.database = database;
        this.fileName = fileName;
        this.buffer = new byte[10240];
        if (this.withLock) {
            try {
                this.ensureOpenFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public long length() throws IOException {
        File file = new File(this.fileName);
        long length = file.length();
        if (length == 0L) {
            this.checkFileExists();
        }
        return length;
    }

    @Override
    public void seek(long position) throws IOException {
        this.seekPosition = position;
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.seekPosition;
    }

    private void readIntoBuffer() throws IOException {
        if (!this.withLock && this.length() == this.lastPositionRead && this.seekPosition == this.lastPositionRead && !this.wasNotFound) {
            return;
        }
        try {
            this.ensureOpenFile();
            this.randomAccessFile.seek(this.seekPosition);
            this.bufferLength = this.randomAccessFile.read(this.buffer, 0, this.buffer.length);
            this.wasNotFound = false;
            this.lastPositionRead = this.seekPosition;
            if (this.bufferLength == -1) {
                this.checkFileExists();
            }
            this.bufferOffset = this.seekPosition;
        }
        catch (IOException e) {
            this.lastPositionRead = -1L;
            this.resetPointerAndReopenFile();
            throw e;
        }
        finally {
            if (!this.withLock) {
                this.closeQuiet();
            }
        }
    }

    @Override
    public int read() throws IOException {
        if (this.bufferLength <= 0 || this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.bufferLength) {
            this.bufferOffset = 0L;
            this.bufferLength = -1;
            this.readIntoBuffer();
        }
        int val = -1;
        if (this.bufferLength > 0) {
            val = this.buffer[(int)(this.seekPosition - this.bufferOffset)] & 0xFF;
            ++this.seekPosition;
        }
        return val;
    }

    @Override
    public void read(byte[] b, int offset, int length) throws IOException {
        block8: {
            if (this.bufferLength <= 0 || this.seekPosition < this.bufferOffset || this.seekPosition + (long)offset >= this.bufferOffset + (long)this.bufferLength) {
                try {
                    this.ensureOpenFile();
                    this.randomAccessFile.seek(this.seekPosition);
                    int count = this.randomAccessFile.read(b, 0, length);
                    this.wasNotFound = false;
                    if (count != length) {
                        throw new IOException("Failed to read " + length + " bytes from randomAccessFile table randomAccessFile.");
                    }
                    break block8;
                }
                catch (IOException e) {
                    this.database.dataspaceLogger.logWarningEvent("read failed", e);
                    throw e;
                }
                finally {
                    this.resetPointerAndReopenFile();
                    if (!this.withLock) {
                        this.closeQuiet();
                    }
                }
            }
            System.arraycopy(this.buffer, (int)(this.seekPosition - this.bufferOffset), b, offset, length);
            this.seekPosition += (long)length;
        }
    }

    private void checkFileExists() throws FileNotFoundException {
        if (!new File(this.fileName).exists()) {
            this.wasNotFound = true;
            throw new FileNotFoundException("File " + this.fileName + " not found.");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.randomAccessFile != null) {
            this.randomAccessFile.close();
            this.randomAccessFile = null;
        }
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void synch() {
    }

    private void resetPointerAndReopenFile() {
        try {
            this.seekPosition = 0L;
            if (this.withLock) {
                this.reopenFile();
            }
            this.bufferOffset = 0L;
            this.bufferLength = -1;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void reopenFile() throws IOException {
        if (this.randomAccessFile != null) {
            this.closeQuiet();
            this.bufferOffset = 0L;
            this.bufferLength = -1;
        }
        this.ensureOpenFile();
    }

    private void ensureOpenFile() throws IOException {
        if (this.randomAccessFile == null) {
            this.randomAccessFile = new RandomAccessFile(this.fileName, "r");
        }
    }

    private void closeQuiet() {
        if (this.randomAccessFile != null) {
            try {
                this.randomAccessFile.close();
            }
            catch (Exception exception) {
                Trace.logError(this, "Failed to close file " + this.fileName);
                Trace.logException(this, exception, true);
            }
            this.randomAccessFile = null;
        }
    }

    @Override
    public boolean setLength(long newLength) {
        boolean bl;
        RandomAccessFile fileForWrite = new RandomAccessFile(this.fileName, "rw");
        try {
            fileForWrite.setLength(newLength);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileForWrite.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to set length for '" + this.fileName + "'. Cause: " + exception.getMessage());
            }
        }
        fileForWrite.close();
        return bl;
    }

    @Override
    public long readLong() throws IOException {
        throw new RuntimeException("ScaledRAAppendableFile doesn't support readLong");
    }

    @Override
    public int readInt() throws IOException {
        throw new RuntimeException("ScaledRAAppendableFile doesn't support readInt");
    }

    @Override
    public void write(byte[] b, int off, int length) throws IOException {
        throw new RuntimeException("ScaledRAAppendableFile doesn't support write");
    }

    @Override
    public void writeInt(int i) throws IOException {
        throw new RuntimeException("ScaledRAAppendableFile doesn't support writeInt");
    }

    @Override
    public void writeLong(long i) throws IOException {
        throw new RuntimeException("ScaledRAAppendableFile doesn't support writeLong");
    }

    @Override
    public boolean ensureLength(long newLength) {
        throw new RuntimeException("ScaledRAAppendableFile doesn't support ensureLength");
    }
}

