/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.RowInputInterface;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.persist.CachedObject;
import com.streamscape.ds.persist.DataFileCache;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.PersistentStoreCollection;
import com.streamscape.ds.persist.RowStoreAVL;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.persist.row.RowAVL;
import com.streamscape.ds.persist.row.RowAction;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RowStoreAVLMemory
extends RowStoreAVL
implements PersistentStore {
    DataspaceStore database;
    AtomicInteger rowIdSequence = new AtomicInteger(0);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();

    public RowStoreAVLMemory(PersistentStoreCollection manager, Table table) {
        this.database = table.database;
        this.manager = manager;
        this.table = table;
        this.indexList = table.getIndexList();
        this.accessorList = new CachedObject[this.indexList.length];
        manager.setStore(table, this);
    }

    @Override
    public boolean isMemory() {
        return true;
    }

    @Override
    public int getAccessCount() {
        return 0;
    }

    @Override
    public void set(CachedObject object) {
    }

    @Override
    public CachedObject get(int i) {
        throw Error.runtimeError(201, "RowStoreAVMemory");
    }

    @Override
    public CachedObject get(int i, boolean keep) {
        throw Error.runtimeError(201, "RowStoreAVLMemory");
    }

    @Override
    public CachedObject get(CachedObject object, boolean keep) {
        return object;
    }

    @Override
    public int getStorageSize(int i) {
        return 0;
    }

    @Override
    public void add(CachedObject object) {
    }

    @Override
    public CachedObject get(RowInputInterface in) {
        return null;
    }

    @Override
    public CachedObject getNewInstance(int size) {
        return null;
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object, boolean tx) {
        int id = this.rowIdSequence.getAndIncrement();
        RowAVL row = new RowAVL(this.table, (Object[])object, id, this);
        if (tx) {
            RowAction.addInsertAction(session, this.table, row);
        }
        return row;
    }

    @Override
    public void removeAll() {
        this.elementCount.set(0L);
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public void remove(int i) {
    }

    @Override
    public void removePersistence(int i) {
    }

    @Override
    public void release(int i) {
    }

    @Override
    public void commitPersistence(CachedObject row) {
    }

    @Override
    public void commitRow(Session session, Row row, int changeAction, int txModel) {
        Object[] data = row.getData();
        switch (changeAction) {
            case 2: {
                this.database.dataspaceLogger.writeDeleteStatement(session, (Table)this.table, data);
                break;
            }
            case 1: {
                this.database.dataspaceLogger.writeInsertStatement(session, row, (Table)this.table);
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                this.delete(session, row);
            }
        }
    }

    @Override
    public void commitRowWith2PCLogOnly(Session session, Row row, int changeAction, int txModel) {
        Object[] data = row.getData();
        switch (changeAction) {
            case 2: {
                this.database.dataspaceLogger.writeDeleteStatement(session, (Table)this.table, data);
                break;
            }
            case 1: {
                this.database.dataspaceLogger.writeInsertStatement(session, row, (Table)this.table);
                break;
            }
            case 4: {
                break;
            }
        }
    }

    @Override
    public void commitRowWith2PCNoLog(Session session, Row row, int changeAction, int txModel) {
        switch (changeAction) {
            case 2: {
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                this.delete(session, row);
            }
        }
    }

    @Override
    public void rollbackRow(Session session, Row row, int changeAction, int txModel) {
        switch (changeAction) {
            case 2: {
                if (txModel != 0) break;
                ((RowAVL)row).setNewNodes(this);
                this.indexRow(session, row);
                break;
            }
            case 1: {
                if (txModel != 0) break;
                this.delete(session, row);
                this.remove(row.getPos());
                break;
            }
            case 4: {
                if (txModel != 0) break;
                this.remove(row.getPos());
            }
        }
    }

    @Override
    public DataFileCache getCache() {
        return null;
    }

    @Override
    public void setCache(DataFileCache cache) {
    }

    @Override
    public void release() {
        this.setTimestamp(0L);
        ArrayUtil.fillArray(this.accessorList, null);
        this.elementCount.set(0L);
    }

    @Override
    public void writeLock() {
        this.writeLock.lock();
    }

    @Override
    public void writeUnlock() {
        this.writeLock.unlock();
    }

    @Override
    public void readLock() {
        this.readLock.lock();
    }

    @Override
    public void readUnlock() {
        this.readLock.unlock();
    }
}

