/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.persist.CachedObject;
import com.streamscape.ds.persist.PersistentStoreCollection;
import com.streamscape.ds.persist.RowStoreAVL;
import com.streamscape.ds.persist.RowStoreAVLHybrid;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.persist.index.NodeAVL;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.persist.row.RowAVL;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableBase;
import com.streamscape.ds.session.Session;

public class RowStoreAVLHybridExtended
extends RowStoreAVLHybrid {
    public RowStoreAVLHybridExtended(Session session, PersistentStoreCollection manager, TableBase table, boolean diskBased) {
        super(session, manager, table, diskBased);
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object, boolean tx) {
        if (this.indexList != this.table.getIndexList()) {
            this.resetAccessorKeys(this.table.getIndexList());
        }
        return super.getNewCachedObject(session, object, tx);
    }

    @Override
    public void indexRow(Session session, Row row) {
        NodeAVL node = ((RowAVL)row).getNode(0);
        int count = 0;
        while (node != null) {
            ++count;
            node = node.nNext;
        }
        if (count != this.indexList.length) {
            this.resetAccessorKeys(this.table.getIndexList());
            ((RowAVL)row).setNewNodes(this);
        }
        super.indexRow(session, row);
    }

    @Override
    public void delete(Session session, Row row) {
        row = ((Table)this.table).getDeleteRowFromLog(session, row.getData());
        super.delete(session, row);
    }

    @Override
    public CachedObject getAccessor(Index key) {
        int position = key.getPosition();
        if (position >= this.accessorList.length || this.indexList[position] != key) {
            this.resetAccessorKeys(this.table.getIndexList());
            return this.getAccessor(key);
        }
        return this.accessorList[position];
    }

    @Override
    public synchronized void resetAccessorKeys(Index[] keys) {
        if (this.indexList.length == 0 || this.accessorList[0] == null) {
            this.indexList = keys;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        if (this.isCached) {
            this.resetAccessorKeysForCached();
            return;
        }
        super.resetAccessorKeys(keys);
    }

    private void resetAccessorKeysForCached() {
        RowStoreAVLHybridExtended tempStore = new RowStoreAVLHybridExtended(this.session, this.manager, this.table, true);
        tempStore.changeToDiskTable(this.session);
        RowIterator iterator = this.table.rowIterator(this);
        while (iterator.hasNext()) {
            Row row = iterator.getNextRow();
            Row newRow = (Row)((RowStoreAVLHybrid)tempStore).getNewCachedObject(this.session, row.getData(), false);
            ((RowStoreAVL)tempStore).indexRow(this.session, newRow);
        }
        this.indexList = tempStore.indexList;
        this.accessorList = tempStore.accessorList;
    }
}

