/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.RowInputInterface;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.persist.CachedObject;
import com.streamscape.ds.persist.DataFileCache;
import com.streamscape.ds.persist.DataFileCacheSession;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.PersistentStoreCollection;
import com.streamscape.ds.persist.PersistentStoreCollectionSession;
import com.streamscape.ds.persist.RowStoreAVL;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.persist.row.RowAVL;
import com.streamscape.ds.persist.row.RowAVLDisk;
import com.streamscape.ds.persist.row.RowAction;
import com.streamscape.ds.schema.table.TableBase;
import com.streamscape.ds.session.Session;
import java.io.IOException;

public class RowStoreAVLHybrid
extends RowStoreAVL
implements PersistentStore {
    DataFileCacheSession cache;
    private int maxMemoryRowCount;
    private boolean useDisk;
    boolean isCached;
    int rowIdSequence = 0;

    public RowStoreAVLHybrid(Session session, PersistentStoreCollection manager, TableBase table, boolean diskBased) {
        this.session = session;
        this.manager = manager;
        this.table = table;
        this.maxMemoryRowCount = session.getResultMemoryRowCount();
        this.useDisk = diskBased;
        if (this.maxMemoryRowCount == 0) {
            this.useDisk = false;
        }
        if (table.getTableType() == 10) {
            this.setTimestamp(session.getActionTimestamp());
        }
        this.resetAccessorKeys(table.getIndexList());
        manager.setStore(table, this);
    }

    @Override
    public boolean isMemory() {
        return !this.isCached;
    }

    @Override
    public void setMemory(boolean mode) {
        this.useDisk = !mode;
    }

    @Override
    public synchronized int getAccessCount() {
        return this.isCached ? this.cache.getAccessCount() : 0;
    }

    @Override
    public void set(CachedObject object) {
    }

    @Override
    public CachedObject get(int i) {
        try {
            if (this.isCached) {
                return this.cache.get(i, (PersistentStore)this, false);
            }
            throw Error.runtimeError(201, "RowStoreAVLHybrid");
        }
        catch (DataspaceException e) {
            return null;
        }
    }

    @Override
    public CachedObject get(int i, boolean keep) {
        try {
            if (this.isCached) {
                return this.cache.get(i, (PersistentStore)this, keep);
            }
            throw Error.runtimeError(201, "RowStoreAVLHybrid");
        }
        catch (DataspaceException e) {
            return null;
        }
    }

    @Override
    public CachedObject get(CachedObject object, boolean keep) {
        try {
            if (this.isCached) {
                return this.cache.get(object, (PersistentStore)this, keep);
            }
            return object;
        }
        catch (DataspaceException e) {
            return null;
        }
    }

    @Override
    public int getStorageSize(int i) {
        try {
            if (this.isCached) {
                return this.cache.get(i, (PersistentStore)this, false).getStorageSize();
            }
            return 0;
        }
        catch (DataspaceException e) {
            return 0;
        }
    }

    @Override
    public void add(CachedObject object) {
        if (this.isCached) {
            int size = object.getRealSize(this.cache.rowOut);
            size += this.indexList.length * 16;
            size = this.cache.rowOut.getStorageSize(size);
            object.setStorageSize(size);
            this.cache.add(object);
        }
    }

    @Override
    public CachedObject get(RowInputInterface in) {
        try {
            if (this.isCached) {
                return new RowAVLDisk(this.table, in);
            }
        }
        catch (DataspaceException e) {
            return null;
        }
        catch (IOException e1) {
            return null;
        }
        return null;
    }

    @Override
    public CachedObject getNewInstance(int size) {
        return null;
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object, boolean tx) {
        if (!this.isCached && this.useDisk && this.elementCount.get() >= (long)this.maxMemoryRowCount) {
            this.changeToDiskTable(session);
        }
        if (this.isCached) {
            RowAVLDisk row = new RowAVLDisk(this.table, (Object[])object, this);
            this.add(row);
            if (tx) {
                RowAction.addInsertAction(session, this.table, row);
            }
            return row;
        }
        int id = this.rowIdSequence++;
        RowAVL row = new RowAVL(this.table, (Object[])object, id, this);
        if (tx) {
            RowAction.addInsertAction(session, this.table, row);
        }
        return row;
    }

    @Override
    public void removeAll() {
        this.elementCount.set(0L);
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public void remove(int i) {
        if (this.isCached) {
            this.cache.remove(i, this);
        }
    }

    @Override
    public void removePersistence(int i) {
    }

    @Override
    public void release(int i) {
        if (this.isCached) {
            this.cache.release(i);
        }
    }

    @Override
    public void commitPersistence(CachedObject row) {
    }

    @Override
    public void commitRow(Session session, Row row, int changeAction, int txModel) {
        switch (changeAction) {
            case 2: {
                this.remove(row.getPos());
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                this.remove(row.getPos());
                break;
            }
            case 3: {
                this.delete(session, row);
            }
        }
    }

    @Override
    public void commitRowWith2PCLogOnly(Session session, Row row, int type, int txModel) {
    }

    @Override
    public void commitRowWith2PCNoLog(Session session, Row row, int changeAction, int txModel) {
        switch (changeAction) {
            case 2: {
                this.remove(row.getPos());
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                this.remove(row.getPos());
                break;
            }
            case 3: {
                this.delete(session, row);
            }
        }
    }

    @Override
    public void rollbackRow(Session session, Row row, int changeAction, int txModel) {
        switch (changeAction) {
            case 2: {
                row = (Row)this.get(row, true);
                ((RowAVL)row).setNewNodes(this);
                row.keepInMemory(false);
                this.indexRow(session, row);
                break;
            }
            case 1: {
                this.delete(session, row);
                this.remove(row.getPos());
                break;
            }
            case 4: {
                this.remove(row.getPos());
            }
        }
    }

    @Override
    public DataFileCache getCache() {
        return this.cache;
    }

    @Override
    public void setCache(DataFileCache cache) {
        throw Error.runtimeError(201, "RowStoreAVLHybrid");
    }

    @Override
    public void release() {
        ArrayUtil.fillArray(this.accessorList, null);
        if (this.isCached) {
            this.cache.adjustStoreCount(-1);
            this.cache = null;
            this.isCached = false;
        }
        this.manager.setStore(this.table, null);
        this.elementCount.set(0L);
    }

    @Override
    public void delete(Session session, Row row) {
        super.delete(session, row);
    }

    @Override
    public synchronized void resetAccessorKeys(Index[] keys) {
        if (this.indexList.length == 0 || this.accessorList[0] == null) {
            this.indexList = keys;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        if (this.isCached) {
            throw Error.runtimeError(201, "RowStoreAVLHybrid");
        }
        super.resetAccessorKeys(keys);
    }

    public final void changeToDiskTable(Session session) {
        this.cache = ((PersistentStoreCollectionSession)this.manager).getResultCache();
        if (this.cache != null) {
            RowIterator iterator = this.table.rowIterator(this);
            ArrayUtil.fillArray(this.accessorList, null);
            this.elementCount.set(0L);
            this.isCached = true;
            this.cache.adjustStoreCount(1);
            while (iterator.hasNext()) {
                Row row = iterator.getNextRow();
                Row newRow = (Row)this.getNewCachedObject(session, row.getData(), false);
                this.indexRow(session, newRow);
                row.destroy();
            }
        }
        this.maxMemoryRowCount = Integer.MAX_VALUE;
    }
}

