/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.RowInputInterface;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.persist.CachedObject;
import com.streamscape.ds.persist.FileTableCache;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.PersistentStoreCollection;
import com.streamscape.ds.persist.RowStoreAVLDisk;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.persist.row.RowAVL;
import com.streamscape.ds.persist.row.RowAVLDiskData;
import com.streamscape.ds.persist.row.RowAction;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import java.io.IOException;

public class RowStoreAVLDiskData
extends RowStoreAVLDisk {
    RowAVLDiskData currentRow;

    public RowStoreAVLDiskData(PersistentStoreCollection manager, Table table) {
        super(manager, null, table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject getData(CachedObject object, boolean keep) {
        this.cache.writeLock.lock();
        try {
            this.currentRow = (RowAVLDiskData)object;
            CachedObject cachedObject = object = this.cache.get(object, (PersistentStore)this, keep);
            return cachedObject;
        }
        finally {
            this.currentRow = null;
            this.cache.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedObject get(CachedObject object, boolean keep) {
        this.cache.writeLock.lock();
        try {
            this.currentRow = (RowAVLDiskData)object;
            CachedObject cachedObject = object = this.cache.get(object, (PersistentStore)this, keep);
            return cachedObject;
        }
        finally {
            this.currentRow = null;
            this.cache.writeLock.unlock();
        }
    }

    @Override
    public void add(CachedObject object) {
        this.cache.writeLock.lock();
        try {
            int size = object.getRealSize(this.cache.rowOut);
            object.setStorageSize(size);
            this.cache.add(object);
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    @Override
    public CachedObject get(RowInputInterface in) {
        try {
            Object[] data = RowAVLDiskData.getRowData(this.table, in);
            if (this.currentRow == null) {
                RowAVLDiskData row = new RowAVLDiskData(this, this.table, data, in);
                row.setChanged(false);
                if (!in.isTypesCheck()) {
                    ((FileTableCache)this.cache).addInit(row);
                }
                return row;
            }
            this.currentRow.setData(data);
            return this.currentRow;
        }
        catch (IOException e) {
            throw Error.error(484, e);
        }
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object, boolean tx) {
        RowAVLDiskData row = new RowAVLDiskData(this, this.table, (Object[])object);
        this.add(row);
        if (tx) {
            RowAction.addInsertAction(session, this.table, row);
        }
        return row;
    }

    @Override
    public void indexRow(Session session, Row row) {
        super.indexRow(session, row);
    }

    @Override
    public void set(CachedObject object) {
    }

    @Override
    public void removeAll() {
        this.elementCount.set(0L);
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public void remove(int i) {
        this.cache.remove(i, this);
    }

    public void removePersistence(Row row) {
        this.cache.removePersistence(row);
    }

    @Override
    public void release(int i) {
        this.cache.release(i);
    }

    @Override
    public CachedObject getAccessor(Index key) {
        int position = key.getPosition();
        if (position >= this.accessorList.length) {
            throw Error.runtimeError(201, "RowStoreAVL");
        }
        return this.accessorList[position];
    }

    @Override
    public void commitPersistence(CachedObject row) {
        try {
            this.cache.saveRow(row);
        }
        catch (DataspaceException dataspaceException) {
            // empty catch block
        }
    }

    @Override
    public void commitRow(Session session, Row row, int changeAction, int txModel) {
        switch (changeAction) {
            case 2: {
                this.removePersistence(row);
                break;
            }
            case 1: {
                this.commitPersistence(row);
                break;
            }
            case 4: {
                if (txModel == 0) {
                    this.remove(row.getPos());
                    break;
                }
                this.delete(session, row);
                this.remove(row.getPos());
                break;
            }
            case 3: {
                if (txModel == 0) break;
                this.delete(session, row);
                this.remove(row.getPos());
            }
        }
    }

    @Override
    public void commitRowWith2PCLogOnly(Session session, Row row, int changeAction, int txModel) {
    }

    public void commitRowWith2PCNoOnly(Session session, Row row, int changeAction, int txModel) {
        switch (changeAction) {
            case 2: {
                this.removePersistence(row);
                break;
            }
            case 1: {
                this.commitPersistence(row);
                break;
            }
            case 4: {
                this.delete(session, row);
                this.remove(row.getPos());
                break;
            }
            case 3: {
                this.delete(session, row);
                this.remove(row.getPos());
            }
        }
    }

    @Override
    public void rollbackRow(Session session, Row row, int changeAction, int txModel) {
        switch (changeAction) {
            case 2: {
                if (txModel != 0) break;
                ((RowAVL)row).setNewNodes(this);
                this.indexRow(session, row);
                break;
            }
            case 1: {
                if (txModel != 0) break;
                this.delete(session, row);
                this.remove(row.getPos());
                break;
            }
            case 4: {
                if (txModel == 0) {
                    this.remove(row.getPos());
                    break;
                }
                this.delete(session, row);
                this.remove(row.getPos());
            }
        }
    }

    @Override
    public void release() {
        ArrayUtil.fillArray(this.accessorList, null);
        this.table.database.dataspaceLogger.closeTextCache((Table)this.table);
        this.cache = null;
    }
}

