/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.RowInputInterface;
import com.streamscape.ds.io.rowio.RowOutputInterface;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.persist.CachedObject;
import com.streamscape.ds.persist.DataFileCache;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.PersistentStoreCollection;
import com.streamscape.ds.persist.RowStoreAVL;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.persist.index.NodeAVL;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.persist.row.RowAVL;
import com.streamscape.ds.persist.row.RowAVLDisk;
import com.streamscape.ds.persist.row.RowAction;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RowStoreAVLDisk
extends RowStoreAVL {
    DataFileCache cache;
    RowOutputInterface rowOut;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();

    public RowStoreAVLDisk(PersistentStoreCollection manager, DataFileCache cache, Table table) {
        this.database = table.database;
        this.manager = manager;
        this.table = table;
        this.indexList = table.getIndexList();
        this.accessorList = new CachedObject[this.indexList.length];
        this.cache = cache;
        if (cache != null) {
            this.rowOut = cache.rowOut.duplicate();
            cache.adjustStoreCount(1);
        }
        manager.setStore(table, this);
    }

    @Override
    public boolean isMemory() {
        return false;
    }

    @Override
    public int getAccessCount() {
        return this.cache.getAccessCount();
    }

    @Override
    public void set(CachedObject object) {
        this.database.txManager.setTransactionInfo(object);
    }

    @Override
    public CachedObject get(int key) {
        CachedObject object = this.cache.get(key, (PersistentStore)this, false);
        return object;
    }

    @Override
    public CachedObject get(int key, boolean keep) {
        CachedObject object = this.cache.get(key, (PersistentStore)this, keep);
        return object;
    }

    @Override
    public CachedObject get(CachedObject object, boolean keep) {
        object = this.cache.get(object, (PersistentStore)this, keep);
        return object;
    }

    @Override
    public int getStorageSize(int i) {
        return this.cache.get(i, (PersistentStore)this, false).getStorageSize();
    }

    @Override
    public void add(CachedObject object) {
        int size = object.getRealSize(this.rowOut);
        size += this.indexList.length * 16;
        size = this.rowOut.getStorageSize(size);
        object.setStorageSize(size);
        this.cache.add(object);
        this.storageSize += (long)size;
    }

    @Override
    public CachedObject get(RowInputInterface in) {
        try {
            return new RowAVLDisk(this.table, in);
        }
        catch (IOException e) {
            throw Error.error(466, e);
        }
    }

    @Override
    public CachedObject getNewInstance(int size) {
        return null;
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object, boolean tx) {
        RowAVLDisk row = new RowAVLDisk(this.table, (Object[])object, this);
        this.add(row);
        if (tx) {
            RowAction.addInsertAction(session, this.table, row);
        }
        return row;
    }

    @Override
    public void indexRow(Session session, Row row) {
        try {
            super.indexRow(session, row);
        }
        catch (DataspaceException e) {
            this.database.txManager.removeTransactionInfo(row);
            throw e;
        }
    }

    @Override
    public void removeAll() {
        this.elementCount.set(0L);
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public void remove(int i) {
        this.storageSize -= (long)this.cache.remove(i, this);
    }

    @Override
    public void removePersistence(int i) {
    }

    @Override
    public void release(int i) {
        this.cache.release(i);
    }

    @Override
    public void commitPersistence(CachedObject row) {
    }

    @Override
    public void commitRow(Session session, Row row, int changeAction, int txModel) {
        Object[] data = row.getData();
        switch (changeAction) {
            case 2: {
                this.database.dataspaceLogger.writeDeleteStatement(session, (Table)this.table, data);
                if (txModel != 0) break;
                this.remove(row.getPos());
                break;
            }
            case 1: {
                this.database.dataspaceLogger.writeInsertStatement(session, row, (Table)this.table);
                break;
            }
            case 4: {
                if (txModel != 0) break;
                this.remove(row.getPos());
                break;
            }
            case 3: {
                this.delete(session, row);
                this.database.txManager.removeTransactionInfo(row);
                this.remove(row.getPos());
            }
        }
    }

    @Override
    public void commitRowWith2PCLogOnly(Session session, Row row, int changeAction, int txModel) {
        Object[] data = row.getData();
        switch (changeAction) {
            case 2: {
                this.database.dataspaceLogger.writeDeleteStatement(session, (Table)this.table, data);
                break;
            }
            case 1: {
                this.database.dataspaceLogger.writeInsertStatement(session, row, (Table)this.table);
                break;
            }
            case 4: {
                break;
            }
        }
    }

    @Override
    public void commitRowWith2PCNoLog(Session session, Row row, int changeAction, int txModel) {
        switch (changeAction) {
            case 2: {
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                this.delete(session, row);
                this.database.txManager.removeTransactionInfo(row);
                this.remove(row.getPos());
            }
        }
    }

    @Override
    public void rollbackRow(Session session, Row row, int changeAction, int txModel) {
        switch (changeAction) {
            case 2: {
                if (txModel != 0) break;
                row = (Row)this.get(row, true);
                ((RowAVL)row).setNewNodes(this);
                row.keepInMemory(false);
                this.indexRow(session, row);
                break;
            }
            case 1: {
                if (txModel != 0) break;
                this.delete(session, row);
                this.remove(row.getPos());
                break;
            }
            case 4: {
                if (txModel != 0) break;
                this.remove(row.getPos());
            }
        }
    }

    @Override
    public DataFileCache getCache() {
        return this.cache;
    }

    @Override
    public void setCache(DataFileCache cache) {
        this.cache = cache;
    }

    @Override
    public void release() {
        ArrayUtil.fillArray(this.accessorList, null);
        this.cache.adjustStoreCount(-1);
        this.cache = null;
        this.elementCount.set(0L);
    }

    @Override
    public CachedObject getAccessor(Index key) {
        NodeAVL node = (NodeAVL)this.accessorList[key.getPosition()];
        if (node == null) {
            return null;
        }
        RowAVL row = (RowAVL)this.get(node.getPos(), false);
        node = row.getNode(key.getPosition());
        this.accessorList[key.getPosition()] = node;
        return node;
    }

    @Override
    public void setAccessor(Index key, int accessor) {
        CachedObject object = this.get(accessor, false);
        if (object != null) {
            NodeAVL node = ((RowAVL)object).getNode(key.getPosition());
            object = node;
        }
        this.setAccessor(key, object);
    }

    @Override
    public void resetAccessorKeys(Index[] keys) {
        if (this.indexList.length == 0 || this.accessorList[0] == null) {
            this.indexList = keys;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        throw Error.runtimeError(201, "RowStoreAVLDisk");
    }

    @Override
    public void writeLock() {
        this.writeLock.lock();
    }

    @Override
    public void writeUnlock() {
        this.writeLock.unlock();
    }

    @Override
    public void readLock() {
        this.readLock.lock();
    }

    @Override
    public void readUnlock() {
        this.readLock.unlock();
    }
}

