/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.RowInputInterface;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.persist.CachedObject;
import com.streamscape.ds.persist.DataFileCache;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.PersistentStoreCollection;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.persist.index.IndexAVL;
import com.streamscape.ds.persist.index.NodeAVL;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.persist.row.RowAVL;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableBase;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.Type;
import java.util.concurrent.atomic.AtomicLong;

public abstract class RowStoreAVL
implements PersistentStore {
    Session session;
    DataspaceStore database;
    PersistentStoreCollection manager;
    Index[] indexList = Index.emptyArray;
    CachedObject[] accessorList = CachedObject.emptyArray;
    TableBase table;
    AtomicLong elementCount = new AtomicLong();
    long storageSize;
    private long timestamp;
    PersistentStore[] subStores = PersistentStore.emptyArray;

    @Override
    public TableBase getTable() {
        return this.table;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public abstract boolean isMemory();

    @Override
    public void setMemory(boolean mode) {
    }

    @Override
    public abstract int getAccessCount();

    @Override
    public abstract void set(CachedObject var1);

    @Override
    public abstract CachedObject get(int var1, boolean var2);

    @Override
    public abstract CachedObject get(CachedObject var1, boolean var2);

    @Override
    public abstract int getStorageSize(int var1);

    @Override
    public abstract void add(CachedObject var1);

    @Override
    public abstract CachedObject get(RowInputInterface var1);

    @Override
    public abstract CachedObject getNewInstance(int var1);

    @Override
    public abstract CachedObject getNewCachedObject(Session var1, Object var2, boolean var3);

    @Override
    public abstract void removePersistence(int var1);

    @Override
    public abstract void removeAll();

    @Override
    public abstract void remove(int var1);

    @Override
    public abstract void release(int var1);

    @Override
    public abstract void commitPersistence(CachedObject var1);

    @Override
    public abstract DataFileCache getCache();

    @Override
    public abstract void setCache(DataFileCache var1);

    @Override
    public abstract void release();

    @Override
    public PersistentStore getAccessorStore(Index index) {
        return null;
    }

    @Override
    public CachedObject getAccessor(Index key) {
        int position = key.getPosition();
        if (position >= this.accessorList.length) {
            throw Error.runtimeError(201, "RowStoreAVL");
        }
        return this.accessorList[position];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Session session, Row row) {
        this.writeLock();
        try {
            int i;
            row = (Row)this.get(row, false);
            for (i = 0; i < this.indexList.length; ++i) {
                this.indexList[i].delete(session, this, row);
            }
            for (i = 0; i < this.subStores.length; ++i) {
                this.subStores[i].delete(session, row);
            }
            row.delete(this);
            this.elementCount.decrementAndGet();
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void indexRow(Session session, Row row) {
        int i;
        this.writeLock();
        try {
            for (i = 0; i < this.indexList.length; ++i) {
                this.indexList[i].insert(session, this, row);
            }
            int j = 0;
            try {
                for (j = 0; j < this.subStores.length; ++j) {
                    this.subStores[j].indexRow(session, row);
                }
            }
            catch (DataspaceException e) {
                int count = j;
                for (j = 0; j < count; ++j) {
                    this.subStores[j].delete(session, row);
                }
                throw e;
            }
            this.elementCount.incrementAndGet();
        }
        catch (DataspaceException e) {
            int count = i;
            for (i = 0; i < count; ++i) {
                this.indexList[i].delete(session, this, row);
            }
            this.remove(row.getPos());
            throw e;
        }
        catch (Throwable t) {
            int count = i;
            for (i = 0; i < count; ++i) {
                this.indexList[i].delete(session, this, row);
            }
            throw Error.error(458, t);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void indexRows(Session session) {
        this.writeLock();
        try {
            for (int i = 1; i < this.indexList.length; ++i) {
                this.setAccessor(this.indexList[i], null);
            }
            RowIterator it = this.rowIterator();
            while (it.hasNext()) {
                Row row = it.getNextRow();
                ((RowAVL)row).clearNonPrimaryNodes();
                for (int i = 1; i < this.indexList.length; ++i) {
                    this.indexList[i].insert(session, this, row);
                }
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public final RowIterator rowIterator() {
        Index index = this.indexList[0];
        for (int i = 0; i < this.indexList.length; ++i) {
            if (!this.indexList[i].isClustered()) continue;
            index = this.indexList[i];
            break;
        }
        return index.firstRow(this);
    }

    @Override
    public void setAccessor(Index key, CachedObject accessor) {
        this.accessorList[key.getPosition()] = accessor;
    }

    @Override
    public void setAccessor(Index key, int accessor) {
    }

    @Override
    public void resetAccessorKeys(Index[] keys) {
        int position;
        Index[] oldIndexList = this.indexList;
        if (this.indexList.length == 0 || this.accessorList[0] == null) {
            this.indexList = keys;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        if (this.indexList == keys) {
            return;
        }
        CachedObject[] oldAccessors = this.accessorList;
        int limit = this.indexList.length;
        int diff = keys.length - this.indexList.length;
        if (diff < -1) {
            throw Error.runtimeError(201, "RowStoreAV");
        }
        if (diff == -1) {
            limit = keys.length;
        } else {
            if (diff == 0) {
                throw Error.runtimeError(201, "RowStoreAV");
            }
            if (diff != 1) {
                for (position = 0; position < limit && this.indexList[position] == keys[position]; ++position) {
                }
                Index[] tempKeys = (Index[])ArrayUtil.toAdjustedArray(this.indexList, null, position, 1);
                tempKeys[position] = keys[position];
                this.resetAccessorKeys(tempKeys);
                this.resetAccessorKeys(keys);
                return;
            }
        }
        while (position < limit && this.indexList[position] == keys[position]) {
            ++position;
        }
        this.accessorList = (CachedObject[])ArrayUtil.toAdjustedArray(this.accessorList, null, position, diff);
        this.indexList = keys;
        try {
            if (diff > 0) {
                this.insertIndexNodes(this.indexList[0], this.indexList[position]);
            } else {
                this.dropIndexFromRows(this.indexList[0], oldIndexList[position]);
            }
        }
        catch (DataspaceException e) {
            this.accessorList = oldAccessors;
            this.indexList = oldIndexList;
            throw e;
        }
    }

    @Override
    public Index[] getAccessorKeys() {
        return this.indexList;
    }

    @Override
    public long elementCount() {
        Index index = this.indexList[0];
        if (this.elementCount.get() < 0L) {
            this.readLock();
            try {
                this.elementCount.set(((IndexAVL)index).getNodeCount(this.session, this));
            }
            finally {
                this.readUnlock();
            }
        }
        return this.elementCount.get();
    }

    @Override
    public long elementCountGetOnly() {
        this.readLock();
        try {
            long l = this.elementCount.get();
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long elementCount(Session session) {
        int txControl;
        Index index = this.indexList[0];
        if (session != null && (txControl = session.dataspaceStore.txManager.getTransactionControl()) != 0) {
            switch (this.table.getTableType()) {
                case 4: 
                case 6: 
                case 8: 
                case 15: 
                case 16: {
                    this.readLock();
                    try {
                        long l = ((IndexAVL)index).getNodeCount(session, this);
                        return l;
                    }
                    finally {
                        this.readUnlock();
                    }
                }
            }
        }
        if (this.elementCount.get() < 0L) {
            this.readLock();
            try {
                this.elementCount.set(((IndexAVL)index).getNodeCount(session, this));
            }
            finally {
                this.readUnlock();
            }
        }
        return this.elementCount.get();
    }

    @Override
    public int elementCountUnique(Index index) {
        return 0;
    }

    @Override
    public void setElementCount(Index key, long size, long uniqueSize) {
        this.elementCount.set(size);
    }

    @Override
    public final void moveData(Session session, PersistentStore other, int colindex, int adjust) {
        Type oldtype = null;
        Type newtype = null;
        Object colvalue = null;
        if (adjust >= 0 && colindex != -1) {
            ColumnSchema column = ((Table)this.table).getColumn(colindex);
            colvalue = column.getDefaultValue(session);
            newtype = ((Table)this.table).getColumnTypes()[colindex];
        }
        if (adjust <= 0 && colindex != -1) {
            oldtype = ((Table)other.getTable()).getColumnTypes()[colindex];
        }
        try {
            Object[] olddata;
            Row row;
            Table table = (Table)this.table;
            RowIterator it = other.rowIterator();
            while (it.hasNext()) {
                row = it.getNextRow();
                olddata = row.getData();
                Object[] data = table.getEmptyRowData();
                Object oldvalue = null;
                if (adjust == 0 && colindex != -1) {
                    oldvalue = olddata[colindex];
                    colvalue = newtype.convertToType(session, oldvalue, oldtype);
                }
                ArrayUtil.copyAdjustArray(olddata, data, colvalue, colindex, adjust);
                table.systemSetIdentityColumn(session, data);
                if (table.hasGeneratedColumn()) {
                    table.setGeneratedColumns(session, data);
                }
                table.enforceTypeLimits(session, data);
                table.enforceRowConstraints(session, data);
                Row newrow = (Row)this.getNewCachedObject(session, data, false);
                this.indexRow(session, newrow);
            }
            if (table.isTemp()) {
                return;
            }
            if (oldtype != null && oldtype.isLobType()) {
                it = other.rowIterator();
                while (it.hasNext()) {
                    row = it.getNextRow();
                    olddata = row.getData();
                    Object oldvalue = olddata[colindex];
                    if (oldvalue == null) continue;
                    session.sessionData.adjustLobUsageCount(oldvalue, -1);
                }
            }
            if (newtype != null && newtype.isLobType()) {
                it = this.rowIterator();
                while (it.hasNext()) {
                    row = it.getNextRow();
                    Object[] data = row.getData();
                    Object value = data[colindex];
                    if (value == null) continue;
                    session.sessionData.adjustLobUsageCount(value, 1);
                }
            }
        }
        catch (OutOfMemoryError e) {
            throw Error.error(460);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reindex(Session session, Index index) {
        this.writeLock();
        try {
            this.setAccessor(index, null);
            RowIterator it = this.table.rowIterator(this);
            while (it.hasNext()) {
                RowAVL row = (RowAVL)it.getNextRow();
                row.getNode(index.getPosition()).delete();
                index.insert(session, this, row);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void writeLock() {
    }

    @Override
    public void writeUnlock() {
    }

    @Override
    public void readLock() {
    }

    @Override
    public void readUnlock() {
    }

    void dropIndexFromRows(Index primaryIndex, Index oldIndex) {
        RowIterator it = primaryIndex.firstRow(this);
        int position = oldIndex.getPosition() - 1;
        while (it.hasNext()) {
            Row row = it.getNextRow();
            int i = position - 1;
            NodeAVL backnode = ((RowAVL)row).getNode(0);
            while (i-- > 0) {
                backnode = backnode.nNext;
            }
            backnode.nNext = backnode.nNext.nNext;
        }
    }

    /*
     * Exception decompiling
     */
    boolean insertIndexNodes(Index primaryIndex, Index newIndex) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

