/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.lib.file.RandomAccessInterface;
import java.io.IOException;
import java.io.InputStream;

public class RandomAccessInputStream
extends InputStream {
    private RandomAccessInterface dataFile;

    public RandomAccessInputStream(RandomAccessInterface dataFile) {
        this.dataFile = dataFile;
    }

    @Override
    public int read() throws IOException {
        return this.dataFile.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.dataFile.getFilePointer() + (long)len > this.dataFile.length()) {
            len = (int)(this.dataFile.length() - this.dataFile.getFilePointer());
        }
        this.dataFile.read(b, off, len);
        return len;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        this.dataFile.seek(0L);
    }

    @Override
    public long skip(long n) throws IOException {
        this.dataFile.seek(this.dataFile.getFilePointer() + n);
        return n;
    }

    public void seek(long n) throws IOException {
        this.dataFile.seek(n);
    }

    public void synch() throws IOException {
        this.dataFile.synch();
    }

    public long getSize() throws IOException {
        return this.dataFile.length();
    }

    public void setLength(int length) {
        this.dataFile.setLength(length);
    }
}

