/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.lib.HsqlByteArrayOutputStream;
import com.streamscape.ds.lib.InputStreamInterface;
import com.streamscape.ds.lib.java.JavaSystem;
import com.streamscape.ds.lib.store.BitMap;
import com.streamscape.ds.persist.ScaledRAFile;
import com.streamscape.ds.persist.ScaledRAFileSimple;
import com.streamscape.lib.file.RandomAccessInterface;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class RAShadowFile {
    final DataspaceStore database;
    final String pathName;
    final RandomAccessInterface source;
    RandomAccessInterface dest;
    final int pageSize;
    final long maxSize;
    final BitMap bitMap;
    boolean zeroPageSet;
    long savedLength;
    long synchLength;
    HsqlByteArrayOutputStream byteArrayOutputStream = new HsqlByteArrayOutputStream(new byte[0]);

    RAShadowFile(DataspaceStore database, RandomAccessInterface source, String pathName, long maxSize, int pageSize) {
        this.database = database;
        this.pathName = pathName;
        this.source = source;
        this.pageSize = pageSize;
        this.maxSize = maxSize;
        int bitSize = (int)(maxSize / (long)pageSize);
        if (maxSize % (long)pageSize != 0L) {
            ++bitSize;
        }
        this.bitMap = new BitMap(bitSize);
    }

    void copy(long fileOffset, int size) throws IOException {
        if (!this.zeroPageSet) {
            this.copy(0);
            this.bitMap.set(0);
            this.zeroPageSet = true;
        }
        if (fileOffset >= this.maxSize) {
            return;
        }
        long endOffset = fileOffset + (long)size;
        int startPageOffset = (int)(fileOffset / (long)this.pageSize);
        int endPageOffset = (int)(endOffset / (long)this.pageSize);
        if (endOffset % (long)this.pageSize == 0L) {
            --endPageOffset;
        }
        while (startPageOffset <= endPageOffset) {
            this.copy(startPageOffset);
            ++startPageOffset;
        }
    }

    private void copy(int pageOffset) throws IOException {
        if (this.bitMap.set(pageOffset) == 1) {
            return;
        }
        long position = (long)pageOffset * (long)this.pageSize;
        int readSize = this.pageSize;
        if (this.maxSize - position < (long)this.pageSize) {
            readSize = (int)(this.maxSize - position);
        }
        if (this.dest == null) {
            this.open();
        }
        long writePos = this.dest.length();
        try {
            byte[] buffer = new byte[this.pageSize + 12];
            this.byteArrayOutputStream.setBuffer(buffer);
            this.byteArrayOutputStream.writeInt(this.pageSize);
            this.byteArrayOutputStream.writeLong(position);
            this.source.seek(position);
            this.source.read(buffer, 12, readSize);
            this.dest.seek(writePos);
            this.dest.write(buffer, 0, buffer.length);
            this.savedLength = writePos + (long)buffer.length;
        }
        catch (Throwable t) {
            this.bitMap.unset(pageOffset);
            this.dest.seek(0L);
            this.dest.setLength(writePos);
            this.close();
            this.database.dataspaceLogger.logWarningEvent("pos" + position + " " + readSize, t);
            throw JavaSystem.toIOException(t);
        }
    }

    private void open() throws IOException {
        this.dest = this.database.dataspaceLogger.isStoredFileAccess() ? ScaledRAFile.newScaledRAFile(this.database, this.pathName, false, 3) : new ScaledRAFileSimple(this.database, this.pathName, "rws");
    }

    void close() throws IOException {
        if (this.dest != null) {
            this.dest.synch();
            this.dest.close();
            this.dest = null;
        }
    }

    public void synch() {
        if (this.dest != null) {
            this.synchLength = this.savedLength;
            this.dest.synch();
        }
    }

    public long getSavedLength() {
        return this.savedLength;
    }

    public InputStreamInterface getInputStream() {
        return new InputStreamShadow();
    }

    private static RandomAccessInterface getStorage(DataspaceStore database, String pathName, String openMode) throws IOException {
        if (database.dataspaceLogger.isStoredFileAccess()) {
            return ScaledRAFile.newScaledRAFile(database, pathName, openMode.equals("r"), 3);
        }
        return new ScaledRAFileSimple(database, pathName, openMode);
    }

    public static void restoreFile(DataspaceStore database, String sourceName, String destName) throws IOException {
        RandomAccessInterface source = RAShadowFile.getStorage(database, sourceName, "r");
        RandomAccessInterface dest = RAShadowFile.getStorage(database, destName, "rw");
        while (source.getFilePointer() != source.length()) {
            int size = source.readInt();
            long position = source.readLong();
            byte[] buffer = new byte[size];
            source.read(buffer, 0, buffer.length);
            dest.seek(position);
            dest.write(buffer, 0, buffer.length);
        }
        source.close();
        dest.synch();
        dest.close();
    }

    class InputStreamShadow
    implements InputStreamInterface {
        FileInputStream is;
        long limitSize = 0L;
        long fetchedSize = 0L;
        boolean initialised = false;

        InputStreamShadow() {
        }

        @Override
        public int read() throws IOException {
            if (!this.initialised) {
                this.initialise();
            }
            if (this.fetchedSize == this.limitSize) {
                return -1;
            }
            int byteread = this.is.read();
            if (byteread < 0) {
                throw new IOException("backup file not complete " + this.fetchedSize + " " + this.limitSize);
            }
            ++this.fetchedSize;
            return byteread;
        }

        @Override
        public int read(byte[] bytes) throws IOException {
            return this.read(bytes, 0, bytes.length);
        }

        @Override
        public int read(byte[] bytes, int offset, int length) throws IOException {
            int count;
            if (!this.initialised) {
                this.initialise();
            }
            if (this.fetchedSize == this.limitSize) {
                return -1;
            }
            if (this.limitSize >= 0L && this.limitSize - this.fetchedSize < (long)length) {
                length = (int)(this.limitSize - this.fetchedSize);
            }
            if ((count = this.is.read(bytes, offset, length)) < 0) {
                throw new IOException("backup file not complete " + this.fetchedSize + " " + this.limitSize);
            }
            this.fetchedSize += (long)count;
            return count;
        }

        @Override
        public long skip(long count) throws IOException {
            return 0L;
        }

        @Override
        public int available() throws IOException {
            return 0;
        }

        @Override
        public void close() throws IOException {
            if (this.is != null) {
                this.is.close();
            }
        }

        @Override
        public void setSizeLimit(long count) {
            this.limitSize = count;
        }

        @Override
        public long getSizeLimit() {
            if (!this.initialised) {
                this.initialise();
            }
            return this.limitSize;
        }

        private void initialise() {
            this.limitSize = RAShadowFile.this.synchLength;
            RAShadowFile.this.database.dataspaceLogger.logDetailEvent("shadow file size for backup: " + this.limitSize);
            if (this.limitSize > 0L) {
                try {
                    this.is = new FileInputStream(RAShadowFile.this.pathName);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            this.initialised = true;
        }
    }
}

